/*
 * Decompiled with CFR 0.152.
 */
package tschipp.carryon.common.pickupcondition;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import java.util.Map;
import net.minecraft.commands.arguments.blocks.BlockStateParser;
import net.minecraft.core.Registry;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import tschipp.carryon.platform.Services;
import tschipp.carryon.utils.StringHelper;

public class PickupCondition {
    public static Codec<PickupCondition> CODEC = Codec.STRING.comapFlatMap(PickupCondition::of, pickupCondition -> pickupCondition.str);
    private String str;
    private String cond;
    private String match;
    private boolean wildcards;

    private PickupCondition(String str, String cond, String match) {
        this.str = str;
        this.cond = cond;
        this.match = match;
    }

    public static DataResult<PickupCondition> of(String str) {
        if (!str.contains("(") || !str.endsWith(")")) {
            return DataResult.error((String)("Error while parsing: " + str + ". Pickup Condition must contain proper brackets."));
        }
        String cond = str.substring(str.indexOf("(") + 1, str.length() - 1);
        String match = str.substring(0, str.indexOf("("));
        PickupCondition condition = new PickupCondition(str, cond, match);
        if (match.contains("*")) {
            condition.wildcards = true;
        }
        return DataResult.success((Object)condition);
    }

    public boolean matches(BlockState state) {
        if (this.wildcards) {
            String name = this.match.contains("[") ? this.match.substring(0, this.match.indexOf("[")) : this.match;
            String[] split = name.replace("*", ",").split(",");
            Object stateName = Registry.f_122824_.m_7981_((Object)state.m_60734_()).toString();
            if (StringHelper.matchesWildcards((String)stateName, split)) {
                if (this.match.contains("[")) {
                    stateName = (String)stateName + this.match.substring(this.match.indexOf("["));
                    BlockStateParser.BlockResult result = this.parseState((String)stateName);
                    return this.matchesProperties(state, result.f_234749_());
                }
                return true;
            }
            return false;
        }
        BlockStateParser.BlockResult res = this.parseState(this.match);
        return res.f_234748_().m_60734_() == state.m_60734_() && this.matchesProperties(state, res.f_234749_());
    }

    public boolean matches(Entity entity) {
        String entityName = Registry.f_122826_.m_7981_((Object)entity.m_6095_()).toString();
        if (this.wildcards) {
            String[] split = this.match.replace("*", ",").split(",");
            return StringHelper.matchesWildcards(entityName, split);
        }
        return entityName.equals(this.match);
    }

    public String getCondition() {
        return this.cond;
    }

    public boolean isFulfilled(ServerPlayer player) {
        return Services.GAMESTAGES.hasStage((Player)player, this.cond);
    }

    private BlockStateParser.BlockResult parseState(String state) {
        try {
            BlockStateParser.BlockResult result = BlockStateParser.m_234704_((Registry)Registry.f_122824_, (String)state, (boolean)false);
            return result;
        }
        catch (CommandSyntaxException e) {
            e.printStackTrace();
            return null;
        }
    }

    private boolean matchesProperties(BlockState state, Map<Property<?>, Comparable<?>> props) {
        for (Map.Entry<Property<?>, Comparable<?>> entry : props.entrySet()) {
            Comparable val = state.m_61143_(entry.getKey());
            if (val == entry.getValue()) continue;
            return false;
        }
        return true;
    }
}

