/*
 * Decompiled with CFR 0.152.
 */
package fuzs.diagonalfences.world.level.block;

import com.google.common.base.Stopwatch;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import fuzs.diagonalfences.DiagonalFences;
import fuzs.diagonalfences.api.world.level.block.DiagonalBlock;
import fuzs.diagonalfences.api.world.level.block.EightWayDirection;
import fuzs.diagonalfences.world.phys.shapes.NoneVoxelShape;
import fuzs.diagonalfences.world.phys.shapes.VoxelCollection;
import fuzs.diagonalfences.world.phys.shapes.VoxelUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CrossCollisionBlock;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public interface StarCollisionBlock
extends DiagonalBlock {
    public static final Map<List<Float>, VoxelShape[]> DIMENSIONS_TO_SHAPE_CACHE = Maps.newHashMap();
    public static final Map<EightWayDirection, BooleanProperty> DIRECTION_TO_PROPERTY_MAP = (Map)Util.m_137469_((Object)Maps.newEnumMap(EightWayDirection.class), directions -> {
        directions.put(EightWayDirection.NORTH, PipeBlock.f_55148_);
        directions.put(EightWayDirection.EAST, PipeBlock.f_55149_);
        directions.put(EightWayDirection.SOUTH, PipeBlock.f_55150_);
        directions.put(EightWayDirection.WEST, PipeBlock.f_55151_);
        directions.put(EightWayDirection.NORTH_EAST, DiagonalBlock.NORTH_EAST);
        directions.put(EightWayDirection.SOUTH_EAST, DiagonalBlock.SOUTH_EAST);
        directions.put(EightWayDirection.SOUTH_WEST, DiagonalBlock.SOUTH_WEST);
        directions.put(EightWayDirection.NORTH_WEST, DiagonalBlock.NORTH_WEST);
    });

    public boolean canConnect(BlockGetter var1, BlockPos var2, BlockState var3, Direction var4);

    default public BlockState addDefaultStates(BlockState defaultState) {
        return (BlockState)((BlockState)((BlockState)((BlockState)defaultState.m_61124_((Property)DiagonalBlock.NORTH_EAST, (Comparable)Boolean.FALSE)).m_61124_((Property)DiagonalBlock.SOUTH_EAST, (Comparable)Boolean.FALSE)).m_61124_((Property)DiagonalBlock.SOUTH_WEST, (Comparable)Boolean.FALSE)).m_61124_((Property)DiagonalBlock.NORTH_WEST, (Comparable)Boolean.FALSE);
    }

    default public void createBlockStateDefinition2(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{DiagonalBlock.NORTH_EAST, DiagonalBlock.SOUTH_EAST, DiagonalBlock.SOUTH_WEST, DiagonalBlock.NORTH_WEST});
    }

    default public int makeIndex(BlockState stateIn) {
        int index = 0;
        for (Map.Entry<EightWayDirection, BooleanProperty> entry : DIRECTION_TO_PROPERTY_MAP.entrySet()) {
            if (!((Boolean)stateIn.m_61143_((Property)entry.getValue())).booleanValue()) continue;
            index |= entry.getKey().getHorizontalIndex();
        }
        return index;
    }

    default public BlockState makeStateForPlacement(BlockState placementState, BlockGetter blockGetter, BlockPos basePos, FluidState fluidState) {
        placementState = (BlockState)placementState.m_61124_((Property)CrossCollisionBlock.f_52313_, (Comparable)Boolean.valueOf(fluidState.m_76152_() == Fluids.f_76193_));
        placementState = this.withDirections(EightWayDirection.getCardinalDirections(), basePos, placementState, (mutablePos, newPlacementState, direction) -> this.canConnect(blockGetter, mutablePos, blockGetter.m_8055_(mutablePos), direction.toDirection().m_122424_()));
        placementState = this.withDirections(EightWayDirection.getIntercardinalDirections(), basePos, placementState, (pos, newPlacementState, direction) -> {
            if (!this.canConnectToMe(blockGetter.m_8055_(pos), direction.opposite())) return false;
            if (!Stream.of(direction.getCardinalNeighbors()).map(DIRECTION_TO_PROPERTY_MAP::get).noneMatch(arg_0 -> ((BlockState)newPlacementState).m_61143_(arg_0))) return false;
            return true;
        });
        return placementState;
    }

    default public BlockState withDirections(EightWayDirection[] directions, BlockPos basePos, BlockState placementState, DirectionStatePredicate predicate) {
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        for (EightWayDirection direction : directions) {
            mutablePos.m_122154_((Vec3i)basePos, direction.getX(), direction.getY(), direction.getZ());
            placementState = (BlockState)placementState.m_61124_((Property)DIRECTION_TO_PROPERTY_MAP.get((Object)direction), (Comparable)Boolean.valueOf(predicate.test((BlockPos)mutablePos, placementState, direction)));
        }
        return placementState;
    }

    default public BlockState updateShape2(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos, BlockState newState) {
        if (facing.m_122434_().m_122480_() == Direction.Plane.HORIZONTAL) {
            BlockPos.MutableBlockPos diagonalPos = new BlockPos.MutableBlockPos();
            for (EightWayDirection direction : EightWayDirection.toEightWayDirection(facing).getIntercardinalNeighbors()) {
                diagonalPos.m_122154_((Vec3i)currentPos, direction.getX(), direction.getY(), direction.getZ());
                BlockState diagonalState = level.m_8055_((BlockPos)diagonalPos);
                boolean isBlocked = false;
                for (EightWayDirection cardinal : direction.getCardinalNeighbors()) {
                    isBlocked |= ((Boolean)newState.m_61143_((Property)DIRECTION_TO_PROPERTY_MAP.get((Object)cardinal))).booleanValue();
                }
                newState = (BlockState)newState.m_61124_((Property)DIRECTION_TO_PROPERTY_MAP.get((Object)direction), (Comparable)Boolean.valueOf(!isBlocked && this.canConnectToMe(diagonalState, direction)));
            }
            return newState;
        }
        return null;
    }

    default public void updateIndirectNeighbourShapes2(BlockState state, LevelAccessor level, BlockPos pos, int flags, int recursionLeft) {
        BlockPos.MutableBlockPos diagonalPos = new BlockPos.MutableBlockPos();
        for (EightWayDirection direction : EightWayDirection.getIntercardinalDirections()) {
            StarCollisionBlock starCollisionBlock;
            diagonalPos.m_122154_((Vec3i)pos, direction.getX(), direction.getY(), direction.getZ());
            BlockState diagonalState = level.m_8055_((BlockPos)diagonalPos);
            Block block = diagonalState.m_60734_();
            if (!(block instanceof StarCollisionBlock) || !(starCollisionBlock = (StarCollisionBlock)block).supportsDiagonalConnections()) continue;
            boolean isBlocked = false;
            for (EightWayDirection cardinal : direction.opposite().getCardinalNeighbors()) {
                isBlocked |= ((Boolean)diagonalState.m_61143_((Property)DIRECTION_TO_PROPERTY_MAP.get((Object)cardinal))).booleanValue();
            }
            BlockState newState = (BlockState)diagonalState.m_61124_((Property)DIRECTION_TO_PROPERTY_MAP.get((Object)direction.opposite()), (Comparable)Boolean.valueOf(!isBlocked && starCollisionBlock.canConnectToMe(level.m_8055_(pos), direction)));
            Block.m_49908_((BlockState)diagonalState, (BlockState)newState, (LevelAccessor)level, (BlockPos)diagonalPos, (int)flags, (int)recursionLeft);
        }
    }

    default public VoxelShape[] getShapes(float nodeWidth, float extensionWidth, float nodeHeight, float extensionBottom, float extensionHeight) {
        ArrayList dimensions = Lists.newArrayList((Object[])new Float[]{Float.valueOf(nodeWidth), Float.valueOf(extensionWidth), Float.valueOf(nodeHeight), Float.valueOf(extensionBottom), Float.valueOf(extensionHeight)});
        return DIMENSIONS_TO_SHAPE_CACHE.computeIfAbsent(dimensions, dimension -> this.makeDiagonalShapes(nodeWidth, extensionWidth, nodeHeight, extensionBottom, extensionHeight));
    }

    default public VoxelCollection[] makeDiagonalShapes(float nodeWidth, float extensionWidth, float nodeHeight, float extensionBottom, float extensionHeight) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        float nodeStart = 8.0f - nodeWidth;
        float nodeEnd = 8.0f + nodeWidth;
        float extensionStart = 8.0f - extensionWidth;
        float extensionEnd = 8.0f + extensionWidth;
        VoxelShape nodeShape = Block.m_49796_((double)nodeStart, (double)0.0, (double)nodeStart, (double)nodeEnd, (double)nodeHeight, (double)nodeEnd);
        Vec3[] sideShape = new Vec3[]{new Vec3((double)extensionStart, (double)extensionBottom, 0.0), new Vec3((double)extensionEnd, (double)extensionHeight, (double)nodeStart)};
        Vec3[] sideParticleShape = new Vec3[]{new Vec3(0.0, (double)extensionBottom, 0.0), new Vec3((double)nodeStart, (double)extensionHeight, (double)nodeStart)};
        VoxelShape[] verticalShapes = (VoxelShape[])Stream.of(EightWayDirection.getCardinalDirections()).map(direction -> direction.transform(sideShape)).map(VoxelUtils::makeCuboidShape).toArray(VoxelShape[]::new);
        VoxelShape[] diagonalShapes = (VoxelShape[])Stream.of(EightWayDirection.getIntercardinalDirections()).map(direction -> this.getDiagonalShape(extensionWidth, extensionBottom, extensionHeight, (EightWayDirection)((Object)direction))).toArray(VoxelShape[]::new);
        VoxelShape[] diagonalParticleShapes = (VoxelShape[])Stream.of(EightWayDirection.getIntercardinalDirections()).map(direction -> {
            Vec3[] edges = sideParticleShape;
            if (direction.getX() != 1) {
                edges = VoxelUtils.flipX(edges);
            }
            if (direction.getZ() != 1) {
                edges = VoxelUtils.flipZ(edges);
            }
            return edges;
        }).map(VoxelUtils::makeCuboidShape).toArray(VoxelShape[]::new);
        VoxelShape[] sideShapes = new VoxelShape[]{verticalShapes[2], verticalShapes[3], verticalShapes[0], verticalShapes[1], diagonalShapes[2], diagonalShapes[3], diagonalShapes[0], diagonalShapes[1]};
        VoxelShape[] particleSideShapes = new VoxelShape[]{verticalShapes[2], verticalShapes[3], verticalShapes[0], verticalShapes[1], diagonalParticleShapes[2], diagonalParticleShapes[3], diagonalParticleShapes[0], diagonalParticleShapes[1]};
        VoxelCollection[] stateShapes = this.constructStateShapes(nodeShape, sideShapes, particleSideShapes);
        DiagonalFences.LOGGER.info("Constructing shapes for nodeWith {}, extensionWidth {}, nodeHeight {}, extensionBottom {}, extensionHeight {} took {} milliseconds", (Object)Float.valueOf(nodeWidth), (Object)Float.valueOf(extensionWidth), (Object)Float.valueOf(nodeHeight), (Object)Float.valueOf(extensionBottom), (Object)Float.valueOf(extensionHeight), (Object)stopwatch.stop().elapsed().toMillis());
        return stateShapes;
    }

    default public VoxelCollection[] constructStateShapes(VoxelShape nodeShape, VoxelShape[] directionalShapes, VoxelShape[] particleDirectionalShapes) {
        VoxelCollection[] stateShapes = new VoxelCollection[(int)Math.pow(2.0, directionalShapes.length)];
        for (int i = 0; i < stateShapes.length; ++i) {
            stateShapes[i] = new VoxelCollection(nodeShape);
            for (int j = 0; j < directionalShapes.length; ++j) {
                if ((i & 1 << j) == 0) continue;
                stateShapes[i].addVoxelShape(directionalShapes[j], particleDirectionalShapes[j]);
            }
        }
        return stateShapes;
    }

    default public VoxelShape getDiagonalShape(float extensionWidth, float extensionBottom, float extensionHeight, EightWayDirection direction) {
        VoxelShape collisionShape = this.getDiagonalCollisionShape(extensionWidth, extensionBottom, extensionHeight, direction);
        extensionWidth = (float)Math.sqrt(extensionWidth * extensionWidth * 2.0f);
        float diagonalSide = 0.70710677f * extensionWidth;
        Vec3[] corners = VoxelUtils.createVectorArray(Float.valueOf(-diagonalSide), Float.valueOf(extensionHeight), Float.valueOf(diagonalSide), Float.valueOf(-diagonalSide + 8.0f), Float.valueOf(extensionHeight), Float.valueOf(diagonalSide + 8.0f), Float.valueOf(-diagonalSide), Float.valueOf(extensionBottom), Float.valueOf(diagonalSide), Float.valueOf(-diagonalSide + 8.0f), Float.valueOf(extensionBottom), Float.valueOf(diagonalSide + 8.0f), Float.valueOf(diagonalSide), Float.valueOf(extensionHeight), Float.valueOf(-diagonalSide), Float.valueOf(diagonalSide + 8.0f), Float.valueOf(extensionHeight), Float.valueOf(-diagonalSide + 8.0f), Float.valueOf(diagonalSide), Float.valueOf(extensionBottom), Float.valueOf(-diagonalSide), Float.valueOf(diagonalSide + 8.0f), Float.valueOf(extensionBottom), Float.valueOf(-diagonalSide + 8.0f));
        Vec3[] edges = VoxelUtils.create12Edges(corners);
        if (direction.getX() != 1) {
            edges = VoxelUtils.flipX(edges);
        }
        if (direction.getZ() != 1) {
            edges = VoxelUtils.flipZ(edges);
        }
        return new NoneVoxelShape(collisionShape, VoxelUtils.scaleDown(edges));
    }

    default public VoxelShape getDiagonalCollisionShape(float extensionWidth, float extensionBottom, float extensionHeight, EightWayDirection direction) {
        VoxelShape collisionShape = Shapes.m_83040_();
        for (int i = 0; i < 8; ++i) {
            int posX = direction.getX() > 0 ? i : 16 - i;
            int posZ = direction.getZ() > 0 ? i : 16 - i;
            VoxelShape cuboidShape = Block.m_49796_((double)((float)posX - extensionWidth), (double)extensionBottom, (double)((float)posZ - extensionWidth), (double)((float)posX + extensionWidth), (double)extensionHeight, (double)((float)posZ + extensionWidth));
            collisionShape = Shapes.m_83110_((VoxelShape)collisionShape, (VoxelShape)cuboidShape);
        }
        return collisionShape;
    }

    @FunctionalInterface
    public static interface DirectionStatePredicate {
        public boolean test(BlockPos var1, BlockState var2, EightWayDirection var3);
    }
}

