/*
 * Decompiled with CFR 0.152.
 */
package com.hidoni.customizableelytra.crafting;

import com.hidoni.customizableelytra.setup.ModItems;
import com.hidoni.customizableelytra.setup.ModRecipes;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ElytraItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class SplitToWingRecipe
extends CustomRecipe {
    Predicate<ItemStack> IS_ELYTRA_ITEM = stack -> stack.m_41720_() instanceof ElytraItem;

    public SplitToWingRecipe(ResourceLocation id) {
        super(id);
    }

    public boolean matches(CraftingContainer inv, Level worldIn) {
        return !this.getElytraItem(inv, this.IS_ELYTRA_ITEM).m_41619_();
    }

    public ItemStack assemble(CraftingContainer inv) {
        CompoundTag wingInfo;
        ItemStack elytraItem = this.getElytraItem(inv, this.IS_ELYTRA_ITEM);
        if (elytraItem.m_41619_()) {
            return ItemStack.f_41583_;
        }
        ItemStack leftWing = new ItemStack((ItemLike)ModItems.ELYTRA_WING.get());
        CompoundTag nbt = elytraItem.m_41784_();
        if (nbt.m_128425_("WingInfo", 10) && (wingInfo = nbt.m_128469_("WingInfo")).m_128425_("left", 10)) {
            leftWing.m_41751_(wingInfo.m_128469_("left"));
        }
        EnchantmentHelper.m_44865_((Map)EnchantmentHelper.m_44831_((ItemStack)elytraItem), (ItemStack)leftWing);
        leftWing.m_41721_(elytraItem.m_41773_());
        leftWing.m_41742_(elytraItem.m_41610_());
        leftWing.m_41787_();
        if (elytraItem.m_41788_()) {
            leftWing.m_41714_(elytraItem.m_41786_());
        }
        return leftWing;
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingContainer inv) {
        NonNullList remainders = super.m_7457_((Container)inv);
        for (int slot = 0; slot < inv.m_6643_(); ++slot) {
            CompoundTag wingInfo;
            ItemStack elytraItem = inv.m_8020_(slot);
            if (!this.IS_ELYTRA_ITEM.test(elytraItem) || !((ItemStack)remainders.get(slot)).m_41619_()) continue;
            ItemStack rightWing = new ItemStack((ItemLike)ModItems.ELYTRA_WING.get());
            CompoundTag nbt = elytraItem.m_41784_();
            if (nbt.m_128425_("WingInfo", 10) && (wingInfo = nbt.m_128469_("WingInfo")).m_128425_("right", 10)) {
                rightWing.m_41751_(wingInfo.m_128469_("right"));
            }
            EnchantmentHelper.m_44865_(Map.of(), (ItemStack)rightWing);
            rightWing.m_41721_(elytraItem.m_41773_());
            rightWing.m_41742_(elytraItem.m_41610_());
            rightWing.m_41787_();
            remainders.set(slot, (Object)rightWing);
        }
        return remainders;
    }

    private ItemStack getElytraItem(CraftingContainer inv, Predicate<ItemStack> itemCheck) {
        ItemStack elytraItem = ItemStack.f_41583_;
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack inventoryItem = inv.m_8020_(i);
            if (inventoryItem.m_41619_()) continue;
            if (!elytraItem.m_41619_() || !itemCheck.test(inventoryItem)) {
                return ItemStack.f_41583_;
            }
            elytraItem = inventoryItem;
        }
        return elytraItem;
    }

    public boolean m_8004_(int width, int height) {
        return width * height >= 2;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRecipes.SPLIT_TO_WING_RECIPE.get();
    }
}

