/*
 * Decompiled with CFR 0.152.
 */
package com.hidoni.customizableelytra.renderers;

import com.google.common.collect.ImmutableList;
import com.hidoni.customizableelytra.mixin.ElytraLayerAccessor;
import com.hidoni.customizableelytra.renderers.models.ElytraWingModel;
import com.hidoni.customizableelytra.setup.ModItems;
import com.hidoni.customizableelytra.util.ElytraCustomizationData;
import com.hidoni.customizableelytra.util.ElytraCustomizationUtil;
import com.hidoni.customizableelytra.util.ElytraInventoryUtil;
import com.hidoni.customizableelytra.util.ElytraTextureUtil;
import com.hidoni.customizableelytra.util.SplitCustomizationHandler;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.model.ElytraModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.ElytraLayer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.PlayerModelPart;
import net.minecraft.world.item.ItemStack;

public class CustomizableElytraLayer<T extends LivingEntity, M extends EntityModel<T>>
extends ElytraLayer<T, M> {
    public static final ResourceLocation TEXTURE_DYEABLE_ELYTRA = new ResourceLocation("customizableelytra", "textures/entity/elytra.png");
    private final ElytraWingModel<T> leftElytraWing;
    private final ElytraWingModel<T> rightElytraWing;

    public CustomizableElytraLayer(RenderLayerParent<T, M> renderLayerParent, EntityModelSet entityModelSet) {
        super(renderLayerParent, entityModelSet);
        this.leftElytraWing = new ElytraWingModel(entityModelSet.m_171103_(ModelLayers.f_171141_), false);
        this.rightElytraWing = new ElytraWingModel(entityModelSet.m_171103_(ModelLayers.f_171141_), true);
    }

    public void m_6494_(PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn, T entitylivingbaseIn, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        ItemStack elytra = ElytraInventoryUtil.tryFindElytra(entitylivingbaseIn);
        if (elytra != ItemStack.f_41583_) {
            matrixStackIn.m_85836_();
            matrixStackIn.m_85837_(0.0, 0.0, 0.125);
            ElytraCustomizationData data = ElytraCustomizationUtil.getData(elytra);
            if (data.type != ElytraCustomizationData.CustomizationType.Split) {
                ElytraModel elytraModel = ((ElytraLayerAccessor)((Object)this)).getElytraModel();
                this.m_117386_().m_102624_(elytraModel);
                ResourceLocation elytraTexture = this.getTextureWithCape(entitylivingbaseIn, elytra.m_41783_(), data.handler.isWingCapeHidden(0));
                data.handler.render(matrixStackIn, bufferIn, data.handler.modifyWingLight(packedLightIn, 0), entitylivingbaseIn, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch, elytraModel, elytraTexture, elytra.m_41790_());
            } else {
                ImmutableList models = ImmutableList.of(this.leftElytraWing, this.rightElytraWing);
                for (ElytraWingModel model : models) {
                    this.m_117386_().m_102624_((EntityModel)model);
                }
                CompoundTag wingInfo = elytra.m_41737_("WingInfo");
                ResourceLocation leftWingTexture = this.getTextureWithCape(entitylivingbaseIn, wingInfo.m_128469_("left"), data.handler.isWingCapeHidden(0));
                ResourceLocation rightWingTexture = this.getTextureWithCape(entitylivingbaseIn, wingInfo.m_128469_("right"), data.handler.isWingCapeHidden(1));
                ((SplitCustomizationHandler)data.handler).render(matrixStackIn, bufferIn, packedLightIn, entitylivingbaseIn, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch, models, leftWingTexture, rightWingTexture, elytra.m_41790_());
            }
            matrixStackIn.m_85849_();
        }
    }

    private ResourceLocation getTextureWithCape(T entitylivingbaseIn, CompoundTag customizationTag, boolean capeHidden) {
        boolean isTextureGrayscale;
        ResourceLocation elytraTexture = null;
        boolean bl = isTextureGrayscale = ElytraCustomizationUtil.getData((CompoundTag)customizationTag).type != ElytraCustomizationData.CustomizationType.None;
        if (!capeHidden && entitylivingbaseIn instanceof AbstractClientPlayer) {
            AbstractClientPlayer abstractclientplayerentity = (AbstractClientPlayer)entitylivingbaseIn;
            if (abstractclientplayerentity.m_108562_() && abstractclientplayerentity.m_108563_() != null) {
                elytraTexture = abstractclientplayerentity.m_108563_();
            } else if (abstractclientplayerentity.m_108555_() && abstractclientplayerentity.m_108561_() != null && abstractclientplayerentity.m_36170_(PlayerModelPart.CAPE)) {
                elytraTexture = abstractclientplayerentity.m_108561_();
            }
        }
        if (elytraTexture == null) {
            elytraTexture = this.getElytraTexture(isTextureGrayscale);
        } else if (isTextureGrayscale) {
            elytraTexture = ElytraTextureUtil.getGrayscale(elytraTexture);
        }
        return elytraTexture;
    }

    public boolean shouldRender(ItemStack stack, LivingEntity entity) {
        return stack.m_41720_() == ModItems.CUSTOMIZABLE_ELYTRA.get();
    }

    public ResourceLocation getElytraTexture(boolean isTextureGrayscale) {
        if (isTextureGrayscale) {
            return TEXTURE_DYEABLE_ELYTRA;
        }
        return ((ElytraLayerAccessor)((Object)this)).getDefaultElytraTexture();
    }
}

