/*
 * Decompiled with CFR 0.152.
 */
package com.hidoni.customizableelytra.util;

import com.hidoni.customizableelytra.util.BannerCustomizationHandler;
import com.hidoni.customizableelytra.util.CustomizationHandler;
import com.hidoni.customizableelytra.util.DyeCustomizationHandler;
import com.hidoni.customizableelytra.util.ElytraCustomizationData;
import com.hidoni.customizableelytra.util.SplitCustomizationHandler;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;

public class ElytraCustomizationUtil {
    public static ElytraCustomizationData getData(ItemStack elytraIn) {
        if (elytraIn.m_41737_("WingInfo") != null) {
            return new ElytraCustomizationData(ElytraCustomizationData.CustomizationType.Split, new SplitCustomizationHandler(elytraIn));
        }
        return ElytraCustomizationUtil.getData(elytraIn.m_41783_());
    }

    public static CompoundTag migrateOldSplitWingFormat(CompoundTag wingIn) {
        if (wingIn == null) {
            return new CompoundTag();
        }
        if (wingIn.m_128425_("color", 99)) {
            CompoundTag newNBT = new CompoundTag();
            CompoundTag displayNBT = new CompoundTag();
            displayNBT.m_128405_("color", wingIn.m_128451_("color"));
            newNBT.m_128365_("display", (Tag)displayNBT);
            return newNBT;
        }
        if (wingIn.m_128425_("Patterns", 9)) {
            CompoundTag newNBT = new CompoundTag();
            CompoundTag blockEntityTagNBT = new CompoundTag();
            blockEntityTagNBT.m_128365_("Patterns", (Tag)wingIn.m_128437_("Patterns", 10));
            blockEntityTagNBT.m_128405_("Base", wingIn.m_128451_("Base"));
            newNBT.m_128365_("BlockEntityTag", (Tag)blockEntityTagNBT);
            return newNBT;
        }
        return wingIn;
    }

    public static ElytraCustomizationData getData(CompoundTag wingIn) {
        CompoundTag wingNBT = ElytraCustomizationUtil.migrateOldSplitWingFormat(wingIn);
        if (wingNBT.m_128441_("display") && wingNBT.m_128469_("display").m_128425_("color", 99)) {
            return new ElytraCustomizationData(ElytraCustomizationData.CustomizationType.Dye, new DyeCustomizationHandler(wingNBT));
        }
        if (wingNBT.m_128441_("BlockEntityTag")) {
            return new ElytraCustomizationData(ElytraCustomizationData.CustomizationType.Banner, new BannerCustomizationHandler(wingNBT));
        }
        return new ElytraCustomizationData(ElytraCustomizationData.CustomizationType.None, new CustomizationHandler(wingNBT.m_128471_("HideCapePattern"), wingNBT.m_128451_("WingLightLevel")));
    }
}

