/*
 * Decompiled with CFR 0.152.
 */
package cjminecraft.doubleslabs.api.support.minecraft;

import cjminecraft.doubleslabs.api.support.IHorizontalSlabSupport;
import cjminecraft.doubleslabs.api.support.SlabSupportProvider;
import cjminecraft.doubleslabs.common.blocks.RaisedCampfireBlock;
import cjminecraft.doubleslabs.common.init.DSBlocks;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.FlintAndSteelItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.phys.BlockHitResult;

@SlabSupportProvider
public class MinecraftCampfireSupport
implements IHorizontalSlabSupport {
    @Override
    public boolean isHorizontalSlab(Block block) {
        return block instanceof CampfireBlock;
    }

    @Override
    public boolean isHorizontalSlab(Item item) {
        return item instanceof BlockItem && ((BlockItem)item).m_40614_() instanceof CampfireBlock;
    }

    @Override
    public SlabType getHalf(BlockGetter world, BlockPos pos, BlockState state) {
        return state.m_60734_() instanceof RaisedCampfireBlock ? SlabType.TOP : SlabType.BOTTOM;
    }

    private Block getRaisedBlock(Block block) {
        if (block == Blocks.f_50683_) {
            return (Block)DSBlocks.RAISED_CAMPFIRE.get();
        }
        if (block == Blocks.f_50684_) {
            return (Block)DSBlocks.RAISED_SOUL_CAMPFIRE.get();
        }
        return (Block)DSBlocks.RAISED_CAMPFIRE.get();
    }

    @Override
    public BlockState getStateForHalf(BlockGetter world, BlockPos pos, BlockState state, SlabType half) {
        if (half == SlabType.TOP) {
            return (BlockState)((BlockState)((BlockState)((BlockState)this.getRaisedBlock(state.m_60734_()).m_49966_().m_61124_((Property)CampfireBlock.f_51230_, (Comparable)((Direction)state.m_61143_((Property)CampfireBlock.f_51230_)))).m_61124_((Property)CampfireBlock.f_51227_, (Comparable)((Boolean)state.m_61143_((Property)CampfireBlock.f_51227_)))).m_61124_((Property)CampfireBlock.f_51228_, (Comparable)((Boolean)state.m_61143_((Property)CampfireBlock.f_51228_)))).m_61124_((Property)CampfireBlock.f_51229_, (Comparable)((Boolean)state.m_61143_((Property)CampfireBlock.f_51229_)));
        }
        return state;
    }

    @Override
    public boolean areSame(Level world, BlockPos pos, BlockState state, ItemStack stack) {
        return stack.m_41720_() instanceof BlockItem && ((BlockItem)stack.m_41720_()).m_40614_() == state.m_60734_();
    }

    @Override
    public InteractionResult onBlockActivated(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        InteractionResult result = state.m_60664_(world, player, hand, hit);
        if (!result.m_19077_()) {
            if (((Boolean)state.m_61143_((Property)CampfireBlock.f_51227_)).booleanValue() && player.m_21120_(hand).m_41720_() instanceof ShovelItem) {
                if (!world.m_5776_()) {
                    world.m_5898_(null, 1009, pos, 0);
                }
                CampfireBlock.m_152749_((Entity)player, (LevelAccessor)world, (BlockPos)pos, (BlockState)state);
                BlockState newState = (BlockState)state.m_61124_((Property)CampfireBlock.f_51227_, (Comparable)Boolean.valueOf(false));
                if (!world.m_5776_()) {
                    world.m_7731_(pos, newState, 3);
                    player.m_21120_(hand).m_41622_(1, (LivingEntity)player, p -> p.m_21190_(hand));
                }
                return InteractionResult.m_19078_((boolean)world.m_5776_());
            }
            if (player.m_21120_(hand).m_41720_() instanceof FlintAndSteelItem && CampfireBlock.m_51321_((BlockState)state)) {
                world.m_5594_(player, pos, SoundEvents.f_11942_, SoundSource.BLOCKS, 1.0f, new Random().nextFloat() * 0.4f + 0.8f);
                world.m_7731_(pos, (BlockState)state.m_61124_((Property)BlockStateProperties.f_61443_, (Comparable)Boolean.valueOf(true)), 11);
                player.m_21120_(hand).m_41622_(1, (LivingEntity)player, p -> p.m_21190_(hand));
                return InteractionResult.m_19078_((boolean)world.m_5776_());
            }
        }
        return result;
    }

    @Override
    public boolean useDoubleSlabModel(BlockState state) {
        return false;
    }

    @Override
    public boolean waterloggableWhenDouble(Level world, BlockPos pos, BlockState state) {
        return true;
    }
}

