/*
 * Decompiled with CFR 0.152.
 */
package cjminecraft.doubleslabs.client;

import cjminecraft.doubleslabs.api.SlabSupport;
import cjminecraft.doubleslabs.api.support.IHorizontalSlabSupport;
import cjminecraft.doubleslabs.client.proxy.ClientProxy;
import cjminecraft.doubleslabs.common.DoubleSlabs;
import cjminecraft.doubleslabs.common.blocks.RaisedCampfireBlock;
import cjminecraft.doubleslabs.common.config.DSConfig;
import com.google.common.collect.Maps;
import com.mojang.math.Transformation;
import com.mojang.math.Vector3f;
import java.util.EnumMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.BlockModelShaper;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.MultiVariant;
import net.minecraft.client.renderer.block.model.Variant;
import net.minecraft.client.renderer.texture.AtlasSet;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.BlockModelRotation;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.client.resources.model.WeightedBakedModel;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.registries.ForgeRegistries;

public class ClientConstants {
    private static final Map<BlockState, Map<Direction, BakedModel>> VERTICAL_SLAB_MODELS = Maps.newIdentityHashMap();
    private static final Map<Item, BakedModel> VERTICAL_SLAB_ITEM_MODELS = Maps.newIdentityHashMap();
    private static final Transformation TRANSFORMATION_2D = new Transformation(null, Vector3f.f_122226_.m_122240_(90.0f), null, null);
    public static final int TINT_OFFSET = 1000;

    public static boolean isTransparent(BlockState state) {
        return !state.m_60767_().m_76333_() || !state.m_60815_();
    }

    public static BakedModel getFallbackModel() {
        return Minecraft.m_91087_().m_91304_().m_119409_();
    }

    public static BakedModel getVerticalModel(BlockState state, Direction direction) {
        Map<Direction, BakedModel> map = VERTICAL_SLAB_MODELS.get(state);
        if (map != null) {
            return map.getOrDefault(direction, ClientConstants.getFallbackModel());
        }
        return ClientConstants.getFallbackModel();
    }

    public static BakedModel getVerticalModel(Item item) {
        return VERTICAL_SLAB_ITEM_MODELS.getOrDefault(item, ClientConstants.getFallbackModel());
    }

    public static BakedModel bake(ModelBakery modelLoader, UnbakedModel baseModel, ResourceLocation location, boolean uvlock, ModelState transform) {
        if (baseModel instanceof MultiVariant) {
            MultiVariant model = (MultiVariant)baseModel;
            if (model.m_111848_().isEmpty()) {
                return null;
            }
            WeightedBakedModel.Builder builder = new WeightedBakedModel.Builder();
            for (Variant variant : model.m_111848_()) {
                BakedModel ibakedmodel = modelLoader.bake(variant.m_111883_(), transform, arg_0 -> ((AtlasSet)modelLoader.getAtlasSet()).m_117971_(arg_0));
                builder.m_119559_(ibakedmodel, variant.m_111886_());
            }
            return builder.m_119558_();
        }
        return baseModel.m_7611_(modelLoader, arg_0 -> ((AtlasSet)modelLoader.getAtlasSet()).m_117971_(arg_0), transform, location);
    }

    public static void bakeVerticalSlabModels(ModelBakery modelLoader) {
        VERTICAL_SLAB_MODELS.clear();
        VERTICAL_SLAB_ITEM_MODELS.clear();
        ForgeRegistries.BLOCKS.forEach(block -> {
            IHorizontalSlabSupport support = SlabSupport.getHorizontalSlabSupport(block);
            if (support != null) {
                boolean raisedCampfire = block instanceof RaisedCampfireBlock;
                boolean uvlock = support.uvlock((Block)block) && DSConfig.CLIENT.uvlock((Block)block);
                block.m_49965_().m_61056_().forEach(state -> {
                    ModelResourceLocation resourceLocation = BlockModelShaper.m_110895_((BlockState)state);
                    try {
                        EnumMap map = Maps.newEnumMap(Direction.class);
                        UnbakedModel model = modelLoader.m_119341_((ResourceLocation)resourceLocation);
                        if (raisedCampfire) {
                            map.put(Direction.NORTH, ClientConstants.bake(modelLoader, model, (ResourceLocation)resourceLocation, uvlock, (ModelState)new Variant((ResourceLocation)resourceLocation, BlockModelRotation.X90_Y180.m_6189_().m_121096_(ClientProxy.RAISED_CAMPFIRE_TRANSFORM), uvlock, 1)));
                            map.put(Direction.EAST, ClientConstants.bake(modelLoader, model, (ResourceLocation)resourceLocation, uvlock, (ModelState)new Variant((ResourceLocation)resourceLocation, BlockModelRotation.X90_Y270.m_6189_().m_121096_(ClientProxy.RAISED_CAMPFIRE_TRANSFORM), uvlock, 1)));
                            map.put(Direction.SOUTH, ClientConstants.bake(modelLoader, model, (ResourceLocation)resourceLocation, uvlock, (ModelState)new Variant((ResourceLocation)resourceLocation, BlockModelRotation.X90_Y0.m_6189_().m_121096_(ClientProxy.RAISED_CAMPFIRE_TRANSFORM), uvlock, 1)));
                            map.put(Direction.WEST, ClientConstants.bake(modelLoader, model, (ResourceLocation)resourceLocation, uvlock, (ModelState)new Variant((ResourceLocation)resourceLocation, BlockModelRotation.X90_Y90.m_6189_().m_121096_(ClientProxy.RAISED_CAMPFIRE_TRANSFORM), uvlock, 1)));
                        } else {
                            map.put(Direction.NORTH, ClientConstants.bake(modelLoader, model, (ResourceLocation)resourceLocation, uvlock, (ModelState)new Variant((ResourceLocation)resourceLocation, BlockModelRotation.X90_Y180.m_6189_(), uvlock, 1)));
                            map.put(Direction.EAST, ClientConstants.bake(modelLoader, model, (ResourceLocation)resourceLocation, uvlock, (ModelState)new Variant((ResourceLocation)resourceLocation, BlockModelRotation.X90_Y270.m_6189_(), uvlock, 1)));
                            map.put(Direction.SOUTH, ClientConstants.bake(modelLoader, model, (ResourceLocation)resourceLocation, uvlock, (ModelState)new Variant((ResourceLocation)resourceLocation, BlockModelRotation.X90_Y0.m_6189_(), uvlock, 1)));
                            map.put(Direction.WEST, ClientConstants.bake(modelLoader, model, (ResourceLocation)resourceLocation, uvlock, (ModelState)new Variant((ResourceLocation)resourceLocation, BlockModelRotation.X90_Y90.m_6189_(), uvlock, 1)));
                        }
                        VERTICAL_SLAB_MODELS.put((BlockState)state, map);
                    }
                    catch (Exception e) {
                        DoubleSlabs.LOGGER.warn("Failed to generate vertical slab model for: {}", (Object)resourceLocation.toString());
                        DoubleSlabs.LOGGER.catching((Throwable)e);
                    }
                });
            }
        });
        ForgeRegistries.ITEMS.forEach(item -> {
            if (SlabSupport.isHorizontalSlab(item)) {
                boolean uvlock = item instanceof BlockItem ? DSConfig.CLIENT.uvlock(((BlockItem)item).m_40614_()) : DSConfig.CLIENT.uvlock((Item)item);
                ModelResourceLocation resourceLocation = new ModelResourceLocation(Objects.requireNonNull(ForgeRegistries.ITEMS.getKey(item)), "inventory");
                try {
                    boolean is3d;
                    UnbakedModel model = modelLoader.m_119341_((ResourceLocation)resourceLocation);
                    boolean bl = is3d = model instanceof BlockModel && ((BlockModel)model).m_111479_().m_111526_();
                    if (is3d) {
                        VERTICAL_SLAB_ITEM_MODELS.put((Item)item, ClientConstants.bake(modelLoader, model, (ResourceLocation)resourceLocation, uvlock, (ModelState)new Variant((ResourceLocation)resourceLocation, BlockModelRotation.X90_Y0.m_6189_(), uvlock, 1)));
                    } else {
                        VERTICAL_SLAB_ITEM_MODELS.put((Item)item, ClientConstants.bake(modelLoader, model, (ResourceLocation)resourceLocation, uvlock, (ModelState)new Variant((ResourceLocation)resourceLocation, TRANSFORMATION_2D, uvlock, 1)));
                    }
                }
                catch (Exception e) {
                    DoubleSlabs.LOGGER.warn("Failed to generate vertical slab item model for: {}", (Object)resourceLocation.toString());
                    DoubleSlabs.LOGGER.catching((Throwable)e);
                }
            }
        });
        DoubleSlabs.LOGGER.debug("Loaded vertical slab models!");
    }
}

