/*
 * Decompiled with CFR 0.152.
 */
package cjminecraft.doubleslabs.client.model;

import cjminecraft.doubleslabs.api.IBlockInfo;
import cjminecraft.doubleslabs.api.SlabSupport;
import cjminecraft.doubleslabs.api.support.IHorizontalSlabSupport;
import cjminecraft.doubleslabs.client.ClientConstants;
import cjminecraft.doubleslabs.client.model.DynamicSlabBakedModel;
import cjminecraft.doubleslabs.common.config.DSConfig;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraftforge.client.model.data.ModelData;

public class DoubleSlabBakedModel
extends DynamicSlabBakedModel {
    @Nonnull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull RandomSource rand, @Nonnull ModelData extraData, @Nullable RenderType renderType) {
        if (extraData.has(POSITIVE_BLOCK) && extraData.has(NEGATIVE_BLOCK)) {
            IHorizontalSlabSupport horizontalSlabSupport;
            boolean shouldCull;
            IBlockInfo positiveBlock = (IBlockInfo)extraData.get(POSITIVE_BLOCK);
            IBlockInfo negativeBlock = (IBlockInfo)extraData.get(NEGATIVE_BLOCK);
            assert (positiveBlock != null);
            assert (negativeBlock != null);
            BlockState positiveState = positiveBlock.getBlockState();
            BlockState negativeState = negativeBlock.getBlockState();
            if (positiveState == null || negativeState == null) {
                return ClientConstants.getFallbackModel().getQuads(state, side, rand, extraData, renderType);
            }
            boolean renderHalves = extraData.has(RENDER_POSITIVE) && extraData.get(RENDER_POSITIVE) != null;
            boolean renderPositive = renderHalves && (Boolean)extraData.get(RENDER_POSITIVE) != false;
            boolean topTransparent = ClientConstants.isTransparent(positiveState);
            boolean bottomTransparent = ClientConstants.isTransparent(negativeState);
            boolean bl = shouldCull = !(positiveBlock.getSupport() != null && !positiveBlock.getSupport().shouldCull(positiveState, negativeState) || negativeBlock.getSupport() != null && !negativeBlock.getSupport().shouldCull(negativeState, positiveState) || !DSConfig.CLIENT.shouldCull(positiveState.m_60734_()) || !DSConfig.CLIENT.shouldCull(negativeState.m_60734_()) || topTransparent && bottomTransparent && (positiveState.m_60734_() != negativeState.m_60734_() || !positiveState.m_60713_(negativeState.m_60734_())));
            if (DoubleSlabBakedModel.useDoubleSlabModel(positiveState, negativeState) && (horizontalSlabSupport = SlabSupport.getHorizontalSlabSupport((BlockGetter)positiveBlock.getWorld(), positiveBlock.getPos(), positiveState)) != null && horizontalSlabSupport.useDoubleSlabModel(positiveState)) {
                BlockState doubleState = horizontalSlabSupport.getStateForHalf((BlockGetter)positiveBlock.getWorld(), positiveBlock.getPos(), positiveState, SlabType.DOUBLE);
                BakedModel model = Minecraft.m_91087_().m_91289_().m_110910_(doubleState);
                if (renderType == null || model.getRenderTypes(doubleState, rand, ModelData.EMPTY).contains(renderType)) {
                    return model.getQuads(doubleState, side, rand, ModelData.EMPTY, renderType);
                }
                return Lists.newArrayList();
            }
            ArrayList quads = Lists.newArrayList();
            if (!renderHalves || renderPositive) {
                List<BakedQuad> topQuads = this.getQuadsForState(positiveBlock, side, rand, renderType);
                if (shouldCull && (!bottomTransparent && !topTransparent || topTransparent && !bottomTransparent || topTransparent && bottomTransparent)) {
                    topQuads.removeIf(bakedQuad -> bakedQuad.m_111306_() == Direction.DOWN);
                }
                quads.addAll(topQuads);
            }
            if (!renderHalves || !renderPositive) {
                List<BakedQuad> bottomQuads = this.getQuadsForState(negativeBlock, side, rand, renderType);
                if (shouldCull && (!topTransparent && !bottomTransparent || bottomTransparent && !topTransparent || topTransparent && bottomTransparent)) {
                    bottomQuads.removeIf(bakedQuad -> bakedQuad.m_111306_() == Direction.UP);
                }
                quads.addAll(bottomQuads);
            }
            return quads;
        }
        if (renderType == null) {
            // empty if block
        }
        return ClientConstants.getFallbackModel().getQuads(state, side, rand, extraData, renderType);
    }
}

