/*
 * Decompiled with CFR 0.152.
 */
package cjminecraft.doubleslabs.client.model;

import cjminecraft.doubleslabs.api.IBlockInfo;
import cjminecraft.doubleslabs.api.SlabSupport;
import cjminecraft.doubleslabs.api.support.IHorizontalSlabSupport;
import cjminecraft.doubleslabs.client.ClientConstants;
import cjminecraft.doubleslabs.common.config.DSConfig;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraftforge.client.ChunkRenderTypeSet;
import net.minecraftforge.client.model.IDynamicBakedModel;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.client.model.data.ModelProperty;
import org.jetbrains.annotations.NotNull;

public abstract class DynamicSlabBakedModel
implements IDynamicBakedModel {
    public static final ModelProperty<IBlockInfo> NEGATIVE_BLOCK = new ModelProperty();
    public static final ModelProperty<IBlockInfo> POSITIVE_BLOCK = new ModelProperty();
    public static final ModelProperty<Boolean> RENDER_POSITIVE = new ModelProperty();

    public boolean m_7539_() {
        return ClientConstants.getFallbackModel().m_7539_();
    }

    public boolean m_7541_() {
        return true;
    }

    public boolean m_7547_() {
        return true;
    }

    public boolean m_7521_() {
        return false;
    }

    public TextureAtlasSprite m_6160_() {
        return ClientConstants.getFallbackModel().m_6160_();
    }

    public ItemOverrides m_7343_() {
        return ClientConstants.getFallbackModel().m_7343_();
    }

    public TextureAtlasSprite getParticleIcon(@Nonnull ModelData data) {
        if (data.has(POSITIVE_BLOCK) && data.get(POSITIVE_BLOCK) != null && ((IBlockInfo)data.get(POSITIVE_BLOCK)).getBlockState() != null) {
            return Minecraft.m_91087_().m_91289_().m_110907_().m_110893_(((IBlockInfo)data.get(POSITIVE_BLOCK)).getBlockState()).getParticleIcon(ModelData.EMPTY);
        }
        return ClientConstants.getFallbackModel().getParticleIcon(ModelData.EMPTY);
    }

    protected boolean shouldCull(BlockState state, BlockState neighbour, Direction direction) {
        if (state == null || neighbour == null) {
            return false;
        }
        return state.m_60719_(neighbour, direction) || !ClientConstants.isTransparent(state) && !ClientConstants.isTransparent(neighbour);
    }

    public static boolean useDoubleSlabModel(BlockState state1, BlockState state2) {
        return state1.m_60734_() == state2.m_60734_() && state2.m_60713_(state2.m_60734_()) && DSConfig.CLIENT.useDoubleSlabModel(state1.m_60734_());
    }

    protected List<BakedQuad> getQuadsForState(IBlockInfo block, Direction side, RandomSource rand, RenderType renderType) {
        BlockState state = block.getBlockState();
        if (state == null) {
            return Lists.newArrayList();
        }
        BakedModel model = Minecraft.m_91087_().m_91289_().m_110910_(state);
        return this.getQuadsForState(block, model, side, rand, renderType);
    }

    protected List<BakedQuad> getQuadsForState(IBlockInfo block, BakedModel model, Direction side, RandomSource rand, RenderType renderType) {
        BlockState state = block.getBlockState();
        if (state == null) {
            return Lists.newArrayList();
        }
        if (renderType != null && !model.getRenderTypes(state, rand, ModelData.EMPTY).contains(renderType)) {
            return Lists.newArrayList();
        }
        ModelData tileData = block.getBlockEntity() != null ? block.getBlockEntity().getModelData() : ModelData.EMPTY;
        ModelData modelData = model.getModelData((BlockAndTintGetter)block.getWorld(), block.getPos(), state, tileData);
        return this.getQuadsForModel(model, state, side, rand, modelData, renderType, block.isPositive());
    }

    protected List<BakedQuad> getQuadsForModel(BakedModel model, BlockState state, Direction side, RandomSource rand, ModelData modelData, RenderType renderType, boolean positive) {
        return model.getQuads(state, side, rand, modelData, renderType).stream().map(quad -> new BakedQuad(quad.m_111303_(), quad.m_111304_() ? quad.m_111305_() + (positive ? 1000 : 0) : -1, quad.m_111306_(), quad.m_173410_(), quad.m_111307_())).collect(Collectors.toList());
    }

    private ChunkRenderTypeSet getRenderTypes(IBlockInfo block, @NotNull RandomSource rand) {
        BlockState state = block.getBlockState();
        if (state == null) {
            return ChunkRenderTypeSet.none();
        }
        BakedModel model = Minecraft.m_91087_().m_91289_().m_110910_(state);
        ModelData tileData = block.getBlockEntity() != null ? block.getBlockEntity().getModelData() : ModelData.EMPTY;
        ModelData modelData = model.getModelData((BlockAndTintGetter)block.getWorld(), block.getPos(), state, tileData);
        return model.getRenderTypes(state, rand, modelData);
    }

    public ChunkRenderTypeSet getRenderTypes(@NotNull BlockState state, @NotNull RandomSource rand, @NotNull ModelData data) {
        if (data.has(POSITIVE_BLOCK) && data.has(NEGATIVE_BLOCK)) {
            IHorizontalSlabSupport horizontalSlabSupport;
            IBlockInfo positiveBlock = (IBlockInfo)data.get(POSITIVE_BLOCK);
            IBlockInfo negativeBlock = (IBlockInfo)data.get(NEGATIVE_BLOCK);
            assert (positiveBlock != null);
            assert (negativeBlock != null);
            BlockState positiveState = positiveBlock.getBlockState();
            BlockState negativeState = negativeBlock.getBlockState();
            if (positiveState != null && negativeState != null && DynamicSlabBakedModel.useDoubleSlabModel(positiveState, negativeState) && (horizontalSlabSupport = SlabSupport.getHorizontalSlabSupport((BlockGetter)positiveBlock.getWorld(), positiveBlock.getPos(), positiveState)) != null && horizontalSlabSupport.useDoubleSlabModel(positiveState)) {
                BlockState doubleState = horizontalSlabSupport.getStateForHalf((BlockGetter)positiveBlock.getWorld(), positiveBlock.getPos(), positiveState, SlabType.DOUBLE);
                BakedModel model = Minecraft.m_91087_().m_91289_().m_110910_(doubleState);
                return model.getRenderTypes(doubleState, rand, ModelData.EMPTY);
            }
            return ChunkRenderTypeSet.union((ChunkRenderTypeSet[])new ChunkRenderTypeSet[]{this.getRenderTypes(positiveBlock, rand), this.getRenderTypes(negativeBlock, rand)});
        }
        return ChunkRenderTypeSet.all();
    }
}

