/*
 * Decompiled with CFR 0.152.
 */
package cjminecraft.doubleslabs.client.proxy;

import cjminecraft.doubleslabs.client.ClientConstants;
import cjminecraft.doubleslabs.client.gui.WrappedScreen;
import cjminecraft.doubleslabs.client.model.DoubleSlabBakedModel;
import cjminecraft.doubleslabs.client.model.DynamicSlabBakedModel;
import cjminecraft.doubleslabs.client.model.VerticalSlabBakedModel;
import cjminecraft.doubleslabs.client.model.VerticalSlabItemBakedModel;
import cjminecraft.doubleslabs.client.render.RaisedCampfireTileEntityRenderer;
import cjminecraft.doubleslabs.client.render.SlabTileEntityRenderer;
import cjminecraft.doubleslabs.common.DoubleSlabs;
import cjminecraft.doubleslabs.common.blocks.DynamicSlabBlock;
import cjminecraft.doubleslabs.common.config.ConfigEventsHandler;
import cjminecraft.doubleslabs.common.init.DSBlocks;
import cjminecraft.doubleslabs.common.init.DSContainers;
import cjminecraft.doubleslabs.common.init.DSItems;
import cjminecraft.doubleslabs.common.init.DSTiles;
import cjminecraft.doubleslabs.common.items.VerticalSlabItem;
import cjminecraft.doubleslabs.common.proxy.IProxy;
import com.mojang.math.Transformation;
import com.mojang.math.Vector3f;
import java.util.Map;
import java.util.function.BiConsumer;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockModelShaper;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.client.event.RegisterColorHandlersEvent;
import net.minecraftforge.client.model.SimpleModelState;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;

public class ClientProxy
implements IProxy {
    public static final Transformation RAISED_CAMPFIRE_TRANSFORM = new Transformation(new Vector3f(0.0f, 0.5f, 0.0f), null, null, null);

    @Override
    public void addListeners(IEventBus mod, IEventBus forge) {
        mod.addListener(this::clientSetup);
        mod.addListener(this::registerBlockColours);
        mod.addListener(this::registerItemColours);
        mod.addListener(this::bakeModels);
        mod.addListener(ConfigEventsHandler::onFileChange);
    }

    private void replaceModel(BakedModel model, Block block, BiConsumer<BakedModel, BlockState> perModel, Map<ResourceLocation, BakedModel> registry) {
        for (BlockState state : block.m_49965_().m_61056_()) {
            ModelResourceLocation variantResourceLocation = BlockModelShaper.m_110895_((BlockState)state);
            BakedModel existingModel = registry.get(variantResourceLocation);
            if (existingModel == null) {
                DoubleSlabs.LOGGER.warn("Did not find the expected vanilla baked model(s) for the block in registry");
                continue;
            }
            if (existingModel instanceof DynamicSlabBakedModel) {
                DoubleSlabs.LOGGER.warn("Tried to replace model twice");
                continue;
            }
            perModel.accept(existingModel, state);
            registry.put((ResourceLocation)variantResourceLocation, model);
        }
    }

    private void replaceCampfireModel(Block block, Map<ResourceLocation, BakedModel> registry, ModelBakery loader) {
        for (BlockState state : block.m_49965_().m_61056_()) {
            ModelResourceLocation variantResourceLocation = BlockModelShaper.m_110895_((BlockState)state);
            UnbakedModel existingModel = loader.m_119341_((ResourceLocation)variantResourceLocation);
            registry.put((ResourceLocation)variantResourceLocation, ClientConstants.bake(loader, existingModel, (ResourceLocation)variantResourceLocation, false, (ModelState)new SimpleModelState(RAISED_CAMPFIRE_TRANSFORM)));
        }
    }

    private void bakeModels(ModelEvent.BakingCompleted event) {
        ClientConstants.bakeVerticalSlabModels(event.getModelBakery());
        this.replaceModel((BakedModel)new DoubleSlabBakedModel(), (Block)DSBlocks.DOUBLE_SLAB.get(), (model, state) -> {}, event.getModels());
        this.replaceModel((BakedModel)VerticalSlabBakedModel.INSTANCE, (Block)DSBlocks.VERTICAL_SLAB.get(), VerticalSlabBakedModel.INSTANCE::addModel, event.getModels());
        this.replaceCampfireModel((Block)DSBlocks.RAISED_CAMPFIRE.get(), event.getModels(), event.getModelBakery());
        this.replaceCampfireModel((Block)DSBlocks.RAISED_SOUL_CAMPFIRE.get(), event.getModels(), event.getModelBakery());
        ModelResourceLocation verticalSlabItemResourceLocation = new ModelResourceLocation(DSItems.VERTICAL_SLAB.getId(), "inventory");
        VerticalSlabItemBakedModel.INSTANCE = new VerticalSlabItemBakedModel(event.getModelManager().m_119422_(verticalSlabItemResourceLocation));
        event.getModels().put(verticalSlabItemResourceLocation, VerticalSlabItemBakedModel.INSTANCE);
    }

    private void clientSetup(FMLClientSetupEvent event) {
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)DSBlocks.RAISED_CAMPFIRE.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)DSBlocks.RAISED_SOUL_CAMPFIRE.get()), (RenderType)RenderType.m_110463_());
        BlockEntityRenderers.m_173590_((BlockEntityType)((BlockEntityType)DSTiles.DYNAMIC_SLAB.get()), SlabTileEntityRenderer::new);
        BlockEntityRenderers.m_173590_((BlockEntityType)((BlockEntityType)DSTiles.CAMPFIRE.get()), RaisedCampfireTileEntityRenderer::new);
        MenuScreens.m_96206_((MenuType)((MenuType)DSContainers.WRAPPED_CONTAINER.get()), WrappedScreen::new);
    }

    private void registerBlockColours(RegisterColorHandlersEvent.Block event) {
        event.register(((DynamicSlabBlock)((Object)DSBlocks.DOUBLE_SLAB.get())).getBlockColor(), new Block[]{(Block)DSBlocks.DOUBLE_SLAB.get()});
        event.register(((DynamicSlabBlock)((Object)DSBlocks.VERTICAL_SLAB.get())).getBlockColor(), new Block[]{(Block)DSBlocks.VERTICAL_SLAB.get()});
    }

    private void registerItemColours(RegisterColorHandlersEvent.Item event) {
        event.register(((VerticalSlabItem)((Object)DSItems.VERTICAL_SLAB.get())).getItemColor(), new ItemLike[]{(ItemLike)DSItems.VERTICAL_SLAB.get()});
    }
}

