/*
 * Decompiled with CFR 0.152.
 */
package marsh.town.brb.BrewingStand;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import marsh.town.brb.BetterRecipeBook;
import marsh.town.brb.BrewingStand.PlatformPotionUtil;
import marsh.town.brb.BrewingStand.RecipeBookGroup;
import marsh.town.brb.BrewingStand.Result;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.BrewingStandMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class AnimatedResultButton
extends AbstractWidget {
    private float time;
    private static final ResourceLocation BACKGROUND_TEXTURE = new ResourceLocation("textures/gui/recipe_book.png");
    private Result potionRecipe;
    private RecipeBookGroup group;
    private BrewingStandMenu brewingStandScreenHandler;

    public AnimatedResultButton() {
        super(0, 0, 25, 25, CommonComponents.f_237098_);
    }

    public void showPotionRecipe(Result potionRecipe, RecipeBookGroup group, BrewingStandMenu brewingStandScreenHandler) {
        this.potionRecipe = potionRecipe;
        this.group = group;
        this.brewingStandScreenHandler = brewingStandScreenHandler;
    }

    public void m_6303_(PoseStack matrices, int mouseX, int mouseY, float delta) {
        int j;
        int i;
        if (!Screen.m_96637_()) {
            this.time += delta;
        }
        Minecraft minecraftClient = Minecraft.m_91087_();
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        if (BetterRecipeBook.config.enablePinning && BetterRecipeBook.pinnedRecipeManager.hasPotion(this.potionRecipe.recipe)) {
            RenderSystem.m_157456_((int)0, (ResourceLocation)new ResourceLocation("brb:textures/gui/pinned.png"));
            i = 25;
            j = 0;
        } else {
            RenderSystem.m_157456_((int)0, (ResourceLocation)BACKGROUND_TEXTURE);
            i = 54;
            j = 206;
        }
        if (this.potionRecipe.hasMaterials(this.group, this.brewingStandScreenHandler)) {
            i -= 25;
        }
        PoseStack matrixStack = RenderSystem.m_157191_();
        this.m_93228_(matrices, this.f_93620_, this.f_93621_, i, j, this.f_93618_, this.f_93619_);
        int k = 4;
        matrixStack.m_85836_();
        matrixStack.m_166854_(matrices.m_85850_().m_85861_().m_27658_());
        minecraftClient.m_91291_().m_115203_(this.potionRecipe.ingredient, this.f_93620_ + k, this.f_93621_ + k);
        minecraftClient.m_91291_().m_115169_(Minecraft.m_91087_().f_91062_, this.potionRecipe.ingredient, this.f_93620_ + k, this.f_93621_ + k);
        RenderSystem.m_69482_();
        matrixStack.m_85849_();
        RenderSystem.m_157182_();
        RenderSystem.m_69465_();
    }

    public Result getRecipe() {
        return this.potionRecipe;
    }

    public void setPos(int x, int y) {
        this.f_93620_ = x;
        this.f_93621_ = y;
    }

    public void m_142291_(NarrationElementOutput builder) {
        ItemStack inputStack = this.potionRecipe.inputAsItemStack(this.group);
        builder.m_169146_(NarratedElementType.TITLE, (Component)Component.m_237110_((String)"narration.recipe", (Object[])new Object[]{inputStack.m_41786_()}));
        builder.m_169146_(NarratedElementType.USAGE, (Component)Component.m_237115_((String)"narration.button.usage.hovered"));
    }

    public List<Component> getTooltip() {
        ArrayList list = Lists.newArrayList();
        list.add(this.potionRecipe.ingredient.m_41786_());
        PotionUtils.m_43555_((ItemStack)this.potionRecipe.ingredient, (List)list, (float)1.0f);
        list.add(Component.m_237113_((String)""));
        ChatFormatting colour = ChatFormatting.DARK_GRAY;
        if (this.potionRecipe.hasIngredient(this.brewingStandScreenHandler)) {
            colour = ChatFormatting.WHITE;
        }
        list.add(Component.m_237113_((String)PlatformPotionUtil.getIngredient(this.potionRecipe.recipe).m_43908_()[0].m_41786_().getString()).m_130940_(colour));
        list.add(Component.m_237113_((String)"\u2193").m_130940_(ChatFormatting.DARK_GRAY));
        ItemStack inputStack = this.potionRecipe.inputAsItemStack(this.group);
        if (!this.potionRecipe.hasInput(this.group, this.brewingStandScreenHandler)) {
            colour = ChatFormatting.DARK_GRAY;
        }
        list.add(Component.m_237113_((String)inputStack.m_41786_().getString()).m_130940_(colour));
        if (BetterRecipeBook.config.enablePinning) {
            if (BetterRecipeBook.pinnedRecipeManager.hasPotion(this.potionRecipe.recipe)) {
                list.add(Component.m_237115_((String)"brb.gui.pin.remove"));
            } else {
                list.add(Component.m_237115_((String)"brb.gui.pin.add"));
            }
        }
        return list;
    }
}

