/*
 * Decompiled with CFR 0.152.
 */
package marsh.town.brb.BrewingStand;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import marsh.town.brb.BetterRecipeBook;
import marsh.town.brb.BrewingStand.AnimatedResultButton;
import marsh.town.brb.BrewingStand.ClientRecipeBook;
import marsh.town.brb.BrewingStand.PlatformPotionUtil;
import marsh.town.brb.BrewingStand.RecipeBookGhostSlots;
import marsh.town.brb.BrewingStand.RecipeBookGroup;
import marsh.town.brb.BrewingStand.RecipeBookResults;
import marsh.town.brb.BrewingStand.RecipeGroupButtonWidget;
import marsh.town.brb.BrewingStand.Result;
import marsh.town.brb.Config.Config;
import me.shedaniel.autoconfig.AutoConfig;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.StateSwitchingButton;
import net.minecraft.client.gui.components.Widget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.BrewingStandMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class RecipeBookWidget
extends GuiComponent
implements Widget,
GuiEventListener,
NarratableEntry {
    public static final ResourceLocation TEXTURE = new ResourceLocation("textures/gui/recipe_book.png");
    private static final ResourceLocation BUTTON_TEXTURE = new ResourceLocation("brb:textures/gui/buttons.png");
    protected BrewingStandMenu brewingStandScreenHandler;
    Minecraft client;
    private int parentWidth;
    private int parentHeight;
    private boolean narrow;
    ClientRecipeBook recipeBook;
    private int leftOffset;
    protected final RecipeBookGhostSlots ghostSlots = new RecipeBookGhostSlots();
    private boolean open;
    private final RecipeBookResults recipesArea = new RecipeBookResults();
    @Nullable
    private EditBox searchField;
    private final StackedContents recipeFinder = new StackedContents();
    protected StateSwitchingButton toggleBrewableButton;
    private static final Component SEARCH_HINT_TEXT = Component.m_237115_((String)"gui.recipebook.search_hint").m_130940_(ChatFormatting.ITALIC).m_130940_(ChatFormatting.GRAY);
    private final List<RecipeGroupButtonWidget> tabButtons = Lists.newArrayList();
    @Nullable
    private RecipeGroupButtonWidget currentTab;
    private boolean searching;
    protected ImageButton settingsButton;
    private String searchText;
    private static final Component TOGGLE_CRAFTABLE_RECIPES_TEXT = Component.m_237115_((String)"brb.gui.togglePotions.brewable");
    private static final Component TOGGLE_ALL_RECIPES_TEXT = Component.m_237115_((String)"gui.recipebook.toggleRecipes.all");
    private static final Component OPEN_SETTINGS_TEXT = Component.m_237115_((String)"brb.gui.settings.open");
    boolean doubleRefresh = true;

    public void initialize(int parentWidth, int parentHeight, Minecraft client, boolean narrow, BrewingStandMenu brewingStandScreenHandler) {
        this.client = client;
        this.parentWidth = parentWidth;
        this.parentHeight = parentHeight;
        this.brewingStandScreenHandler = brewingStandScreenHandler;
        this.narrow = narrow;
        assert (client.f_91074_ != null);
        client.f_91074_.f_36096_ = brewingStandScreenHandler;
        this.recipeBook = new ClientRecipeBook();
        this.open = BetterRecipeBook.rememberedBrewingOpen;
        this.reset();
        this.leftOffset = BetterRecipeBook.config.keepCentered ? (this.narrow ? 0 : 162) : (this.narrow ? 0 : 86);
        client.f_91068_.m_90926_(true);
    }

    public ItemStack getInputStack(Result result) {
        Potion inputPotion = PlatformPotionUtil.getFrom(result.recipe);
        Ingredient ingredient = PlatformPotionUtil.getIngredient(result.recipe);
        ResourceLocation identifier = Registry.f_122828_.m_7981_((Object)inputPotion);
        ItemStack inputStack = this.currentTab.getGroup() == RecipeBookGroup.BREWING_SPLASH_POTION ? new ItemStack((ItemLike)Items.f_42736_) : (this.currentTab.getGroup() == RecipeBookGroup.BREWING_LINGERING_POTION ? new ItemStack((ItemLike)Items.f_42739_) : new ItemStack((ItemLike)Items.f_42589_));
        inputStack.m_41784_().m_128359_("Potion", identifier.toString());
        return inputStack;
    }

    public void reset() {
        this.leftOffset = BetterRecipeBook.config.keepCentered ? (this.narrow ? 0 : 162) : (this.narrow ? 0 : 86);
        int i = (this.parentWidth - 147) / 2 - this.leftOffset;
        int j = (this.parentHeight - 166) / 2;
        this.recipeFinder.m_36453_();
        assert (this.client.f_91074_ != null);
        this.client.f_91074_.m_150109_().m_36010_(this.recipeFinder);
        String string = this.searchField != null ? this.searchField.m_94155_() : "";
        Font var10003 = this.client.f_91062_;
        int var10004 = i + 25;
        int var10005 = j + 14;
        Objects.requireNonNull(this.client.f_91062_);
        this.searchField = new EditBox(var10003, var10004, var10005, 80, 14, (Component)Component.m_237115_((String)"itemGroup.search"));
        this.searchField.m_94199_(50);
        this.searchField.m_94182_(false);
        this.searchField.m_94194_(true);
        this.searchField.m_94202_(0xFFFFFF);
        this.searchField.m_94144_(string);
        this.recipesArea.initialize(this.client, i, j, this.brewingStandScreenHandler);
        this.tabButtons.clear();
        this.recipeBook.setFilteringCraftable(BetterRecipeBook.rememberedBrewingToggle);
        this.toggleBrewableButton = new StateSwitchingButton(i + 110, j + 12, 26, 16, this.recipeBook.isFilteringCraftable());
        this.setBookButtonTexture();
        for (RecipeBookGroup recipeBookGroup : RecipeBookGroup.getGroups()) {
            this.tabButtons.add(new RecipeGroupButtonWidget(recipeBookGroup));
        }
        if (this.currentTab != null) {
            this.currentTab = this.tabButtons.stream().filter(button -> button.getGroup().equals((Object)this.currentTab.getGroup())).findFirst().orElse(null);
        }
        if (this.currentTab == null) {
            this.currentTab = this.tabButtons.get(0);
        }
        if (BetterRecipeBook.config.settingsButton) {
            int u = 0;
            if (BetterRecipeBook.config.darkMode) {
                u = 18;
            }
            this.settingsButton = new ImageButton(i + 11, j + 137, 16, 18, u, 77, 19, BUTTON_TEXTURE, button -> Minecraft.m_91087_().m_91152_((Screen)AutoConfig.getConfigScreen(Config.class, (Screen)Minecraft.m_91087_().f_91080_).get()));
        }
        this.currentTab.m_94635_(true);
        this.refreshResults(false);
        this.refreshTabButtons();
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.open && !Objects.requireNonNull(this.client.f_91074_).m_5833_()) {
            RecipeGroupButtonWidget recipeGroupButtonWidget;
            if (this.recipesArea.mouseClicked(mouseX, mouseY, button)) {
                Result result = this.recipesArea.getLastClickedRecipe();
                if (result != null) {
                    if (this.currentTab == null) {
                        return false;
                    }
                    this.ghostSlots.reset();
                    if (!result.hasMaterials(this.currentTab.getGroup(), this.brewingStandScreenHandler)) {
                        this.showGhostRecipe(result, (List<Slot>)this.brewingStandScreenHandler.f_38839_);
                        return false;
                    }
                    ItemStack inputStack = this.getInputStack(result);
                    Ingredient ingredient = PlatformPotionUtil.getIngredient(result.recipe);
                    int slotIndex = 0;
                    int usedInputSlots = 0;
                    for (Slot slot : this.brewingStandScreenHandler.f_38839_) {
                        ItemStack itemStack = slot.m_7993_();
                        assert (inputStack.m_41783_() != null);
                        if (inputStack.m_41783_().equals((Object)itemStack.m_41783_()) && inputStack.m_41720_().equals(itemStack.m_41720_())) {
                            if (usedInputSlots <= 2) {
                                System.out.println(usedInputSlots);
                                assert (Minecraft.m_91087_().f_91072_ != null);
                                Minecraft.m_91087_().f_91072_.m_171799_(this.brewingStandScreenHandler.f_38840_, this.brewingStandScreenHandler.m_38853_((int)slotIndex).f_40219_, 0, ClickType.PICKUP, (Player)Minecraft.m_91087_().f_91074_);
                                Minecraft.m_91087_().f_91072_.m_171799_(this.brewingStandScreenHandler.f_38840_, this.brewingStandScreenHandler.m_38853_((int)usedInputSlots).f_40219_, 0, ClickType.PICKUP, (Player)Minecraft.m_91087_().f_91074_);
                                ++usedInputSlots;
                            }
                        } else if (ingredient.m_43908_()[0].m_41720_().equals(slot.m_7993_().m_41720_())) {
                            assert (Minecraft.m_91087_().f_91072_ != null);
                            Minecraft.m_91087_().f_91072_.m_171799_(this.brewingStandScreenHandler.f_38840_, this.brewingStandScreenHandler.m_38853_((int)slotIndex).f_40219_, 0, ClickType.PICKUP, (Player)Minecraft.m_91087_().f_91074_);
                            Minecraft.m_91087_().f_91072_.m_171799_(this.brewingStandScreenHandler.f_38840_, this.brewingStandScreenHandler.m_38853_((int)3).f_40219_, 0, ClickType.PICKUP, (Player)Minecraft.m_91087_().f_91074_);
                        }
                        ++slotIndex;
                    }
                    this.refreshResults(false);
                }
                return true;
            }
            assert (this.searchField != null);
            if (this.searchField.m_6375_(mouseX, mouseY, button)) {
                return true;
            }
            if (this.toggleBrewableButton.m_6375_(mouseX, mouseY, button)) {
                boolean bl = this.toggleFilteringBrewable();
                this.toggleBrewableButton.m_94635_(bl);
                BetterRecipeBook.rememberedBrewingToggle = bl;
                this.refreshResults(false);
                return true;
            }
            if (this.settingsButton != null && this.settingsButton.m_6375_(mouseX, mouseY, button) && BetterRecipeBook.config.settingsButton) {
                return true;
            }
            Iterator<RecipeGroupButtonWidget> var6 = this.tabButtons.iterator();
            do {
                if (var6.hasNext()) continue;
                return false;
            } while (!(recipeGroupButtonWidget = var6.next()).m_6375_(mouseX, mouseY, button));
            if (this.currentTab != recipeGroupButtonWidget) {
                if (this.currentTab != null) {
                    this.currentTab.m_94635_(false);
                }
                this.currentTab = recipeGroupButtonWidget;
                this.currentTab.m_94635_(true);
                this.refreshResults(true);
            }
            return false;
        }
        return false;
    }

    public void showGhostRecipe(Result result, List<Slot> slots) {
        this.ghostSlots.addSlot(PlatformPotionUtil.getIngredient(result.recipe).m_43908_()[0], slots.get((int)3).f_40220_, slots.get((int)3).f_40221_);
        assert (this.currentTab != null);
        ItemStack inputStack = result.inputAsItemStack(this.currentTab.getGroup());
        this.ghostSlots.addSlot(result.ingredient, slots.get((int)0).f_40220_, slots.get((int)0).f_40221_);
        this.ghostSlots.addSlot(inputStack, slots.get((int)1).f_40220_, slots.get((int)1).f_40221_);
        this.ghostSlots.addSlot(inputStack, slots.get((int)2).f_40220_, slots.get((int)2).f_40221_);
    }

    private boolean toggleFilteringBrewable() {
        boolean bl = !this.recipeBook.isFilteringCraftable();
        this.recipeBook.setFilteringCraftable(bl);
        BetterRecipeBook.rememberedBrewingToggle = bl;
        return bl;
    }

    private void refreshResults(boolean resetCurrentPage) {
        if (this.currentTab == null) {
            return;
        }
        if (this.searchField == null) {
            return;
        }
        List<Result> results = this.recipeBook.getResultsForCategory(this.currentTab.getGroup());
        String string = this.searchField.m_94155_();
        if (!string.isEmpty()) {
            results.removeIf(itemStack -> !itemStack.ingredient.m_41786_().getString().toLowerCase(Locale.ROOT).contains(string.toLowerCase(Locale.ROOT)));
        }
        if (this.recipeBook.isFilteringCraftable()) {
            results.removeIf(result -> !result.hasMaterials(this.currentTab.getGroup(), this.brewingStandScreenHandler));
        }
        if (BetterRecipeBook.config.enablePinning) {
            ArrayList tempResults = Lists.newArrayList(results);
            for (Result result2 : tempResults) {
                if (!BetterRecipeBook.pinnedRecipeManager.hasPotion(result2.recipe)) continue;
                results.remove(result2);
                results.add(0, result2);
            }
        }
        this.recipesArea.setResults(results, resetCurrentPage, this.currentTab.getGroup());
    }

    private void refreshTabButtons() {
        int i = (this.parentWidth - 147) / 2 - this.leftOffset - 30;
        int j = (this.parentHeight - 166) / 2 + 3;
        int l = 0;
        for (RecipeGroupButtonWidget recipeGroupButtonWidget : this.tabButtons) {
            RecipeBookGroup recipeBookGroup = recipeGroupButtonWidget.getGroup();
            if (recipeBookGroup == RecipeBookGroup.BREWING_SEARCH) {
                recipeGroupButtonWidget.f_93624_ = true;
            }
            recipeGroupButtonWidget.m_94621_(i, j + 27 * l++);
        }
    }

    public boolean isOpen() {
        return this.open;
    }

    public void m_6305_(PoseStack matrices, int mouseX, int mouseY, float delta) {
        if (this.searchField == null) {
            return;
        }
        if (this.doubleRefresh) {
            this.refreshResults(true);
            this.doubleRefresh = false;
        }
        if (this.isOpen()) {
            matrices.m_85836_();
            matrices.m_85837_(0.0, 0.0, 100.0);
            RenderSystem.m_157427_(GameRenderer::m_172817_);
            RenderSystem.m_157456_((int)0, (ResourceLocation)TEXTURE);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            int i = (this.parentWidth - 147) / 2 - this.leftOffset;
            int j = (this.parentHeight - 166) / 2;
            this.m_93228_(matrices, i, j, 1, 1, 147, 166);
            if (!this.searchField.m_93696_() && this.searchField.m_94155_().isEmpty()) {
                RecipeBookWidget.m_93243_((PoseStack)matrices, (Font)this.client.f_91062_, (Component)SEARCH_HINT_TEXT, (int)(i + 25), (int)(j + 14), (int)-1);
            } else {
                this.searchField.m_6305_(matrices, mouseX, mouseY, delta);
            }
            for (RecipeGroupButtonWidget recipeGroupButtonWidget : this.tabButtons) {
                recipeGroupButtonWidget.m_6305_(matrices, mouseX, mouseY, delta);
            }
            this.toggleBrewableButton.m_6305_(matrices, mouseX, mouseY, delta);
            if (BetterRecipeBook.config.settingsButton) {
                this.settingsButton.m_6305_(matrices, mouseX, mouseY, delta);
            }
            this.recipesArea.draw(matrices, i, j, mouseX, mouseY, delta);
            matrices.m_85849_();
        }
    }

    public int findLeftEdge(int width, int backgroundWidth) {
        int j = this.isOpen() && !this.narrow ? 177 + (width - backgroundWidth - 200) / 2 : (width - backgroundWidth) / 2;
        return j;
    }

    public void drawGhostSlots(PoseStack matrices, int x, int y, boolean bl, float delta) {
        this.ghostSlots.draw(matrices, this.client, x, y, bl, delta);
    }

    private void setOpen(boolean opened) {
        if (opened) {
            this.reset();
        }
        this.open = opened;
    }

    public void toggleOpen() {
        this.setOpen(!this.isOpen());
    }

    protected void setBookButtonTexture() {
        this.toggleBrewableButton.m_94624_(152, 41, 28, 18, TEXTURE);
    }

    public NarratableEntry.NarrationPriority m_142684_() {
        return this.open ? NarratableEntry.NarrationPriority.HOVERED : NarratableEntry.NarrationPriority.NONE;
    }

    public void drawTooltip(PoseStack matrices, int x, int y, int mouseX, int mouseY) {
        if (this.isOpen()) {
            this.recipesArea.drawTooltip(matrices, mouseX, mouseY);
            if (this.toggleBrewableButton.m_198029_()) {
                Component text = this.getCraftableButtonText();
                if (this.client.f_91080_ != null) {
                    this.client.f_91080_.m_96602_(matrices, text, mouseX, mouseY);
                }
            }
            if (this.settingsButton != null && this.settingsButton.m_198029_() && BetterRecipeBook.config.settingsButton && this.client.f_91080_ != null) {
                this.client.f_91080_.m_96602_(matrices, OPEN_SETTINGS_TEXT, mouseX, mouseY);
            }
            this.drawGhostSlotTooltip(matrices, x, y, mouseX, mouseY);
        }
    }

    private Component getCraftableButtonText() {
        return this.toggleBrewableButton.m_94620_() ? this.getToggleCraftableButtonText() : TOGGLE_ALL_RECIPES_TEXT;
    }

    protected Component getToggleCraftableButtonText() {
        return TOGGLE_CRAFTABLE_RECIPES_TEXT;
    }

    private void drawGhostSlotTooltip(PoseStack matrices, int x, int y, int mouseX, int mouseY) {
        ItemStack itemStack = null;
        for (int i = 0; i < this.ghostSlots.getSlotCount(); ++i) {
            RecipeBookGhostSlots.GhostSlot ghostInputSlot = this.ghostSlots.getSlot(i);
            int j = ghostInputSlot.getX() + x;
            int k = ghostInputSlot.getY() + y;
            if (mouseX < j || mouseY < k || mouseX >= j + 16 || mouseY >= k + 16) continue;
            itemStack = ghostInputSlot.getCurrentItemStack();
        }
        if (itemStack != null && this.client.f_91080_ != null) {
            this.client.f_91080_.m_96597_(matrices, this.client.f_91080_.m_96555_(itemStack), mouseX, mouseY);
        }
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        this.searching = false;
        if (this.isOpen() && !Objects.requireNonNull(this.client.f_91074_).m_5833_()) {
            if (keyCode == 256) {
                this.setOpen(false);
                return true;
            }
            assert (this.searchField != null);
            if (this.searchField.m_7933_(keyCode, scanCode, modifiers)) {
                this.refreshSearchResults();
                return true;
            }
            if (this.searchField.m_93696_() && this.searchField.m_94213_()) {
                return true;
            }
            if (keyCode == 70) {
                if (BetterRecipeBook.config.enablePinning) {
                    for (AnimatedResultButton resultButton : this.recipesArea.resultButtons) {
                        if (!resultButton.m_198029_()) continue;
                        BetterRecipeBook.pinnedRecipeManager.addOrRemoveFavouritePotion(resultButton.getRecipe().recipe);
                        this.refreshResults(false);
                        return true;
                    }
                }
                return false;
            }
            if (this.client.f_91066_.f_92098_.m_90832_(keyCode, scanCode) && !this.searchField.m_93696_()) {
                this.searching = true;
                this.searchField.m_94178_(true);
                return true;
            }
            return false;
        }
        return false;
    }

    public boolean m_7920_(int keyCode, int scanCode, int modifiers) {
        this.searching = false;
        return super.m_7920_(keyCode, scanCode, modifiers);
    }

    public boolean m_5534_(char chr, int modifiers) {
        if (this.searching) {
            return false;
        }
        if (this.isOpen() && !Objects.requireNonNull(this.client.f_91074_).m_5833_()) {
            assert (this.searchField != null);
            if (this.searchField.m_5534_(chr, modifiers)) {
                this.refreshSearchResults();
                return true;
            }
            return super.m_5534_(chr, modifiers);
        }
        return false;
    }

    private void refreshSearchResults() {
        assert (this.searchField != null);
        String string = this.searchField.m_94155_().toLowerCase(Locale.ROOT);
        if (!string.equals(this.searchText)) {
            this.refreshResults(false);
            this.searchText = string;
        }
    }

    public void m_142291_(NarrationElementOutput builder) {
    }
}

