/*
 * Decompiled with CFR 0.152.
 */
package marsh.town.brb;

import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import com.google.gson.stream.JsonReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import marsh.town.brb.BetterRecipeBook;
import marsh.town.brb.BrewingStand.PlatformPotionUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.recipebook.RecipeCollection;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.alchemy.PotionBrewing;
import net.minecraft.world.item.crafting.Recipe;
import org.apache.commons.io.IOUtils;

public class PinnedRecipeManager {
    public List<ResourceLocation> pinned;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read() {
        Gson gson = new Gson();
        JsonReader reader = null;
        try {
            File pinsFile = new File(Minecraft.m_91087_().f_91069_, "brb.pins");
            if (pinsFile.exists()) {
                reader = new JsonReader((Reader)new FileReader(pinsFile.getAbsolutePath()));
                Type type = new TypeToken<List<ResourceLocation>>(){}.getType();
                this.pinned = (List)gson.fromJson(reader, type);
            }
        }
        catch (Throwable var8) {
            BetterRecipeBook.LOGGER.error("brb.pins could not be read.");
        }
        finally {
            if (this.pinned == null) {
                this.pinned = new ArrayList<ResourceLocation>();
            }
            IOUtils.closeQuietly(reader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void store() {
        Gson gson = new Gson();
        OutputStreamWriter writer = null;
        try {
            File pinsFile = new File(Minecraft.m_91087_().f_91069_, "brb.pins");
            writer = new OutputStreamWriter((OutputStream)new FileOutputStream(pinsFile), StandardCharsets.UTF_8);
            writer.write(gson.toJson(this.pinned));
        }
        catch (Throwable var8) {
            try {
                BetterRecipeBook.LOGGER.error("brb.pins could not be saved.");
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                IOUtils.closeQuietly(writer);
            }
        }
        IOUtils.closeQuietly((Writer)writer);
    }

    public void addOrRemoveFavourite(RecipeCollection target) {
        for (ResourceLocation identifier : this.pinned) {
            for (Recipe recipe : target.m_100516_()) {
                if (!recipe.m_6423_().equals((Object)identifier)) continue;
                this.pinned.remove(identifier);
                this.store();
                return;
            }
        }
        this.pinned.add(((Recipe)target.m_100516_().get(0)).m_6423_());
        this.store();
    }

    public void addOrRemoveFavouritePotion(PotionBrewing.Mix<?> target) {
        ResourceLocation targetIdentifier = Registry.f_122828_.m_7981_((Object)PlatformPotionUtil.getTo(target));
        for (ResourceLocation identifier : this.pinned) {
            if (!identifier.equals((Object)targetIdentifier)) continue;
            this.pinned.remove(targetIdentifier);
            this.store();
            return;
        }
        this.pinned.add(targetIdentifier);
        this.store();
    }

    public boolean has(Object target) {
        for (ResourceLocation identifier : this.pinned) {
            for (Recipe recipe : ((RecipeCollection)target).m_100516_()) {
                if (!recipe.m_6423_().equals((Object)identifier)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasPotion(PotionBrewing.Mix<?> target) {
        ResourceLocation targetIdentifier = Registry.f_122828_.m_7981_((Object)PlatformPotionUtil.getTo(target));
        for (ResourceLocation identifier : this.pinned) {
            if (!targetIdentifier.equals((Object)identifier)) continue;
            return true;
        }
        return false;
    }
}

