/*
 * Decompiled with CFR 0.152.
 */
package dlovin.smalls.campchair.core.blocks;

import com.google.common.collect.Lists;
import dlovin.smalls.campchair.core.blocks.Properties;
import dlovin.smalls.campchair.core.entities.SitingEntity;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.protocol.game.DebugPackets;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class CampChairBlock
extends Block {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final BooleanProperty COVERED = Properties.COVERED;
    public static final EnumProperty<DyeColor> COLOR = Properties.COLOR;
    protected static final Map<Direction, VoxelShape> SHAPE = new HashMap<Direction, VoxelShape>();
    protected static final VoxelShape SHAPE_E = Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)10.0, (double)5.0, (double)15.0);
    protected static final VoxelShape SHAPE_W = Block.m_49796_((double)6.0, (double)0.0, (double)1.0, (double)15.0, (double)5.0, (double)15.0);
    protected static final VoxelShape SHAPE_N = Block.m_49796_((double)1.0, (double)0.0, (double)6.0, (double)15.0, (double)5.0, (double)15.0);
    protected static final VoxelShape SHAPE_S = Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)5.0, (double)10.0);
    private static final Map<Item, DyeColor> carpets;

    private static Item getItem(DyeColor color) {
        for (Map.Entry<Item, DyeColor> entry : carpets.entrySet()) {
            if (!entry.getValue().equals((Object)color)) continue;
            return entry.getKey();
        }
        return Items.f_42130_;
    }

    public CampChairBlock(BlockBehaviour.Properties p_49795_) {
        super(p_49795_);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)COVERED, (Comparable)Boolean.valueOf(false)));
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        Direction dir = context.m_43719_().m_122434_().m_122478_() ? context.m_8125_().m_122424_() : context.m_43719_().m_122424_();
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)dir)).m_61124_((Property)COVERED, (Comparable)Boolean.valueOf(false));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter p_48817_, BlockPos p_48818_, CollisionContext p_48819_) {
        return SHAPE.get(state.m_61143_((Property)FACING));
    }

    public BlockState m_6843_(BlockState p_48811_, Rotation p_48812_) {
        return (BlockState)p_48811_.m_61124_((Property)FACING, (Comparable)p_48812_.m_55954_((Direction)p_48811_.m_61143_((Property)FACING)));
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block block, BlockPos neighbor, boolean p_60514_) {
        DebugPackets.m_133708_((Level)level, (BlockPos)pos);
        SitingEntity.update(level, pos, (Boolean)state.m_61143_((Property)COVERED));
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (level.f_46443_) {
            return InteractionResult.CONSUME;
        }
        ItemStack item = player.m_21120_(hand);
        DyeColor color = carpets.get(item.m_41720_());
        if (color != null && !((Boolean)state.m_61143_((Property)COVERED)).booleanValue()) {
            item.m_41764_(item.m_41613_() - 1);
            state = (BlockState)state.m_61124_((Property)COVERED, (Comparable)Boolean.TRUE);
            state = (BlockState)state.m_61124_(COLOR, (Comparable)color);
            level.m_7731_(pos, state, 10);
            level.m_142346_((Entity)player, GameEvent.f_157792_, pos);
            return InteractionResult.SUCCESS;
        }
        if (item.m_41619_() && ((Boolean)state.m_61143_((Property)COVERED)).booleanValue() && player.m_6047_()) {
            ItemStack drop = new ItemStack((ItemLike)CampChairBlock.getItem((DyeColor)state.m_61143_(COLOR)));
            double x = (double)pos.m_123341_() + 0.5;
            double y = (double)pos.m_123342_() + 0.5;
            double z = (double)pos.m_123343_() + 0.5;
            level.m_7967_((Entity)new ItemEntity(level, x, y, z, drop));
            state = (BlockState)state.m_61124_((Property)COVERED, (Comparable)Boolean.FALSE);
            level.m_7731_(pos, state, 10);
            level.m_142346_((Entity)player, GameEvent.f_157792_, pos);
            return InteractionResult.SUCCESS;
        }
        boolean reg = this.checkForCampfire(level, pos);
        Direction dir = (Direction)state.m_61143_((Property)FACING);
        double x = (double)pos.m_123341_() + 0.5 - (double)dir.m_122429_() * 0.17;
        double y = (double)pos.m_123342_() + 0.5;
        double z = (double)pos.m_123343_() + 0.5 - (double)dir.m_122431_() * 0.17;
        Vec3 newPos = new Vec3(x, y, z);
        return SitingEntity.create(level, pos, newPos, player, reg, (Boolean)state.m_61143_((Property)COVERED));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> p_48814_) {
        p_48814_.m_61104_(new Property[]{FACING});
        p_48814_.m_61104_(new Property[]{COVERED});
        p_48814_.m_61104_(new Property[]{COLOR});
    }

    public boolean m_7357_(BlockState p_48799_, BlockGetter p_48800_, BlockPos p_48801_, PathComputationType p_48802_) {
        return false;
    }

    private boolean checkForCampfire(Level level, BlockPos pos) {
        int z;
        int y;
        int x = pos.m_123341_();
        if (level.m_8055_(new BlockPos(x + 1, y = pos.m_123342_(), z = pos.m_123343_())).m_60734_() instanceof CampfireBlock) {
            return true;
        }
        if (level.m_8055_(new BlockPos(x - 1, y, z)).m_60734_() instanceof CampfireBlock) {
            return true;
        }
        if (level.m_8055_(new BlockPos(x, y, z + 1)).m_60734_() instanceof CampfireBlock) {
            return true;
        }
        return level.m_8055_(new BlockPos(x, y, z - 1)).m_60734_() instanceof CampfireBlock;
    }

    @Deprecated
    public List<ItemStack> m_7381_(BlockState state, LootContext.Builder builder) {
        ArrayList list = Lists.newArrayList();
        list.add(new ItemStack((ItemLike)this.m_5456_()));
        if (((Boolean)state.m_61143_((Property)COVERED)).booleanValue()) {
            list.add(new ItemStack((ItemLike)CampChairBlock.getItem((DyeColor)state.m_61143_(COLOR))));
        }
        return list;
    }

    static {
        SHAPE.put(Direction.EAST, SHAPE_E);
        SHAPE.put(Direction.WEST, SHAPE_W);
        SHAPE.put(Direction.NORTH, SHAPE_N);
        SHAPE.put(Direction.SOUTH, SHAPE_S);
        carpets = new HashMap<Item, DyeColor>();
        carpets.put(Items.f_42130_, DyeColor.WHITE);
        carpets.put(Items.f_42198_, DyeColor.BLACK);
        carpets.put(Items.f_42141_, DyeColor.BLUE);
        carpets.put(Items.f_42139_, DyeColor.CYAN);
        carpets.put(Items.f_42142_, DyeColor.BROWN);
        carpets.put(Items.f_42137_, DyeColor.GRAY);
        carpets.put(Items.f_42143_, DyeColor.GREEN);
        carpets.put(Items.f_42135_, DyeColor.LIME);
        carpets.put(Items.f_42132_, DyeColor.MAGENTA);
        carpets.put(Items.f_42131_, DyeColor.ORANGE);
        carpets.put(Items.f_42136_, DyeColor.PINK);
        carpets.put(Items.f_42140_, DyeColor.PURPLE);
        carpets.put(Items.f_42197_, DyeColor.RED);
        carpets.put(Items.f_42134_, DyeColor.YELLOW);
        carpets.put(Items.f_42133_, DyeColor.LIGHT_BLUE);
        carpets.put(Items.f_42138_, DyeColor.LIGHT_GRAY);
    }
}

