/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.chalk.block;

import com.google.common.collect.ImmutableMap;
import com.mojang.math.Vector3f;
import io.github.mortuusars.chalk.Chalk;
import io.github.mortuusars.chalk.config.Config;
import io.github.mortuusars.chalk.core.MarkSymbol;
import io.github.mortuusars.chalk.core.SymbolOrientation;
import io.github.mortuusars.chalk.render.ChalkColors;
import io.github.mortuusars.chalk.utils.ParticleUtils;
import io.github.mortuusars.chalk.utils.PositionUtils;
import java.util.Map;
import java.util.Random;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.GrassBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ChalkMarkBlock
extends Block {
    public static final DirectionProperty FACING = BlockStateProperties.f_61372_;
    public static final EnumProperty<MarkSymbol> SYMBOL = EnumProperty.m_61587_((String)"symbol", MarkSymbol.class);
    public static final EnumProperty<SymbolOrientation> ORIENTATION = EnumProperty.m_61587_((String)"orientation", SymbolOrientation.class);
    public static final BooleanProperty GLOWING = BooleanProperty.m_61465_((String)"glowing");
    private final DyeColor color;
    private static final VoxelShape DOWN_AABB = Block.m_49796_((double)1.5, (double)15.5, (double)1.5, (double)14.5, (double)16.0, (double)14.5);
    private static final VoxelShape UP_AABB = Block.m_49796_((double)1.5, (double)0.0, (double)1.5, (double)14.5, (double)0.5, (double)14.5);
    private static final VoxelShape SOUTH_AABB = Block.m_49796_((double)1.5, (double)1.5, (double)0.0, (double)14.5, (double)14.5, (double)0.5);
    private static final VoxelShape EAST_AABB = Block.m_49796_((double)0.0, (double)1.5, (double)1.5, (double)0.5, (double)14.5, (double)14.5);
    private static final VoxelShape WEST_AABB = Block.m_49796_((double)15.5, (double)1.5, (double)1.5, (double)16.0, (double)14.5, (double)14.5);
    private static final VoxelShape NORTH_AABB = Block.m_49796_((double)1.5, (double)1.5, (double)15.5, (double)14.5, (double)14.5, (double)16.0);
    private final Map<BlockState, VoxelShape> shapesCache;

    public ChalkMarkBlock(DyeColor dyeColor, BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_(SYMBOL, (Comparable)((Object)MarkSymbol.CENTER))).m_61124_(ORIENTATION, (Comparable)((Object)SymbolOrientation.NORTH))).m_61124_((Property)GLOWING, (Comparable)Boolean.valueOf(false)));
        this.color = dyeColor;
        this.shapesCache = ImmutableMap.copyOf(this.m_49965_().m_61056_().stream().collect(Collectors.toMap(Function.identity(), ChalkMarkBlock::calculateShapes)));
    }

    private static VoxelShape calculateShapes(BlockState blockState) {
        return switch ((Direction)blockState.m_61143_((Property)FACING)) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.DOWN -> DOWN_AABB;
            case Direction.UP -> UP_AABB;
            case Direction.NORTH -> NORTH_AABB;
            case Direction.SOUTH -> SOUTH_AABB;
            case Direction.WEST -> WEST_AABB;
            case Direction.EAST -> EAST_AABB;
        };
    }

    public VoxelShape m_5940_(BlockState blockState, BlockGetter p_60556_, BlockPos p_60557_, CollisionContext p_60558_) {
        return this.shapesCache.get(blockState);
    }

    public ItemStack m_7397_(BlockGetter level, BlockPos pos, BlockState blockState) {
        return new ItemStack((ItemLike)Chalk.Items.getChalk(this.color));
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter level, BlockPos pos, Player player) {
        if (player.m_7500_()) {
            return new ItemStack((ItemLike)Chalk.Items.getChalk(this.color));
        }
        ItemStack item = this.getMatchingItemStack(player, Chalk.Items.getChalk(this.color));
        return item == ItemStack.f_41583_ ? new ItemStack((ItemLike)Chalk.Items.getChalk(this.color)) : item;
    }

    private ItemStack getMatchingItemStack(Player player, Item item) {
        return player.m_150109_().f_35974_.stream().filter(invItem -> invItem.m_41720_().m_204114_().m_205785_().m_135782_() == item.m_204114_().m_205785_().m_135782_()).findFirst().orElse(ItemStack.f_41583_);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING}).m_61104_(new Property[]{ORIENTATION}).m_61104_(new Property[]{GLOWING}).m_61104_(new Property[]{SYMBOL});
    }

    public DyeColor getColor() {
        return this.color;
    }

    public VoxelShape m_5909_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        Direction facing = (Direction)blockState.m_61143_((Property)FACING);
        return switch (facing) {
            case Direction.UP -> UP_AABB;
            case Direction.NORTH -> NORTH_AABB;
            case Direction.WEST -> WEST_AABB;
            case Direction.EAST -> EAST_AABB;
            case Direction.SOUTH -> SOUTH_AABB;
            default -> DOWN_AABB;
        };
    }

    public void m_6807_(BlockState blockState, Level level, BlockPos pos, BlockState state, boolean p_60570_) {
        super.m_6807_(blockState, level, pos, state, p_60570_);
        if (level.f_46443_) {
            Chalk.LOGGER.info((Object)blockState);
            Chalk.LOGGER.info((Object)state);
        }
    }

    public InteractionResult m_6227_(BlockState blockState, Level level, BlockPos blockPos, Player player, InteractionHand hand, BlockHitResult rayTraceResult) {
        ItemStack usedStack = player.m_21120_(hand);
        if (!((Boolean)blockState.m_61143_((Property)GLOWING)).booleanValue() && usedStack.m_204117_(Chalk.Tags.Items.GLOWINGS)) {
            if (level.m_7731_(blockPos, (BlockState)blockState.m_61124_((Property)GLOWING, (Comparable)Boolean.valueOf(true)), 11)) {
                if (!player.m_7500_()) {
                    usedStack.m_41774_(1);
                }
                level.m_5594_(null, blockPos, (SoundEvent)Chalk.SoundEvents.GLOW_APPLIED.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                level.m_5594_(null, blockPos, (SoundEvent)Chalk.SoundEvents.GLOWING.get(), SoundSource.BLOCKS, 0.8f, 1.0f);
                ParticleUtils.spawnParticle(level, (ParticleOptions)ParticleTypes.f_123810_, PositionUtils.blockCenterOffsetToFace(blockPos, (Direction)blockState.m_61143_((Property)FACING), 0.3f), new Vector3f(0.0f, 0.03f, 0.0f), 2);
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.FAIL;
        }
        return InteractionResult.PASS;
    }

    public boolean onDestroyedByPlayer(BlockState state, Level level, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        return this.removeMarkWithEffects(level, pos);
    }

    private boolean removeMarkWithEffects(Level level, BlockPos pos) {
        Direction facing = (Direction)level.m_8055_(pos).m_61143_((Property)FACING);
        if (level.m_7471_(pos, false)) {
            level.m_5594_(null, pos, (SoundEvent)Chalk.SoundEvents.MARK_REMOVED.get(), SoundSource.BLOCKS, 0.5f, new Random().nextFloat() * 0.2f + 0.8f);
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                int colorValue = ChalkColors.fromDyeColor(this.color);
                float R = (colorValue & 0xFF0000) >> 16;
                float G = (colorValue & 0xFF00) >> 8;
                float B = colorValue & 0xFF;
                Vector3f centerOffset = PositionUtils.blockCenterOffsetToFace(pos, facing, 0.25f);
                serverLevel.m_8767_((ParticleOptions)new DustParticleOptions(new Vector3f(R / 255.0f, G / 255.0f, B / 255.0f), 2.0f), (double)centerOffset.m_122239_(), (double)centerOffset.m_122260_(), (double)centerOffset.m_122269_(), 1, 0.1, 0.1, 0.1, 0.02);
            } else {
                ParticleUtils.spawnColorDustParticles(this.color, level, pos, facing);
            }
            return true;
        }
        return false;
    }

    public boolean m_7420_(BlockState p_49928_, BlockGetter p_49929_, BlockPos p_49930_) {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_214162_(BlockState blockState, Level level, BlockPos blockPos, RandomSource randomSource) {
        if (((Boolean)blockState.m_61143_((Property)GLOWING)).booleanValue() && randomSource.m_188503_(90) == 0) {
            ParticleUtils.spawnParticle(level, (ParticleOptions)ParticleTypes.f_123810_, PositionUtils.blockCenterOffsetToFace(blockPos, (Direction)blockState.m_61143_((Property)FACING), 0.33f), new Vector3f(0.0f, 0.015f, 0.0f), 1);
        }
    }

    public int getLightEmission(BlockState state, BlockGetter level, BlockPos pos) {
        return (Boolean)state.m_61143_((Property)GLOWING) != false ? (Integer)Config.GLOWING_CHALK_MARK_LIGHT_LEVEL.get() : 0;
    }

    public void m_6256_(BlockState blockState, Level level, BlockPos pos, Player player) {
        this.removeMarkWithEffects(level, pos);
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        if (!state.m_60710_((LevelReader)level, pos)) {
            this.removeMarkWithEffects(level, pos);
            return;
        }
        BlockPos surfacePos = pos.m_121945_(((Direction)state.m_61143_((Property)FACING)).m_122424_());
        if (surfacePos.equals((Object)fromPos) && level.m_8055_(surfacePos).m_60734_() instanceof GrassBlock) {
            level.m_7471_(pos, false);
            level.m_5594_(null, pos, (SoundEvent)Chalk.SoundEvents.MARK_REMOVED.get(), SoundSource.BLOCKS, 0.5f, new Random().nextFloat() * 0.2f + 0.8f);
        }
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        BlockPos surfacePos = pos.m_121945_(facing.m_122424_());
        BlockState surfaceBlockState = level.m_8055_(surfacePos);
        return surfaceBlockState.m_60783_((BlockGetter)level, surfacePos, facing);
    }

    public boolean m_7357_(BlockState p_196266_1_, BlockGetter blockGetter, BlockPos p_196266_3_, PathComputationType p_196266_4_) {
        return true;
    }

    public PushReaction m_5537_(BlockState p_149656_1_) {
        return PushReaction.DESTROY;
    }

    public boolean m_6864_(BlockState blockState, BlockPlaceContext blockItemUseContext) {
        return true;
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        BlockState rotated = (BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_(facing));
        boolean yAxis = facing.m_122434_() == Direction.Axis.Y;
        boolean canRotateSymbol = ((MarkSymbol)((Object)state.m_61143_(SYMBOL))).getOrientationBehavior() != MarkSymbol.OrientationBehavior.FIXED;
        return yAxis && canRotateSymbol ? (BlockState)rotated.m_61124_(ORIENTATION, (Comparable)((Object)((SymbolOrientation)((Object)state.m_61143_(ORIENTATION))).rotate(rotation))) : rotated;
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }
}

