/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.chalk.core;

import com.google.common.base.Preconditions;
import io.github.mortuusars.chalk.block.ChalkMarkBlock;
import io.github.mortuusars.chalk.core.Mark;
import io.github.mortuusars.chalk.core.MarkSymbol;
import io.github.mortuusars.chalk.utils.MarkDrawingContext;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public interface IDrawingTool {
    public Mark getMark(ItemStack var1, MarkDrawingContext var2, MarkSymbol var3);

    public int getMarkColorValue(ItemStack var1);

    public Optional<DyeColor> getMarkColor(ItemStack var1);

    public boolean getGlowing(ItemStack var1);

    public void onMarkDrawn(Player var1, InteractionHand var2, BlockPos var3, BlockState var4);

    default public MarkDrawingContext createDrawingContext(UseOnContext context) {
        Preconditions.checkArgument((context.m_43723_() != null ? 1 : 0) != 0, (Object)"Player should not be null here.");
        return this.createDrawingContext(context.m_43723_(), context.m_8083_(), context.m_43720_(), context.m_43719_(), context.m_43724_());
    }

    default public MarkDrawingContext createDrawingContext(@NotNull Player player, BlockPos clickedPos, Vec3 clickLocation, Direction clickedFace, InteractionHand drawingHand) {
        Level level = player.f_19853_;
        Direction facing = clickedFace;
        BlockPos surfacePos = clickedPos;
        if (level.m_8055_(surfacePos).m_60734_() instanceof ChalkMarkBlock) {
            facing = (Direction)level.m_8055_(surfacePos).m_61143_((Property)ChalkMarkBlock.FACING);
            surfacePos = surfacePos.m_121945_(facing.m_122424_());
        }
        BlockHitResult hitResult = new BlockHitResult(clickLocation, facing, surfacePos, false);
        return new MarkDrawingContext(player, hitResult, drawingHand);
    }

    default public boolean drawMark(MarkDrawingContext drawingContext, Mark mark) {
        if (drawingContext.hasExistingMark() && !drawingContext.shouldMarkReplaceAnother(mark)) {
            return false;
        }
        return drawingContext.draw(mark);
    }
}

