/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.chalk.event;

import io.github.mortuusars.chalk.Chalk;
import io.github.mortuusars.chalk.block.ChalkMarkBlock;
import io.github.mortuusars.chalk.client.gui.ChalkBoxScreen;
import io.github.mortuusars.chalk.core.MarkSymbol;
import io.github.mortuusars.chalk.items.ChalkBoxItem;
import io.github.mortuusars.chalk.render.ChalkMarkBakedModel;
import io.github.mortuusars.chalk.render.ChalkMarkBlockColor;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.renderer.block.BlockModelShaper;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.client.event.RegisterColorHandlersEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber(modid="chalk", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class ClientModEvents {
    @SubscribeEvent
    public static void clientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(() -> {
            MenuScreens.m_96206_((MenuType)((MenuType)Chalk.Menus.CHALK_BOX.get()), ChalkBoxScreen::new);
            ItemProperties.register((Item)((Item)Chalk.Items.CHALK_BOX.get()), (ResourceLocation)ChalkBoxItem.SELECTED_PROPERTY, (stack, level, entity, damage) -> ((ChalkBoxItem)Chalk.Items.CHALK_BOX.get()).getSelectedChalkColor(stack));
        });
    }

    @SubscribeEvent
    public static void onModelBakeEvent(ModelEvent.BakingCompleted event) {
        Chalk.Blocks.MARKS.forEach((color, block) -> {
            for (BlockState blockState : ((ChalkMarkBlock)((Object)((Object)block.get()))).m_49965_().m_61056_()) {
                ModelResourceLocation variantMRL = BlockModelShaper.m_110895_((BlockState)blockState);
                BakedModel existingModel = event.getModelManager().m_119422_(variantMRL);
                if (existingModel instanceof ChalkMarkBakedModel) {
                    Chalk.LOGGER.warn("Tried to replace " + block + " model twice");
                    continue;
                }
                ChalkMarkBakedModel customModel = new ChalkMarkBakedModel(existingModel);
                event.getModels().put(variantMRL, customModel);
            }
        });
    }

    @SubscribeEvent
    public static void registerBlockColors(RegisterColorHandlersEvent.Block event) {
        event.register((BlockColor)new ChalkMarkBlockColor(), (Block[])Chalk.Blocks.MARKS.values().stream().map(RegistryObject::get).toArray(Block[]::new));
    }

    @SubscribeEvent
    public static void onTextureStitchEvent(TextureStitchEvent.Pre event) {
        if (event.getAtlas().m_118330_() == InventoryMenu.f_39692_) {
            for (MarkSymbol symbol : MarkSymbol.values()) {
                event.addSprite(symbol.getTextureLocation());
            }
        }
    }
}

