/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.deathbackup_common_forge.cmds;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.natamus.collective_common_forge.functions.DateFunctions;
import com.natamus.collective_common_forge.functions.PlayerFunctions;
import com.natamus.collective_common_forge.functions.StringFunctions;
import com.natamus.deathbackup_common_forge.util.Util;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class CommandDeathBackup {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"deathbackup").requires(iCommandSender -> iCommandSender.m_6761_(2))).executes(command -> {
            CommandSourceStack source = (CommandSourceStack)command.getSource();
            StringFunctions.sendMessage((CommandSourceStack)source, (String)"Death Backup usage:", (ChatFormatting)ChatFormatting.DARK_GREEN);
            StringFunctions.sendMessage((CommandSourceStack)source, (String)"/deathbackup list - Lists all available backups.", (ChatFormatting)ChatFormatting.DARK_GREEN);
            StringFunctions.sendMessage((CommandSourceStack)source, (String)"/deathbackup load <index> - Loads the backup with <index> from '/deathbackup list'. Index 0 is the last death.", (ChatFormatting)ChatFormatting.DARK_GREEN);
            return 1;
        })).then(Commands.m_82127_((String)"list").executes(command -> {
            ServerPlayer player;
            CommandSourceStack source = (CommandSourceStack)command.getSource();
            try {
                player = source.m_81375_();
            }
            catch (CommandSyntaxException ex) {
                StringFunctions.sendMessage((CommandSourceStack)source, (String)"This command can only be executed as a player in-game.", (ChatFormatting)ChatFormatting.RED);
                return 1;
            }
            Level world = player.m_20193_();
            if (world.f_46443_) {
                StringFunctions.sendMessage((CommandSourceStack)source, (String)"[Error] The world is not remote, unable to load death backup.", (ChatFormatting)ChatFormatting.RED);
                return 1;
            }
            if (!(world instanceof ServerLevel)) {
                StringFunctions.sendMessage((CommandSourceStack)source, (String)"[Error] Cannot find the world's server, unable to load death backup.", (ChatFormatting)ChatFormatting.RED);
                return 1;
            }
            String playername = player.m_7755_().getString().toLowerCase();
            ServerLevel serverworld = (ServerLevel)world;
            List<String> backups = Util.getListOfBackups(serverworld, playername);
            StringFunctions.sendMessage((CommandSourceStack)source, (String)"Last Death Backups: (<index>: <date>)", (ChatFormatting)ChatFormatting.DARK_GREEN, (boolean)true);
            int index = 0;
            for (String ymdhis : backups) {
                StringFunctions.sendMessage((CommandSourceStack)source, (String)(" " + index + ": " + DateFunctions.ymdhisToReadable((String)ymdhis)), (ChatFormatting)ChatFormatting.DARK_GREEN);
                if (++index != 10) continue;
                break;
            }
            StringFunctions.sendMessage((CommandSourceStack)source, (String)"Load the backup with '/deathbackup load <index>'.", (ChatFormatting)ChatFormatting.YELLOW);
            return 1;
        }))).then(Commands.m_82127_((String)"load").then(Commands.m_82129_((String)"backup_index", (ArgumentType)IntegerArgumentType.integer()).executes(command -> {
            ServerPlayer player;
            CommandSourceStack source = (CommandSourceStack)command.getSource();
            try {
                player = source.m_81375_();
            }
            catch (CommandSyntaxException ex) {
                StringFunctions.sendMessage((CommandSourceStack)source, (String)"This command can only be executed as a player in-game.", (ChatFormatting)ChatFormatting.RED);
                return 1;
            }
            Level world = player.m_20193_();
            if (world.f_46443_) {
                StringFunctions.sendMessage((CommandSourceStack)source, (String)"[Error] The world is not remote, unable to load death backup.", (ChatFormatting)ChatFormatting.RED);
                return 1;
            }
            if (!(world instanceof ServerLevel)) {
                StringFunctions.sendMessage((CommandSourceStack)source, (String)"[Error] Cannot find the world's server, unable to load death backup.", (ChatFormatting)ChatFormatting.RED);
                return 1;
            }
            String playername = player.m_7755_().getString().toLowerCase();
            ServerLevel serverworld = (ServerLevel)world;
            List<String> backups = Util.getListOfBackups(serverworld, playername);
            int amount = IntegerArgumentType.getInteger((CommandContext)command, (String)"backup_index");
            if (amount < 0 || amount >= backups.size()) {
                StringFunctions.sendMessage((CommandSourceStack)source, (String)("The index " + amount + " is invalid."), (ChatFormatting)ChatFormatting.RED);
                return 0;
            }
            String backupfilename = backups.get(amount);
            String gearstring = Util.getGearStringFromFile(serverworld, playername, backupfilename);
            if (gearstring.equals("")) {
                StringFunctions.sendMessage((CommandSourceStack)source, (String)"[Error] Unable to read the backup file.", (ChatFormatting)ChatFormatting.RED);
                return 0;
            }
            PlayerFunctions.setPlayerGearFromString((Player)player, (String)gearstring);
            StringFunctions.sendMessage((CommandSourceStack)source, (String)("Successfully loaded the death backup from " + DateFunctions.ymdhisToReadable((String)backupfilename) + " into your inventory."), (ChatFormatting)ChatFormatting.DARK_GREEN);
            return 1;
        }))));
    }
}

