/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukebemish.excavated_variants;

import com.mojang.datafixers.util.Pair;
import io.github.lukebemish.dynamic_asset_generator.api.client.AssetResourceCache;
import io.github.lukebemish.excavated_variants.ExcavatedVariants;
import io.github.lukebemish.excavated_variants.JsonHelper;
import io.github.lukebemish.excavated_variants.LangBuilder;
import io.github.lukebemish.excavated_variants.client.TextureRegistrar;
import io.github.lukebemish.excavated_variants.data.BaseOre;
import io.github.lukebemish.excavated_variants.data.BaseStone;
import io.github.lukebemish.excavated_variants.data.ModData;
import io.github.lukebemish.excavated_variants.platform.Services;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;

public final class ExcavatedVariantsClient {
    public static final LangBuilder LANG_BUILDER = new LangBuilder();

    private ExcavatedVariantsClient() {
    }

    public static void init() {
        Collection<String> modids = Services.PLATFORM.getModIds();
        ExcavatedVariants.setupMap();
        HashMap<String, BaseStone> stoneMap = new HashMap<String, BaseStone>();
        for (ModData mod : ExcavatedVariants.getConfig().mods) {
            if (!modids.containsAll(mod.modId)) continue;
            for (BaseStone baseStone : mod.providedStones) {
                stoneMap.put(baseStone.id, baseStone);
            }
        }
        Map<String, Pair> extractorMap = ExcavatedVariants.oreStoneList.stream().flatMap(p -> ((HashSet)p.getSecond()).stream().map(stone -> new Pair((Object)(stone.id + "_" + ((BaseOre)p.getFirst()).id), (Object)new Pair((Object)((BaseOre)p.getFirst()), (Object)((BaseStone)stoneMap.get(((BaseOre)p.getFirst()).stone.get(0))))))).collect(Collectors.toMap(Pair::getFirst, Pair::getSecond));
        ArrayList<Pair<BaseOre, BaseStone>> toMake = new ArrayList<Pair<BaseOre, BaseStone>>();
        for (Pair pair : ExcavatedVariants.oreStoneList) {
            BaseOre ore = (BaseOre)pair.getFirst();
            for (BaseStone stone : (HashSet)pair.getSecond()) {
                String fullId = stone.id + "_" + ore.id;
                toMake.add((Pair<BaseOre, BaseStone>)new Pair((Object)ore, (Object)stone));
                AssetResourceCache.INSTANCE.planSource(new ResourceLocation("excavated_variants", "models/item/" + fullId + ".json"), rl -> JsonHelper.getItemModel(fullId));
                LANG_BUILDER.add(fullId, stone, ore);
            }
        }
        AssetResourceCache.INSTANCE.planSource(new ResourceLocation("excavated_variants", "lang/en_us.json"), rl -> LANG_BUILDER.build());
        AssetResourceCache.INSTANCE.planSource((Supplier)new TextureRegistrar(extractorMap.values(), toMake));
    }

    static void planLang(String key, String enName) {
        LANG_BUILDER.add(key, enName);
    }
}

