/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukebemish.excavated_variants;

import com.google.gson.JsonElement;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import io.github.lukebemish.excavated_variants.ExcavatedVariants;
import io.github.lukebemish.excavated_variants.data.BaseOre;
import io.github.lukebemish.excavated_variants.data.BaseStone;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;

public class LangBuilder {
    private static final Codec<Map<String, String>> CODEC = Codec.unboundedMap((Codec)Codec.STRING, (Codec)Codec.STRING);
    private final Map<String, String> internal = new HashMap<String, String>();

    public void add(String fullId, BaseStone stone, BaseOre ore) {
        Object enName = ore.en_name.contains("$") ? ore.en_name.replaceFirst("\\$", stone.en_name) : stone.en_name + " " + ore.en_name;
        this.internal.put("block.excavated_variants." + fullId, (String)enName);
    }

    public void add(String key, String name) {
        this.internal.put(key, name);
    }

    public Supplier<InputStream> build() {
        String json = ExcavatedVariants.GSON.toJson((JsonElement)CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, this.internal).getOrThrow(false, e -> {}));
        return () -> new ByteArrayInputStream(json.getBytes());
    }
}

