/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukebemish.excavated_variants.client;

import blue.endless.jankson.Jankson;
import blue.endless.jankson.JsonObject;
import blue.endless.jankson.api.SyntaxError;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.lukebemish.codecutils.api.JanksonOps;
import io.github.lukebemish.excavated_variants.ExcavatedVariants;
import io.github.lukebemish.excavated_variants.client.BackupFetcher;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import net.minecraft.ResourceLocationException;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ExtraCodecs;
import org.jetbrains.annotations.Nullable;

public record BlockModelHolder(Optional<ResourceLocation> parent, Map<String, String> textures, List<ElementDefinition> elements, Optional<Map<String, BlockModelHolder>> children) {
    public static final List<String> SIDES = List.of("down", "up", "north", "south", "west", "east");
    private static final Jankson JANKSON = Jankson.builder().build();
    public static final Codec<BlockModelHolder> CODEC = ExtraCodecs.m_184415_(() -> RecordCodecBuilder.create(i -> i.group((App)ResourceLocation.f_135803_.optionalFieldOf("parent").forGetter(BlockModelHolder::parent), (App)Codec.unboundedMap((Codec)Codec.STRING, (Codec)Codec.STRING).optionalFieldOf("textures", Map.of()).forGetter(BlockModelHolder::textures), (App)ElementDefinition.CODEC.listOf().optionalFieldOf("elements", List.of()).forGetter(BlockModelHolder::elements), (App)Codec.unboundedMap((Codec)Codec.STRING, CODEC).optionalFieldOf("children").forGetter(BlockModelHolder::children)).apply((Applicative)i, BlockModelHolder::new)));

    @Nullable
    public static ResourceLocation resolveTexture(Map<String, String> map, String texName) {
        String found = map.get(texName = texName.substring(1));
        if (found == null) {
            return null;
        }
        if (found.startsWith("#")) {
            return BlockModelHolder.resolveTexture(map, found);
        }
        return ResourceLocation.m_135822_((String)found, (char)':');
    }

    @Nullable
    public static BlockModelHolder getFromLocation(ResourceLocation rl) {
        BlockModelHolder blockModelHolder;
        block8: {
            InputStream is = BackupFetcher.tryAndProvideModelFile(rl);
            try {
                JsonObject json = JANKSON.load(is);
                blockModelHolder = (BlockModelHolder)CODEC.parse((DynamicOps)JanksonOps.INSTANCE, (Object)json).getOrThrow(false, e -> {});
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SyntaxError | IOException | RuntimeException e2) {
                    ExcavatedVariants.LOGGER.error("Could not read model {}", (Object)rl, (Object)e2);
                    return null;
                }
            }
            is.close();
        }
        return blockModelHolder;
    }

    public static BlockModelHolder getFromString(String string) {
        try {
            JsonObject json = JANKSON.load(string);
            return (BlockModelHolder)CODEC.parse((DynamicOps)JanksonOps.INSTANCE, (Object)json).getOrThrow(false, e -> {});
        }
        catch (SyntaxError | RuntimeException e2) {
            ExcavatedVariants.LOGGER.error("Could not read model:\n{}", (Object)string, (Object)e2);
            return null;
        }
    }

    private static ResourceLocation resolveTexture(Map<String, String> map, Set<String> stack, String name) {
        String out = map.get(name);
        if (out == null) {
            return null;
        }
        try {
            return ResourceLocation.m_135822_((String)out, (char)':');
        }
        catch (ResourceLocationException resourceLocationException) {
            out = out.substring(1);
            if (stack.contains(out)) {
                return null;
            }
            stack.add(out);
            return BlockModelHolder.resolveTexture(map, stack, out);
        }
    }

    public Map<String, String> getTextureMap() {
        BlockModelHolder parent;
        HashMap<String, String> textures = new HashMap<String, String>();
        BlockModelHolder blockModelHolder = parent = this.parent().isEmpty() ? null : BlockModelHolder.getFromLocation(this.parent().get());
        if (parent != null) {
            textures.putAll(parent.getTextureMap());
        }
        textures.putAll(this.textures());
        return textures;
    }

    public Map<String, ResourceLocation> getResolvedTextureMap() {
        HashMap<String, ResourceLocation> out = new HashMap<String, ResourceLocation>();
        Map<String, String> textures = this.getTextureMap();
        textures.keySet().forEach(k -> {
            ResourceLocation rl = BlockModelHolder.resolveTexture(textures, new HashSet<String>(), k);
            if (rl != null) {
                out.put((String)k, rl);
            }
        });
        return out;
    }

    private Map<LocationKey, List<ResourceLocation>> getRlMapForSide(String side) {
        return this.getRlMapForSide(side, Map.of());
    }

    private Map<LocationKey, List<ResourceLocation>> getRlMapForSide(String side, Map<String, String> oldTexMap) {
        HashMap<LocationKey, List<ResourceLocation>> map = new HashMap<LocationKey, List<ResourceLocation>>();
        HashMap<String, String> texMap = new HashMap<String, String>(oldTexMap);
        texMap.putAll(this.getTextureMap());
        if (this.parent().isPresent()) {
            map.putAll(BlockModelHolder.getFromLocation(this.parent().get()).getRlMapForSide(side, texMap));
        }
        if (this.children().isEmpty() || this.children().get().isEmpty()) {
            for (ElementDefinition definition : this.elements()) {
                if (!definition.faces.containsKey(side)) continue;
                LocationKey key = definition.getLocationKey();
                List rls = map.computeIfAbsent(key, k -> new ArrayList());
                FaceDefinition face = definition.faces.get(side);
                String texture = face.texture();
                ResourceLocation location = BlockModelHolder.resolveTexture(texMap, texture);
                if (location == null) continue;
                rls.add(location);
            }
        } else {
            List<Map> maps = this.children().get().values().stream().map(h -> h.getRlMapForSide(side, texMap)).toList();
            maps.forEach(m -> m.forEach((key, rls) -> map.merge((LocationKey)key, (List<ResourceLocation>)rls, (l1, l2) -> {
                ArrayList rlList = new ArrayList(l1);
                rlList.addAll(l2);
                return rlList;
            })));
        }
        return map;
    }

    public List<List<ResourceLocation>> setupOverlays() {
        HashSet<List> overlays = new HashSet<List>();
        for (String side : SIDES) {
            Map<LocationKey, List<ResourceLocation>> sideMap = this.getRlMapForSide(side);
            overlays.addAll(sideMap.values().stream().filter(l -> !l.isEmpty()).toList());
        }
        return overlays.stream().toList();
    }

    public record ElementDefinition(Map<String, FaceDefinition> faces, List<Integer> from, List<Integer> to, RotationDefinition rotation) {
        public static final Codec<ElementDefinition> CODEC = RecordCodecBuilder.create(i -> i.group((App)Codec.unboundedMap((Codec)Codec.STRING, FaceDefinition.CODEC).optionalFieldOf("faces", Map.of()).forGetter(ElementDefinition::faces), (App)Codec.INT.listOf().optionalFieldOf("from", List.of(Integer.valueOf(0), Integer.valueOf(0), Integer.valueOf(0))).forGetter(ElementDefinition::from), (App)Codec.INT.listOf().optionalFieldOf("to", List.of(Integer.valueOf(16), Integer.valueOf(16), Integer.valueOf(16))).forGetter(ElementDefinition::to), (App)RotationDefinition.CODEC.optionalFieldOf("rotation", (Object)new RotationDefinition(List.of(Integer.valueOf(0), Integer.valueOf(0), Integer.valueOf(0)), "x", 0.0f)).forGetter(ElementDefinition::rotation)).apply((Applicative)i, ElementDefinition::new));

        public LocationKey getLocationKey() {
            List<Integer> from = Stream.of(0, 1, 2).map(i -> Math.min(this.from().get((int)i), this.to().get((int)i))).toList();
            List<Integer> to = Stream.of(0, 1, 2).map(i -> Math.max(this.from().get((int)i), this.to().get((int)i))).toList();
            return new LocationKey(this.rotation().origin(), this.rotation().axis(), this.rotation().angle(), from, to);
        }
    }

    public record LocationKey(List<Integer> origin, String axis, float angle, List<Integer> of, List<Integer> to) {
    }

    public record FaceDefinition(String texture) {
        public static final Codec<FaceDefinition> CODEC = RecordCodecBuilder.create(i -> i.group((App)Codec.STRING.fieldOf("texture").forGetter(FaceDefinition::texture)).apply((Applicative)i, FaceDefinition::new));
    }

    public record RotationDefinition(List<Integer> origin, String axis, float angle) {
        public static final Codec<RotationDefinition> CODEC = RecordCodecBuilder.create(i -> i.group((App)Codec.INT.listOf().fieldOf("origin").forGetter(RotationDefinition::origin), (App)Codec.STRING.fieldOf("axis").forGetter(RotationDefinition::axis), (App)Codec.FLOAT.fieldOf("angle").forGetter(RotationDefinition::angle)).apply((Applicative)i, RotationDefinition::new));
    }
}

