/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukebemish.excavated_variants.client;

import com.mojang.datafixers.util.Pair;
import io.github.lukebemish.dynamic_asset_generator.api.IInputStreamSource;
import io.github.lukebemish.dynamic_asset_generator.api.IPathAwareInputStreamSource;
import io.github.lukebemish.dynamic_asset_generator.api.client.generators.DynamicTextureSource;
import io.github.lukebemish.dynamic_asset_generator.api.client.generators.ITexSource;
import io.github.lukebemish.dynamic_asset_generator.api.client.generators.TextureMetaGenerator;
import io.github.lukebemish.dynamic_asset_generator.api.client.generators.texsources.AnimationFrameCapture;
import io.github.lukebemish.dynamic_asset_generator.api.client.generators.texsources.AnimationSplittingSource;
import io.github.lukebemish.dynamic_asset_generator.api.client.generators.texsources.ForegroundTransfer;
import io.github.lukebemish.dynamic_asset_generator.api.client.generators.texsources.Overlay;
import io.github.lukebemish.dynamic_asset_generator.api.client.generators.texsources.TextureReader;
import io.github.lukebemish.excavated_variants.client.BlockStateAssembler;
import io.github.lukebemish.excavated_variants.data.BaseOre;
import io.github.lukebemish.excavated_variants.data.BaseStone;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class TextureRegistrar
implements Supplier<IPathAwareInputStreamSource> {
    private final Collection<Pair<BaseOre, BaseStone>> originalPairs;
    private final List<Pair<BaseOre, BaseStone>> toMake;

    public TextureRegistrar(Collection<Pair<BaseOre, BaseStone>> originalPairs, List<Pair<BaseOre, BaseStone>> toMake) {
        this.originalPairs = originalPairs;
        this.toMake = toMake;
    }

    public Pair<IInputStreamSource, IInputStreamSource> setupExtractor(List<ResourceLocation> stoneOrigs, List<ResourceLocation> ores, ResourceLocation stoneNew, ResourceLocation out) {
        HashMap<Object, AnimationSplittingSource.TimeAwareSource> sourceMap = new HashMap<Object, AnimationSplittingSource.TimeAwareSource>();
        int c1 = 0;
        for (ResourceLocation resourceLocation : stoneOrigs) {
            sourceMap.put("stoneOrig" + c1, new AnimationSplittingSource.TimeAwareSource((ITexSource)new TextureReader(resourceLocation), 1));
            ++c1;
        }
        int c3 = 0;
        for (ResourceLocation ore : ores) {
            sourceMap.put("ore" + c3, new AnimationSplittingSource.TimeAwareSource((ITexSource)new TextureReader(ore), 1));
            ++c3;
        }
        sourceMap.put("stoneNew", new AnimationSplittingSource.TimeAwareSource((ITexSource)new TextureReader(stoneNew), 1));
        ArrayList<AnimationFrameCapture> arrayList = new ArrayList<AnimationFrameCapture>();
        for (int c2 = 0; c2 < c1; ++c2) {
            arrayList.add(new AnimationFrameCapture("stoneOrig" + c2));
        }
        ArrayList<AnimationFrameCapture> oreSources = new ArrayList<AnimationFrameCapture>();
        for (int c2 = 0; c2 < c3; ++c2) {
            oreSources.add(new AnimationFrameCapture("ore" + c2));
        }
        DynamicTextureSource p1 = new DynamicTextureSource(out, (ITexSource)new AnimationSplittingSource(sourceMap, (ITexSource)new ForegroundTransfer((ITexSource)new Overlay(arrayList), (ITexSource)new Overlay(oreSources), (ITexSource)new AnimationFrameCapture("stoneNew"), 6, true, true, true, 0.2)));
        ArrayList<ResourceLocation> sources = new ArrayList<ResourceLocation>(stoneOrigs);
        sources.addAll(ores);
        sources.add(stoneNew);
        TextureMetaGenerator p2 = new TextureMetaGenerator(sources, Optional.empty(), Optional.empty(), Optional.empty(), out);
        return new Pair((Object)p1, (Object)p2);
    }

    @Override
    public IPathAwareInputStreamSource get() {
        final Map<ResourceLocation, Supplier<InputStream>> resources = BlockStateAssembler.getMap(this, this.originalPairs, this.toMake);
        return new IPathAwareInputStreamSource(){

            @NotNull
            public Set<ResourceLocation> getLocations() {
                return resources.keySet();
            }

            @NotNull
            public Supplier<InputStream> get(ResourceLocation outRl) {
                return resources.getOrDefault(outRl, () -> null);
            }
        };
    }
}

