/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukebemish.excavated_variants.compat.jei;

import com.mojang.datafixers.util.Pair;
import io.github.lukebemish.excavated_variants.ExcavatedVariants;
import io.github.lukebemish.excavated_variants.data.BaseOre;
import io.github.lukebemish.excavated_variants.data.BaseStone;
import io.github.lukebemish.excavated_variants.platform.Services;
import io.github.lukebemish.excavated_variants.recipe.OreConversionRecipe;
import java.util.ArrayList;
import java.util.HashSet;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

@JeiPlugin
public class JeiCompat
implements IModPlugin {
    @NotNull
    public ResourceLocation getPluginUid() {
        return new ResourceLocation("excavated_variants", "jei_plugin");
    }

    public void registerRecipes(@NotNull IRecipeRegistration registration) {
        if (ExcavatedVariants.getConfig().addConversionRecipes && ExcavatedVariants.getConfig().jeiReiCompat) {
            ArrayList<ShapelessRecipe> recipes = new ArrayList<ShapelessRecipe>();
            OreConversionRecipe.assembleOrNull();
            for (Pair<BaseOre, HashSet<BaseStone>> p : ExcavatedVariants.oreStoneList) {
                ArrayList<Item> items = new ArrayList<Item>();
                for (BaseStone stone : (HashSet)p.getSecond()) {
                    ResourceLocation rl = new ResourceLocation("excavated_variants", stone.id + "_" + ((BaseOre)p.getFirst()).id);
                    Item item = Services.REGISTRY_UTIL.getItemById(rl);
                    if (item == null) continue;
                    items.add(item);
                }
                Item outItem = Services.REGISTRY_UTIL.getItemById(((BaseOre)p.getFirst()).block_id.get(0));
                if (items.isEmpty() || outItem == null) continue;
                Ingredient input = Ingredient.m_43921_(items.stream().map(ItemStack::new));
                ItemStack output = new ItemStack((ItemLike)outItem);
                NonNullList inputs = NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])new Ingredient[]{input});
                String oreId = ((BaseOre)p.getFirst()).id;
                recipes.add(new ShapelessRecipe(new ResourceLocation("excavated_variants", oreId + "_conversion"), "excavated_variants.ore_conversion", output, inputs));
            }
            registration.addRecipes(RecipeTypes.CRAFTING, recipes);
        }
    }
}

