/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukebemish.excavated_variants.forge;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.forgespi.language.ModFileScanData;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.objectweb.asm.Type;

public final class PluginFinder {
    private static final Logger LOGGER = LogManager.getLogger();

    public static <T> List<T> getInstances(Class<?> annotationClass, Class<T> instanceClass) {
        Type annotationType = Type.getType(annotationClass);
        List scanData = ModList.get().getAllScanData();
        LinkedHashSet<String> names = new LinkedHashSet<String>();
        for (ModFileScanData scanDatum : scanData) {
            Set annotations = scanDatum.getAnnotations();
            for (ModFileScanData.AnnotationData a : annotations) {
                if (!Objects.equals(a.annotationType(), annotationType)) continue;
                String memberName = a.memberName();
                names.add(memberName);
            }
        }
        ArrayList<T> instances = new ArrayList<T>();
        for (String name : names) {
            try {
                Class<?> clazz = Class.forName(name);
                Class<T> asSubclass = clazz.asSubclass(instanceClass);
                Constructor<T> constructor = asSubclass.getDeclaredConstructor(new Class[0]);
                T instance = constructor.newInstance(new Object[0]);
                instances.add(instance);
            }
            catch (LinkageError | ReflectiveOperationException e) {
                LOGGER.error("Failed to load: {}", (Object)name, (Object)e);
            }
        }
        return instances;
    }
}

