/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.client.util;

import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix3f;
import com.mojang.math.Vector3f;
import com.mojang.math.Vector4f;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Rotation;

public class VertexUtil {
    private static int getFormatLength() {
        return DefaultVertexFormat.f_85811_.m_86017_();
    }

    public static List<BakedQuad> swapSprite(List<BakedQuad> quads, TextureAtlasSprite sprite) {
        ArrayList<BakedQuad> newList = new ArrayList<BakedQuad>();
        for (BakedQuad q : quads) {
            TextureAtlasSprite oldSprite = q.m_173410_();
            int formatLength = VertexUtil.getFormatLength();
            int[] v = Arrays.copyOf(q.m_111303_(), q.m_111303_().length);
            for (int i = 0; i < v.length / formatLength; ++i) {
                float originalU = Float.intBitsToFloat(v[i * formatLength + 4]);
                float originalV = Float.intBitsToFloat(v[i * formatLength + 5]);
                v[i * formatLength + 4] = Float.floatToIntBits(originalU - oldSprite.m_118409_() + sprite.m_118409_());
                v[i * formatLength + 5] = Float.floatToIntBits(originalV - oldSprite.m_118411_() + sprite.m_118411_());
            }
            newList.add(new BakedQuad(v, q.m_111305_(), q.m_111306_(), sprite, q.m_111307_()));
        }
        return newList;
    }

    public static void transformVertices(int[] v, Matrix3f transform) {
        int formatLength = VertexUtil.getFormatLength();
        for (int i = 0; i < v.length / formatLength; ++i) {
            float originalX = Float.intBitsToFloat(v[i * formatLength]) - 0.5f;
            float originalY = Float.intBitsToFloat(v[i * formatLength + 1]) - 0.5f;
            float originalZ = Float.intBitsToFloat(v[i * formatLength + 2]) - 0.5f;
            Vector3f vector3f = new Vector3f(originalX, originalY, originalZ);
            vector3f.m_122249_(transform);
            v[i * formatLength] = Float.floatToIntBits(vector3f.m_122239_() + 0.5f);
            v[i * formatLength + 1] = Float.floatToIntBits(vector3f.m_122260_() + 0.5f);
            v[i * formatLength + 2] = Float.floatToIntBits(vector3f.m_122269_() + 0.5f);
        }
    }

    public static void transformVertices(int[] v, PoseStack stack, TextureAtlasSprite sprite) {
        Vector4f vector4f = new Vector4f(0.0f, 0.0f, 0.0f, 1.0f);
        vector4f.m_123607_(stack.m_85850_().m_85861_());
        VertexUtil.moveVertices(v, vector4f.m_123601_(), vector4f.m_123615_(), vector4f.m_123616_());
    }

    public static void rotateVerticesY(int[] v, TextureAtlasSprite sprite, Rotation rot) {
        Matrix3f matrix = rot.m_55948_().m_174948_();
        VertexUtil.transformVertices(v, matrix);
    }

    public static void moveVertices(int[] v, Direction dir, float amount) {
        int formatLength = VertexUtil.getFormatLength();
        int axis = dir.m_122434_().ordinal();
        float step = amount * (float)dir.m_122421_().m_122540_();
        for (int i = 0; i < v.length / formatLength; ++i) {
            float original = Float.intBitsToFloat(v[i * formatLength + axis]);
            v[i * formatLength + axis] = Float.floatToIntBits(original + step);
        }
    }

    public static void moveVertices(int[] v, float x, float y, float z) {
        int formatLength = VertexUtil.getFormatLength();
        for (int i = 0; i < v.length / formatLength; ++i) {
            float originalX = Float.intBitsToFloat(v[i * formatLength]);
            v[i * formatLength] = Float.floatToIntBits(originalX + x);
            float originalY = Float.intBitsToFloat(v[i * formatLength + 1]);
            v[i * formatLength + 1] = Float.floatToIntBits(originalY + y);
            float originalZ = Float.intBitsToFloat(v[i * formatLength + 2]);
            v[i * formatLength + 2] = Float.floatToIntBits(originalZ + z);
        }
    }

    public static void scaleVertices(int[] v, float scale) {
        int formatLength = VertexUtil.getFormatLength();
        for (int i = 0; i < v.length / formatLength; ++i) {
            float originalX = Float.intBitsToFloat(v[i * formatLength]);
            v[i * formatLength] = Float.floatToIntBits(originalX * scale);
            float originalY = Float.intBitsToFloat(v[i * formatLength + 1]);
            v[i * formatLength + 1] = Float.floatToIntBits(originalY * scale);
            float originalZ = Float.intBitsToFloat(v[i * formatLength + 2]);
            v[i * formatLength + 2] = Float.floatToIntBits(originalZ * scale);
        }
    }

    public static void addQuad(VertexConsumer builder, PoseStack poseStack, float x0, float y0, float x1, float y1, float u0, float v0, float u1, float v1, int r, int g, int b, int a, int lu, int lv) {
        PoseStack.Pose last = poseStack.m_85850_();
        Vector3f vector3f = new Vector3f(0.0f, 0.0f, -1.0f);
        vector3f.m_122249_(last.m_85864_());
        float nx = vector3f.m_122239_();
        float ny = vector3f.m_122260_();
        float nz = vector3f.m_122269_();
        VertexUtil.vertF(builder, poseStack, x0, y1, 0.0f, u0, v0, r, g, b, a, lu, lv, nx, ny, nz);
        VertexUtil.vertF(builder, poseStack, x1, y1, 0.0f, u1, v0, r, g, b, a, lu, lv, nx, ny, nz);
        VertexUtil.vertF(builder, poseStack, x1, y0, 0.0f, u1, v1, r, g, b, a, lu, lv, nx, ny, nz);
        VertexUtil.vertF(builder, poseStack, x0, y0, 0.0f, u0, v1, r, g, b, a, lu, lv, nx, ny, nz);
    }

    public static void vert(VertexConsumer builder, PoseStack poseStack, float x, float y, float z, float u, float v, float r, float g, float b, float a, int lu, int lv, float nx, float ny, float nz) {
        builder.m_85982_(poseStack.m_85850_().m_85861_(), x, y, z);
        builder.m_85950_(r, g, b, a);
        builder.m_7421_(u, v);
        builder.m_7122_(0, 10);
        builder.m_7120_(lu, lv);
        builder.m_85977_(poseStack.m_85850_().m_85864_(), nx, ny, nz);
        builder.m_5752_();
    }

    private static void vertF(VertexConsumer builder, PoseStack poseStack, float x, float y, float z, float u, float v, int r, int g, int b, int a, int lu, int lv, float nx, float ny, float nz) {
        builder.m_85982_(poseStack.m_85850_().m_85861_(), x, y, z);
        builder.m_6122_(r, g, b, a);
        builder.m_7421_(u, v);
        builder.m_7122_(0, 10);
        builder.m_7120_(lu, lv);
        builder.m_5601_(nx, ny, nz);
        builder.m_5752_();
    }

    private static void vertF(VertexConsumer builder, PoseStack poseStack, float x, float y, float z, float u, float v, int color, int lu, int lv, float nx, float ny, float nz) {
        builder.m_85982_(poseStack.m_85850_().m_85861_(), x, y, z);
        builder.m_193479_(color);
        builder.m_7421_(u, v);
        builder.m_7122_(0, 10);
        builder.m_7120_(lu, lv);
        builder.m_5601_(nx, ny, nz);
        builder.m_5752_();
    }
}

