/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.fluids.forge;

import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluid;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluidRegistry;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.minecraft.core.MappedRegistry;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fluids.ForgeFlowingFluid;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryInternal;
import net.minecraftforge.registries.RegistryBuilder;
import net.minecraftforge.registries.RegistryManager;
import net.minecraftforge.registries.RegistryObject;

public class SoftFluidRegistryImpl {
    private static final ResourceLocation FLUIDS_MAP_KEY = Moonlight.res("fluids_map");
    private static final ResourceLocation ITEMS_MAP_KEY = Moonlight.res("items_map");
    public static final ResourceKey<Registry<SoftFluid>> KEY = ResourceKey.m_135788_((ResourceLocation)Moonlight.res("soft_fluids"));
    public static final DeferredRegister<SoftFluid> DEFERRED_REGISTER = DeferredRegister.create(KEY, (String)KEY.m_135782_().m_135827_());
    public static final Supplier<IForgeRegistry<SoftFluid>> SOFT_FLUIDS = DEFERRED_REGISTER.makeRegistry(() -> new RegistryBuilder().setDefaultKey(SoftFluidRegistry.EMPTY_ID).dataPackRegistry(SoftFluid.CODEC, SoftFluid.CODEC).onCreate(SoftFluidRegistryImpl::onCreate).onClear(SoftFluidRegistryImpl::onClear).allowModification().disableSaving());
    private static final RegistryObject<SoftFluid> EMPTY = DEFERRED_REGISTER.register(SoftFluidRegistry.EMPTY_ID.m_135815_(), () -> new SoftFluid.Builder(new ResourceLocation(""), new ResourceLocation("")).build());

    public static void init() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        DEFERRED_REGISTER.register(bus);
    }

    public static ResourceKey<Registry<SoftFluid>> getRegistryKey() {
        return KEY;
    }

    public static Map<Fluid, SoftFluid> getFluidsMap() {
        return (Map)SOFT_FLUIDS.get().getSlaveMap(FLUIDS_MAP_KEY, HashMap.class);
    }

    public static Map<Item, SoftFluid> getItemsMap() {
        return (Map)SOFT_FLUIDS.get().getSlaveMap(ITEMS_MAP_KEY, HashMap.class);
    }

    public static void onCreate(IForgeRegistryInternal<SoftFluid> owner, RegistryManager stage) {
        owner.setSlaveMap(FLUIDS_MAP_KEY, new IdentityHashMap());
        owner.setSlaveMap(ITEMS_MAP_KEY, new IdentityHashMap());
    }

    public static void onClear(IForgeRegistryInternal<SoftFluid> owner, RegistryManager stage) {
        ((IdentityHashMap)owner.getSlaveMap(FLUIDS_MAP_KEY, IdentityHashMap.class)).clear();
        ((IdentityHashMap)owner.getSlaveMap(ITEMS_MAP_KEY, IdentityHashMap.class)).clear();
    }

    public static void registerExistingVanillaFluids() {
        Map<Fluid, SoftFluid> fluidMap = SoftFluidRegistryImpl.getFluidsMap();
        MappedRegistry reg = (MappedRegistry)SoftFluidRegistry.getDataPackRegistry();
        reg.unfreeze();
        for (Fluid f : ForgeRegistries.FLUIDS) {
            try {
                FlowingFluid flowingFluid;
                if (f == null || f instanceof FlowingFluid && (flowingFluid = (FlowingFluid)f).m_5613_() != f || f instanceof ForgeFlowingFluid.Flowing || f == Fluids.f_76191_ || fluidMap.containsKey(f)) continue;
                Utils.getID(f);
                SoftFluid sf = new SoftFluid.Builder(f).build();
                Registry.m_122965_((Registry)reg, (ResourceLocation)Utils.getID(f), (Object)sf);
                fluidMap.put(f, sf);
            }
            catch (Exception exception) {}
        }
        reg.m_203521_();
    }
}

