/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.core.misc;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.datafixers.util.Pair;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.mehvahdjukaar.moonlight.core.misc.VillagerAIInternal;
import net.mehvahdjukaar.moonlight.core.mixins.accessor.BrainAccessor;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.ExpirableValue;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.entity.schedule.Schedule;
import net.minecraft.world.entity.schedule.ScheduleBuilder;

public class VillagerBrainEventInternal {
    private TreeMap<Integer, Activity> scheduleBuilder = null;
    private final Brain<Villager> brain;
    private final Villager villager;

    public VillagerBrainEventInternal(Brain<Villager> brain, Villager villager) {
        this.brain = brain;
        this.villager = villager;
    }

    public Villager getVillager() {
        return this.villager;
    }

    public Map<MemoryModuleType<?>, Optional<? extends ExpirableValue<?>>> getMemories() {
        return this.brain.m_147339_();
    }

    public void addOrReplaceActivity(Activity activity, ImmutableList<? extends Pair<Integer, ? extends Behavior<? super Villager>>> activityPackage) {
        this.brain.m_21900_(activity, activityPackage);
    }

    public void scheduleActivity(Activity activity, int startTime, int endTime) {
        if (this.scheduleBuilder == null) {
            this.scheduleBuilder = this.makeDefaultSchedule(this.villager);
        }
        TreeMap<Integer, Activity> newSchedule = new TreeMap<Integer, Activity>();
        newSchedule.put(startTime, activity);
        Activity previousActivity = this.scheduleBuilder.lastEntry().getValue();
        for (Map.Entry<Integer, Activity> e : this.scheduleBuilder.entrySet()) {
            int key = e.getKey();
            if (key < endTime) {
                previousActivity = e.getValue();
            }
            if (startTime < endTime) {
                if (key >= startTime && key <= endTime) continue;
                newSchedule.put(key, e.getValue());
                continue;
            }
            if (key <= endTime || key >= startTime) continue;
            newSchedule.put(key, e.getValue());
        }
        newSchedule.put(endTime, previousActivity);
        this.scheduleBuilder = newSchedule;
    }

    public void addSensor(SensorType<? extends Sensor<Villager>> newSensor) {
        try {
            Map sensors = ((BrainAccessor)this.brain).getSensors();
            Sensor sensorInstance = newSensor.m_26827_();
            sensors.put(newSensor, sensorInstance);
            Map memories = this.brain.m_147339_();
            for (MemoryModuleType memoryModuleType : sensorInstance.m_7163_()) {
                memories.put(memoryModuleType, Optional.empty());
            }
        }
        catch (Exception e) {
            Moonlight.LOGGER.warn("failed to register pumpkin sensor type for villagers: " + e);
        }
    }

    public <P extends Pair<Integer, ? extends Behavior<Villager>>> boolean addTaskToActivity(Activity activity, P task) {
        try {
            Map map = ((BrainAccessor)this.brain).getAvailableBehaviorsByPriority();
            Map tasksWithSamePriority = map.computeIfAbsent((Integer)task.getFirst(), m -> Maps.newHashMap());
            Set activityTaskSet = tasksWithSamePriority.computeIfAbsent(activity, a -> Sets.newLinkedHashSet());
            activityTaskSet.add((Behavior)task.getSecond());
            return true;
        }
        catch (Exception e) {
            Moonlight.LOGGER.warn("failed to add task for activity {} for villagers: {}", (Object)activity, (Object)e);
            return false;
        }
    }

    private TreeMap<Integer, Activity> makeDefaultSchedule(Villager villager) {
        TreeMap<Integer, Activity> map = new TreeMap<Integer, Activity>();
        if (villager.m_6162_()) {
            map.put(10, Activity.f_37979_);
            map.put(3000, Activity.f_37981_);
            map.put(6000, Activity.f_37979_);
            map.put(10000, Activity.f_37981_);
            map.put(12000, Activity.f_37982_);
        } else {
            map.put(10, Activity.f_37979_);
            map.put(2000, Activity.f_37980_);
            map.put(9000, Activity.f_37983_);
            map.put(11000, Activity.f_37979_);
            map.put(12000, Activity.f_37982_);
        }
        return map;
    }

    Schedule buildFinalizedSchedule() {
        ScheduleBuilder builder = new ScheduleBuilder(VillagerAIInternal.CUSTOM_VILLAGER_SCHEDULE.get());
        for (Map.Entry<Integer, Activity> e : this.scheduleBuilder.entrySet()) {
            builder.m_38040_(e.getKey().intValue(), e.getValue());
        }
        return builder.m_38039_();
    }

    boolean hasCustomSchedule() {
        return this.scheduleBuilder != null;
    }
}

