/*
 * Decompiled with CFR 0.152.
 */
package me.pieking1215.invmove;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.vertex.PoseStack;
import java.io.File;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import me.pieking1215.invmove.InvMoveConfig;
import me.pieking1215.invmove.InvMoveNoOp;
import me.pieking1215.invmove.module.CVComponent;
import me.pieking1215.invmove.module.Module;
import me.pieking1215.invmove.module.VanillaModule16;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.ToggleKeyMapping;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.Input;
import net.minecraft.network.chat.MutableComponent;

public abstract class InvMove {
    private static InvMove instance;
    public static final String MOD_ID = "invmove";
    private static final KeyMapping TOGGLE_MOVEMENT_KEY;
    private static final List<Module> addonModules;
    protected boolean wasSneaking = false;
    protected boolean wasToggleMovementPressed = false;
    protected Map<ToggleKeyMapping, Boolean> wasToggleKeyDown = new HashMap<ToggleKeyMapping, Boolean>();
    public final List<Module> modules = new ArrayList<Module>();

    public static InvMove instance() {
        if (instance == null) {
            instance = new InvMoveNoOp();
        }
        return instance;
    }

    public static void setInstance(InvMove newInstance) {
        instance = newInstance;
    }

    public static void registerModule(Module module) {
        (instance != null ? InvMove.instance.modules : addonModules).add(module);
    }

    public abstract Optional<String> modidFromClass(Class<?> var1);

    public abstract String modNameFromModid(String var1);

    public abstract boolean hasMod(String var1);

    public abstract File configDir();

    protected abstract void registerKeybind(KeyMapping var1);

    public abstract MutableComponent translatableComponent(String var1);

    public abstract MutableComponent literalComponent(String var1);

    public MutableComponent fromCV(CVComponent c) {
        if (c.translate) {
            return this.translatableComponent(c.text);
        }
        return this.literalComponent(c.text);
    }

    public abstract boolean optionToggleCrouch();

    public abstract void setOptionToggleCrouch(boolean var1);

    public InvMove() {
        this.modules.addAll(addonModules);
        addonModules.clear();
        this.modules.add(0, this.getVanillaModule());
        this.registerKeybind(TOGGLE_MOVEMENT_KEY);
    }

    public Module getVanillaModule() {
        return new VanillaModule16();
    }

    public void finishInit() {
        InvMoveConfig.load();
    }

    private boolean handleToggleMovementKey(Screen screen, boolean couldMove) {
        if (TOGGLE_MOVEMENT_KEY.m_90862_()) {
            return couldMove;
        }
        TOGGLE_MOVEMENT_KEY.m_7249_(InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)InvMove.TOGGLE_MOVEMENT_KEY.f_90816_.m_84873_()));
        boolean before = this.wasToggleMovementPressed;
        this.wasToggleMovementPressed = InvMove.TOGGLE_MOVEMENT_KEY.f_90817_;
        if (InvMove.TOGGLE_MOVEMENT_KEY.f_90817_ && !before) {
            if (screen == null) {
                InvMoveConfig.MOVEMENT.ENABLED.set((Boolean)InvMoveConfig.MOVEMENT.ENABLED.get() == false);
                return couldMove;
            }
            if (couldMove && ((Boolean)InvMoveConfig.MOVEMENT.ENABLED.get()).booleanValue()) {
                InvMoveConfig.MOVEMENT.ENABLED.set(false);
                return false;
            }
            if (!couldMove && !((Boolean)InvMoveConfig.MOVEMENT.ENABLED.get()).booleanValue()) {
                InvMoveConfig.MOVEMENT.ENABLED.set(true);
                if (this.allowMovementInScreen(screen)) {
                    return true;
                }
                InvMoveConfig.MOVEMENT.ENABLED.set(false);
                return false;
            }
        }
        return couldMove;
    }

    public void onInputUpdate(Input input) {
        if (Minecraft.m_91087_().f_91074_ == null) {
            return;
        }
        if (Minecraft.m_91087_().f_91080_ == null) {
            this.wasSneaking = input.f_108573_;
        }
        boolean canMove = this.allowMovementInScreen(Minecraft.m_91087_().f_91080_);
        if (canMove = this.handleToggleMovementKey(Minecraft.m_91087_().f_91080_, canMove)) {
            for (KeyMapping k : KeyMapping.f_90809_.values()) {
                if (k.f_90816_.m_84868_() != InputConstants.Type.KEYSYM || k.f_90816_.m_84873_() == InputConstants.f_84822_.m_84873_()) continue;
                boolean raw = InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)k.f_90816_.m_84873_());
                if (k instanceof ToggleKeyMapping && ((ToggleKeyMapping)k).f_92527_.getAsBoolean()) {
                    if (this.wasToggleKeyDown.containsKey(k) && !this.wasToggleKeyDown.get(k).booleanValue() && raw) {
                        if (k == Minecraft.m_91087_().f_91066_.f_92090_) {
                            if (InvMoveConfig.MOVEMENT.SNEAK.get() == InvMoveConfig.Movement.SneakMode.Pressed) {
                                k.m_7249_(true);
                            }
                        } else {
                            k.m_7249_(true);
                        }
                    }
                    this.wasToggleKeyDown.put((ToggleKeyMapping)k, raw);
                    continue;
                }
                k.m_7249_(raw);
            }
            Minecraft.m_91087_().f_91066_.f_92094_.m_7249_(false);
            if (!this.optionToggleCrouch()) {
                if (Minecraft.m_91087_().f_91074_ != null && Minecraft.m_91087_().f_91074_.m_20159_()) {
                    Minecraft.m_91087_().f_91066_.f_92090_.m_7249_((Boolean)InvMoveConfig.MOVEMENT.DISMOUNT.get() != false && Minecraft.m_91087_().f_91066_.f_92090_.f_90817_);
                } else {
                    boolean sneakKey = false;
                    switch ((InvMoveConfig.Movement.SneakMode)((Object)InvMoveConfig.MOVEMENT.SNEAK.get())) {
                        case Off: {
                            break;
                        }
                        case Maintain: {
                            sneakKey = this.wasSneaking;
                            break;
                        }
                        case Pressed: {
                            sneakKey = this.wasSneaking = Minecraft.m_91087_().f_91066_.f_92090_.f_90817_;
                        }
                    }
                    Minecraft.m_91087_().f_91066_.f_92090_.m_7249_(sneakKey);
                }
            }
            this.manualTickMovement(input, Minecraft.m_91087_().f_91074_.m_108635_(), Minecraft.m_91087_().f_91074_.m_5833_());
        } else if (Minecraft.m_91087_().f_91080_ != null) {
            KeyMapping.m_90847_();
            if (!(!((Boolean)InvMoveConfig.GENERAL.ENABLED.get()).booleanValue() || this.optionToggleCrouch() || Minecraft.m_91087_().f_91074_ != null && Minecraft.m_91087_().f_91074_.m_20159_())) {
                boolean sneakKey = false;
                switch ((InvMoveConfig.Movement.SneakMode)((Object)InvMoveConfig.MOVEMENT.SNEAK.get())) {
                    case Off: {
                        break;
                    }
                    case Maintain: 
                    case Pressed: {
                        sneakKey = this.wasSneaking;
                    }
                }
                Minecraft.m_91087_().f_91066_.f_92090_.m_7249_(sneakKey);
                input.f_108573_ = sneakKey;
            }
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public boolean allowMovementInScreen(Screen screen) {
        void var2_8;
        if (screen == null) {
            return false;
        }
        if (Minecraft.m_91087_().f_91074_ == null) {
            return false;
        }
        if (!((Boolean)InvMoveConfig.GENERAL.ENABLED.get()).booleanValue()) {
            return false;
        }
        if (!((Boolean)InvMoveConfig.MOVEMENT.ENABLED.get()).booleanValue()) {
            return false;
        }
        if (screen.m_7043_() && Minecraft.m_91087_().m_91091_()) {
            if (Minecraft.m_91087_().m_91092_() == null) {
                return false;
            }
            if (!Minecraft.m_91087_().m_91092_().m_6992_()) {
                return false;
            }
        }
        Optional optional = Optional.empty();
        block7: for (Module mod : this.modules) {
            Module.Movement res = mod.shouldAllowMovement(screen);
            switch (res) {
                case PASS: {
                    break;
                }
                case FORCE_ENABLE: {
                    Optional<Boolean> optional2 = Optional.of(true);
                    break block7;
                }
                case FORCE_DISABLE: {
                    Optional<Boolean> optional3 = Optional.of(false);
                    break block7;
                }
                case SUGGEST_ENABLE: {
                    Optional<Boolean> optional4 = Optional.of(true);
                    break;
                }
                case SUGGEST_DISABLE: {
                    Optional<Boolean> optional5 = Optional.of(false);
                }
            }
        }
        if (var2_8.isPresent()) {
            return (Boolean)var2_8.get();
        }
        Class<?> cl = screen.getClass();
        String modid = this.modidFromClass(cl).orElse("?unknown");
        InvMoveConfig.MOVEMENT.unrecognizedScreensAllowMovement.putIfAbsent(modid, new HashMap());
        HashMap<Class<? extends Screen>, Boolean> hm = InvMoveConfig.MOVEMENT.unrecognizedScreensAllowMovement.get(modid);
        if (!hm.containsKey(cl)) {
            hm.put(cl, (Boolean)InvMoveConfig.MOVEMENT.UNRECOGNIZED_SCREEN_DEFAULT.get());
            InvMoveConfig.save();
        }
        return hm.get(cl);
    }

    public static Field[] getDeclaredFieldsSuper(Class<?> aClass) {
        ArrayList<Field> fs = new ArrayList<Field>();
        do {
            fs.addAll(Arrays.asList(aClass.getDeclaredFields()));
        } while ((aClass = aClass.getSuperclass()) != null);
        return fs.toArray(new Field[0]);
    }

    public void manualTickMovement(Input input, boolean slow, boolean noDampening) {
        input.f_108568_ = InvMove.rawIsKeyDown(Minecraft.m_91087_().f_91066_.f_92085_);
        input.f_108569_ = InvMove.rawIsKeyDown(Minecraft.m_91087_().f_91066_.f_92087_);
        input.f_108570_ = InvMove.rawIsKeyDown(Minecraft.m_91087_().f_91066_.f_92086_);
        input.f_108571_ = InvMove.rawIsKeyDown(Minecraft.m_91087_().f_91066_.f_92088_);
        float f = input.f_108568_ == input.f_108569_ ? 0.0f : (input.f_108567_ = (float)(input.f_108568_ ? 1 : -1));
        input.f_108566_ = input.f_108570_ == input.f_108571_ ? 0.0f : (float)(input.f_108570_ ? 1 : -1);
        input.f_108572_ = InvMove.rawIsKeyDown(Minecraft.m_91087_().f_91066_.f_92089_) && (Boolean)InvMoveConfig.MOVEMENT.JUMP.get() != false;
        input.f_108573_ = InvMove.rawIsKeyDown(Minecraft.m_91087_().f_91066_.f_92090_);
        if (!noDampening && (input.f_108573_ || slow)) {
            input.f_108566_ = (float)((double)input.f_108566_ * 0.3);
            input.f_108567_ = (float)((double)input.f_108567_ * 0.3);
        }
    }

    public static boolean rawIsKeyDown(KeyMapping key) {
        return key.f_90817_;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public boolean shouldDisableScreenBackground(Screen screen) {
        void var2_8;
        if (Minecraft.m_91087_().f_91074_ == null) {
            return false;
        }
        if (!((Boolean)InvMoveConfig.GENERAL.ENABLED.get()).booleanValue()) {
            return false;
        }
        if (!((Boolean)InvMoveConfig.BACKGROUND.BACKGROUND_HIDE.get()).booleanValue()) {
            return false;
        }
        if (screen == null) {
            return false;
        }
        if (screen.m_7043_()) {
            switch ((InvMoveConfig.Background.PauseScreenMode)((Object)InvMoveConfig.BACKGROUND.HIDE_ON_PAUSE.get())) {
                case Show: {
                    return false;
                }
                case AllowHide: {
                    break;
                }
                case ShowSP: {
                    if (!Minecraft.m_91087_().m_91091_()) break;
                    if (Minecraft.m_91087_().m_91092_() == null) return false;
                    if (Minecraft.m_91087_().m_91092_().m_6992_()) break;
                    return false;
                }
            }
        }
        Optional optional = Optional.empty();
        block12: for (Module mod : this.modules) {
            Module.Background res = mod.shouldHideBackground(screen);
            switch (res) {
                case PASS: {
                    break;
                }
                case FORCE_SHOW: {
                    Optional<Boolean> optional2 = Optional.of(true);
                    break block12;
                }
                case FORCE_HIDE: {
                    Optional<Boolean> optional3 = Optional.of(false);
                    break block12;
                }
                case SUGGEST_SHOW: {
                    Optional<Boolean> optional4 = Optional.of(true);
                    break;
                }
                case SUGGEST_HIDE: {
                    Optional<Boolean> optional5 = Optional.of(false);
                }
            }
        }
        if (!var2_8.isPresent()) {
            Class<?> cl = screen.getClass();
            String modid = this.modidFromClass(cl).orElse("?unknown");
            InvMoveConfig.BACKGROUND.unrecognizedScreensHideBG.putIfAbsent(modid, new HashMap());
            HashMap<Class<? extends Screen>, Boolean> hm = InvMoveConfig.BACKGROUND.unrecognizedScreensHideBG.get(modid);
            if (hm.containsKey(cl)) return hm.get(cl);
            hm.put(cl, (Boolean)InvMoveConfig.BACKGROUND.UNRECOGNIZED_SCREEN_DEFAULT.get());
            InvMoveConfig.save();
            return hm.get(cl);
        }
        if ((Boolean)var2_8.get() != false) return false;
        return true;
    }

    public void drawDebugOverlay() {
        if (((Boolean)InvMoveConfig.GENERAL.DEBUG_DISPLAY.get()).booleanValue()) {
            Screen screen = Minecraft.m_91087_().f_91080_;
            if (screen == null) {
                return;
            }
            int i = 0;
            Class<?> cl = screen.getClass();
            while (cl.getSuperclass() != null) {
                Optional<String> modid;
                Object className = cl.getName();
                if (((String)className).startsWith("net.minecraft.")) {
                    className = ((String)className).substring("net.minecraft.".length());
                }
                if ((modid = this.modidFromClass(cl)).isPresent()) {
                    className = "[" + modid.get() + "] " + (String)className;
                }
                if (this.shouldDisableScreenBackground(screen)) {
                    className = "B" + (String)className;
                }
                if (this.allowMovementInScreen(screen)) {
                    className = "M" + (String)className;
                }
                Minecraft.m_91087_().f_91062_.m_92750_(new PoseStack(), (String)className, 4.0f, (float)(4 + 10 * i), -1);
                ++i;
                cl = cl.getSuperclass();
            }
        }
    }

    static {
        TOGGLE_MOVEMENT_KEY = new KeyMapping("keybind.invmove.toggleMove", InputConstants.Type.KEYSYM, InputConstants.f_84822_.m_84873_(), "keycategory.invmove");
        addonModules = new ArrayList<Module>();
    }
}

