/*
 * Decompiled with CFR 0.152.
 */
package nl.enjarai.doabarrelroll.util;

public class Vec2d {
    public static final Vec2d ZERO = new Vec2d(0.0, 0.0);
    public final double x;
    public final double y;

    public Vec2d(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public Vec2d add(Vec2d other) {
        return new Vec2d(this.x + other.x, this.y + other.y);
    }

    public Vec2d subtract(Vec2d other) {
        return new Vec2d(this.x - other.x, this.y - other.y);
    }

    public Vec2d multiply(double scalar) {
        return new Vec2d(this.x * scalar, this.y * scalar);
    }

    public Vec2d divide(double scalar) {
        return new Vec2d(this.x / scalar, this.y / scalar);
    }

    public double dotProduct(Vec2d other) {
        return this.x * other.x + this.y * other.y;
    }

    public double crossProduct(Vec2d other) {
        return this.x * other.y - this.y * other.x;
    }

    public double length() {
        return Math.sqrt(this.lengthSquared());
    }

    public double lengthSquared() {
        return this.x * this.x + this.y * this.y;
    }

    public Vec2d negate() {
        return new Vec2d(-this.x, -this.y);
    }

    public Vec2d normalize() {
        return this.divide(this.length());
    }

    public Vec2d lerp(Vec2d other, double t) {
        return new Vec2d(this.x + (other.x - this.x) * t, this.y + (other.y - this.y) * t);
    }
}

