/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.saveandloadinventories_common_fabric.cmds;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.natamus.collective_common_fabric.functions.PlayerFunctions;
import com.natamus.collective_common_fabric.functions.StringFunctions;
import com.natamus.saveandloadinventories_common_fabric.util.Util;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_3222;

public class CommandLoadinventory {
    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"loadinventory").requires(iCommandSender -> iCommandSender.method_9259(2))).then(class_2170.method_9244((String)"inventory-name", (ArgumentType)StringArgumentType.word()).executes(command -> CommandLoadinventory.loadInventory((CommandContext<class_2168>)command)))).then(class_2170.method_9244((String)"inventory-name", (ArgumentType)StringArgumentType.word()).then(class_2170.method_9244((String)"player-name", (ArgumentType)StringArgumentType.word()).executes(command -> CommandLoadinventory.loadInventoryForPlayerName((CommandContext<class_2168>)command)))));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"li").requires(iCommandSender -> iCommandSender.method_9259(2))).then(class_2170.method_9244((String)"inventory-name", (ArgumentType)StringArgumentType.word()).executes(command -> CommandLoadinventory.loadInventory((CommandContext<class_2168>)command)))).then(class_2170.method_9244((String)"inventory-name", (ArgumentType)StringArgumentType.word()).then(class_2170.method_9244((String)"player-name", (ArgumentType)StringArgumentType.word()).executes(command -> CommandLoadinventory.loadInventoryForPlayerName((CommandContext<class_2168>)command)))));
    }

    private static int loadInventory(CommandContext<class_2168> command) {
        class_3222 player;
        class_2168 source = (class_2168)command.getSource();
        try {
            player = source.method_9207();
        }
        catch (CommandSyntaxException ex) {
            StringFunctions.sendMessage((class_2168)source, (String)"This command can only be executed as a player in-game.", (class_124)class_124.field_1061);
            return 1;
        }
        String inventoryname = StringArgumentType.getString(command, (String)"inventory-name").toLowerCase();
        if (inventoryname.trim() == "") {
            StringFunctions.sendMessage((class_2168)source, (String)("The inventory name '" + inventoryname + "' is invalid."), (class_124)class_124.field_1061);
            return 0;
        }
        String gearstring = Util.getGearStringFromFile(inventoryname);
        if (gearstring == "") {
            StringFunctions.sendMessage((class_2168)source, (String)("Unable to load the content of the inventory with the name '" + inventoryname + "'."), (class_124)class_124.field_1061);
            return 0;
        }
        PlayerFunctions.setPlayerGearFromString((class_1657)player, (String)gearstring);
        StringFunctions.sendMessage((class_2168)source, (String)("Successfully loaded '" + inventoryname + "' to your inventory."), (class_124)class_124.field_1077);
        return 1;
    }

    private static int loadInventoryForPlayerName(CommandContext<class_2168> command) {
        class_3222 player;
        class_2168 source = (class_2168)command.getSource();
        try {
            player = source.method_9207();
        }
        catch (CommandSyntaxException ex) {
            StringFunctions.sendMessage((class_2168)source, (String)"This command can only be executed as a player in-game.", (class_124)class_124.field_1061);
            return 1;
        }
        String inventoryname = StringArgumentType.getString(command, (String)"inventory-name").toLowerCase();
        if (inventoryname.trim() == "") {
            StringFunctions.sendMessage((class_2168)source, (String)("The inventory name '" + inventoryname + "' is invalid."), (class_124)class_124.field_1061);
            return 0;
        }
        String targetname = StringArgumentType.getString(command, (String)"player-name").toLowerCase();
        class_1657 target = PlayerFunctions.matchPlayer((class_1657)player, (String)targetname.toLowerCase());
        if (target == null) {
            StringFunctions.sendMessage((class_2168)source, (String)("Unable to find an online player with the name '" + targetname + "'."), (class_124)class_124.field_1061);
            return 0;
        }
        String gearstring = Util.getGearStringFromFile(inventoryname);
        if (gearstring == "") {
            StringFunctions.sendMessage((class_2168)source, (String)("Unable to load the content of the inventory with the name '" + inventoryname + "'."), (class_124)class_124.field_1061);
            return 0;
        }
        PlayerFunctions.setPlayerGearFromString((class_1657)target, (String)gearstring);
        StringFunctions.sendMessage((class_2168)source, (String)("Successfully loaded '" + inventoryname + "' to the inventory of '" + target.method_5477().getString() + "'."), (class_124)class_124.field_1077);
        StringFunctions.sendMessage((class_1657)target, (String)("Your inventory has been replaced with the preset named '" + inventoryname + "'."), (class_124)class_124.field_1077);
        return 1;
    }
}

