/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.goblintraders.entity;

import com.mrcrayfish.goblintraders.Config;
import com.mrcrayfish.goblintraders.entity.AbstractGoblinEntity;
import com.mrcrayfish.goblintraders.entity.TraderCreatureEntity;
import com.mrcrayfish.goblintraders.init.ModEntities;
import com.mrcrayfish.goblintraders.trades.EntityTrades;
import com.mrcrayfish.goblintraders.trades.IRaritySettings;
import com.mrcrayfish.goblintraders.trades.TradeManager;
import com.mrcrayfish.goblintraders.trades.TradeRarity;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.trading.MerchantOffers;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class GoblinTraderEntity
extends AbstractGoblinEntity {
    public GoblinTraderEntity(Level level) {
        super((EntityType<? extends TraderCreatureEntity>)((EntityType)ModEntities.GOBLIN_TRADER.get()), level);
    }

    @Override
    public ResourceLocation getTexture() {
        return new ResourceLocation("goblintraders", "textures/entity/goblin_trader.png");
    }

    @Override
    protected void populateTradeData() {
        MerchantOffers offers = this.m_6616_();
        EntityTrades entityTrades = TradeManager.instance().getTrades((EntityType<? extends TraderCreatureEntity>)((EntityType)ModEntities.GOBLIN_TRADER.get()));
        if (entityTrades != null) {
            Map<TradeRarity, List<VillagerTrades.ItemListing>> tradeMap = entityTrades.getTradeMap();
            for (TradeRarity rarity : TradeRarity.values()) {
                IRaritySettings settings = Config.COMMON.goblinTrader.trades.getSettings(rarity);
                if (settings.includeChance() <= 0.0 || settings.includeChance() < 1.0 && this.m_217043_().m_188500_() > settings.includeChance()) continue;
                List<VillagerTrades.ItemListing> trades = tradeMap.get((Object)rarity);
                int min = Math.min(settings.getMinValue(), settings.getMaxValue());
                int max = Math.max(settings.getMinValue(), settings.getMaxValue());
                int count = min + this.m_217043_().m_188503_(max - min + 1);
                this.addTrades(offers, trades, count, rarity.shouldShuffle());
            }
        }
    }

    @Override
    public ItemStack getFavouriteFood() {
        return new ItemStack((ItemLike)Items.f_42410_);
    }

    @Override
    protected int getMaxRestockDelay() {
        return (Integer)Config.COMMON.goblinTrader.restockDelay.get();
    }

    @Override
    public boolean canAttackBack() {
        return (Boolean)Config.COMMON.goblinTrader.canAttackBack.get();
    }

    public int m_8100_() {
        return (Integer)Config.COMMON.goblinTrader.gruntNoiseInterval.get();
    }
}

