/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.goblintraders.world.spawner;

import com.mrcrayfish.goblintraders.Config;
import com.mrcrayfish.goblintraders.entity.AbstractGoblinEntity;
import com.mrcrayfish.goblintraders.world.spawner.GoblinData;
import com.mrcrayfish.goblintraders.world.spawner.GoblinTraderData;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.NaturalSpawner;
import net.minecraft.world.level.biome.Biomes;

public class GoblinTraderSpawner {
    private final GoblinData data;
    private final EntityType<? extends AbstractGoblinEntity> entityType;
    private int delayBeforeSpawnLogic;
    private final int traderSpawnDelay;
    private final int traderSpawnChance;
    private int currentTraderSpawnDelay;
    private int currentTraderSpawnChance;
    private int minLevel;
    private int maxLevel;

    public GoblinTraderSpawner(MinecraftServer server, String key, EntityType<? extends AbstractGoblinEntity> entityType, Config.Common.Goblin goblin) {
        this.data = GoblinTraderData.get(server).getGoblinData(key);
        this.entityType = entityType;
        this.delayBeforeSpawnLogic = 600;
        this.currentTraderSpawnDelay = this.data.getGoblinTraderSpawnDelay();
        this.currentTraderSpawnChance = this.data.getGoblinTraderSpawnChance();
        this.traderSpawnDelay = (Integer)goblin.traderSpawnDelay.get();
        this.traderSpawnChance = (Integer)goblin.traderSpawnChance.get();
        this.minLevel = Math.min((Integer)goblin.traderMinSpawnLevel.get(), (Integer)goblin.traderMaxSpawnLevel.get());
        this.maxLevel = Math.max((Integer)goblin.traderMinSpawnLevel.get(), (Integer)goblin.traderMaxSpawnLevel.get());
        if (this.currentTraderSpawnDelay == 0 && this.currentTraderSpawnChance == 0) {
            this.currentTraderSpawnDelay = this.traderSpawnDelay;
            this.currentTraderSpawnChance = this.traderSpawnChance;
            this.data.setGoblinTraderSpawnDelay(this.currentTraderSpawnDelay);
            this.data.setGoblinTraderSpawnChance(this.currentTraderSpawnChance);
        }
    }

    public int tick(Level level) {
        if (level.m_46469_().m_46207_(GameRules.f_46125_) && --this.delayBeforeSpawnLogic <= 0) {
            int delay;
            this.delayBeforeSpawnLogic = delay = Math.max(this.traderSpawnDelay / 20, 1);
            this.currentTraderSpawnDelay -= delay;
            this.data.setGoblinTraderSpawnDelay(this.currentTraderSpawnDelay);
            if (this.currentTraderSpawnDelay <= 0) {
                this.currentTraderSpawnDelay = this.traderSpawnDelay;
                if (level.m_46469_().m_46207_(GameRules.f_46134_)) {
                    int spawnChance = this.currentTraderSpawnChance;
                    this.currentTraderSpawnChance = Mth.m_14045_((int)(this.currentTraderSpawnChance + this.traderSpawnChance), (int)this.traderSpawnChance, (int)100);
                    this.data.setGoblinTraderSpawnChance(this.currentTraderSpawnChance);
                    if (level.m_213780_().m_188503_(100) <= spawnChance && this.spawnTrader(level)) {
                        this.currentTraderSpawnChance = this.traderSpawnChance;
                    }
                }
            }
        }
        return 0;
    }

    private boolean spawnTrader(Level level) {
        List players = level.m_6907_();
        if (players.isEmpty()) {
            return false;
        }
        Player randomPlayer = (Player)players.get(level.m_213780_().m_188503_(players.size()));
        if (randomPlayer == null) {
            return true;
        }
        BlockPos blockpos = randomPlayer.m_20097_();
        BlockPos safestPos = this.getSafePositionAroundPlayer(randomPlayer.f_19853_, blockpos, 10);
        if (safestPos != null && this.isEmptyCollision(randomPlayer.f_19853_, safestPos)) {
            if (level.m_204166_(safestPos).m_203565_(Biomes.f_48173_)) {
                return false;
            }
            if (safestPos.m_123342_() < this.minLevel || safestPos.m_123342_() >= this.maxLevel) {
                return false;
            }
            AbstractGoblinEntity goblin = (AbstractGoblinEntity)this.entityType.m_20600_((ServerLevel)randomPlayer.f_19853_, null, null, null, safestPos, MobSpawnType.EVENT, false, false);
            if (goblin != null) {
                goblin.setDespawnDelay(this.traderSpawnDelay);
                goblin.m_21446_(safestPos, 16);
                return true;
            }
        }
        return false;
    }

    @Nullable
    private BlockPos getSafePositionAroundPlayer(Level level, BlockPos pos, int range) {
        if (range == 0) {
            return null;
        }
        BlockPos safestPos = null;
        for (int attempts = 0; attempts < 50; ++attempts) {
            int posZ;
            int posY;
            int posX = pos.m_123341_() + level.m_213780_().m_188503_(range * 2) - range;
            BlockPos testPos = this.findGround(level, new BlockPos(posX, posY = pos.m_123342_() + level.m_213780_().m_188503_(range) - range / 2, posZ = pos.m_123343_() + level.m_213780_().m_188503_(range * 2) - range), range);
            if (testPos == null || !NaturalSpawner.m_47051_((SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (LevelReader)level, (BlockPos)testPos, this.entityType)) continue;
            safestPos = testPos;
            break;
        }
        return safestPos != null ? safestPos : this.getSafePositionAroundPlayer(level, pos, range / 2);
    }

    @Nullable
    private BlockPos findGround(Level level, BlockPos pos, int maxDistance) {
        if (level.m_8055_(pos).m_60795_()) {
            BlockPos downPos = pos;
            while (Level.m_46741_((BlockPos)downPos.m_7495_()) && level.m_8055_(downPos.m_7495_()).m_60795_() && downPos.m_7495_().m_123314_((Vec3i)pos, (double)maxDistance)) {
                downPos = downPos.m_7495_();
            }
            if (!level.m_8055_(downPos.m_7495_()).m_60795_()) {
                return downPos;
            }
        } else {
            BlockPos upPos = pos;
            while (Level.m_46741_((BlockPos)upPos.m_7494_()) && !level.m_8055_(upPos.m_7494_()).m_60795_() && upPos.m_7494_().m_123314_((Vec3i)pos, (double)maxDistance)) {
                upPos = upPos.m_7494_();
            }
            if (!level.m_8055_(upPos.m_7495_()).m_60795_()) {
                return upPos;
            }
        }
        return null;
    }

    private boolean isEmptyCollision(Level level, BlockPos pos) {
        return level.m_8055_(pos).m_60812_((BlockGetter)level, pos).m_83281_();
    }
}

