/*
 * Decompiled with CFR 0.152.
 */
package subaraki.paintings.mod;

import net.minecraft.ResourceLocationException;
import net.minecraft.core.Registry;
import net.minecraft.world.entity.decoration.PaintingVariant;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.RegisterEvent;
import subaraki.paintings.mod.ConfigData;
import subaraki.paintings.network.NetworkHandler;
import subaraki.paintings.utils.PaintingEntry;
import subaraki.paintings.utils.PaintingPackReader;

@Mod(value="paintings")
@Mod.EventBusSubscriber(modid="paintings", bus=Mod.EventBusSubscriber.Bus.MOD)
public class Paintings {
    public Paintings() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::commonSetup);
        ModLoadingContext modLoadingContext = ModLoadingContext.get();
        modLoadingContext.registerConfig(ModConfig.Type.SERVER, (IConfigSpec)ConfigData.SERVER_SPEC);
        modLoadingContext.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)ConfigData.CLIENT_SPEC);
    }

    @SubscribeEvent
    public static void registerPaintigns(RegisterEvent event) {
        event.register(Registry.f_235743_, registry -> {
            for (PaintingEntry entry : PaintingPackReader.PAINTINGS) {
                try {
                    registry.register(entry.getResLoc(), (Object)new PaintingVariant(entry.getSizeX(), entry.getSizeY()));
                    subaraki.paintings.Paintings.LOGGER.info("Registered variant " + entry.getPaintingName());
                }
                catch (ResourceLocationException e) {
                    subaraki.paintings.Paintings.LOGGER.error("Skipping. Found Error: {}", (Object)e.getMessage());
                }
            }
        });
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        new NetworkHandler();
    }

    static {
        new PaintingPackReader().init();
    }
}

