/*
 * Decompiled with CFR 0.152.
 */
package com.lilypuree.connectiblechains.chain;

import com.lilypuree.connectiblechains.ConnectibleChains;
import com.lilypuree.connectiblechains.chain.ChainType;
import com.lilypuree.connectiblechains.chain.ChainTypesRegistry;
import com.lilypuree.connectiblechains.entity.ChainCollisionEntity;
import com.lilypuree.connectiblechains.entity.ChainKnotEntity;
import com.lilypuree.connectiblechains.entity.ModEntityTypes;
import com.lilypuree.connectiblechains.network.ModPacketHandler;
import com.lilypuree.connectiblechains.network.S2CChainAttachPacket;
import com.lilypuree.connectiblechains.network.S2CChainDetachPacket;
import com.lilypuree.connectiblechains.util.Helper;
import com.mojang.math.Vector3f;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChainLink {
    private static final float COLLIDER_SPACING = 1.5f;
    @NotNull
    public final ChainKnotEntity primary;
    @NotNull
    public final Entity secondary;
    @NotNull
    public final ChainType chainType;
    private final IntList collisionStorage = new IntArrayList(16);
    public boolean removeSilently = false;
    private boolean alive = true;

    private ChainLink(@NotNull ChainKnotEntity primary, @NotNull Entity secondary, @NotNull ChainType chainType) {
        if (primary.equals(secondary)) {
            throw new IllegalStateException("Tried to create a link between a knot and itself");
        }
        this.primary = Objects.requireNonNull(primary);
        this.secondary = Objects.requireNonNull(secondary);
        this.chainType = Objects.requireNonNull(chainType);
    }

    @Nullable
    public static ChainLink create(@NotNull ChainKnotEntity primary, @NotNull Entity secondary, @NotNull ChainType chainType) {
        ChainLink link = new ChainLink(primary, secondary, chainType);
        if (primary.getLinks().contains(link)) {
            return null;
        }
        primary.addLink(link);
        if (secondary instanceof ChainKnotEntity) {
            ChainKnotEntity secondaryKnot = (ChainKnotEntity)secondary;
            secondaryKnot.addLink(link);
            link.createCollision();
        }
        if (!primary.f_19853_.f_46443_) {
            link.sendAttachChainPacket(primary.f_19853_);
        }
        return link;
    }

    private void createCollision() {
        double step;
        if (!this.collisionStorage.isEmpty()) {
            return;
        }
        if (this.primary.f_19853_.f_46443_) {
            return;
        }
        double distance = this.primary.m_20270_(this.secondary);
        double centerHoldout = (double)((EntityType)ModEntityTypes.CHAIN_COLLISION.get()).m_20678_() / distance;
        for (double v = step = 1.5 * Math.sqrt(Math.pow(((EntityType)ModEntityTypes.CHAIN_COLLISION.get()).m_20678_(), 2.0) * 2.0) / distance; v < 0.5 - centerHoldout; v += step) {
            Entity collider2;
            Entity collider1 = this.spawnCollision(false, (Entity)this.primary, this.secondary, v);
            if (collider1 != null) {
                this.collisionStorage.add(collider1.m_19879_());
            }
            if ((collider2 = this.spawnCollision(true, (Entity)this.primary, this.secondary, v)) == null) continue;
            this.collisionStorage.add(collider2.m_19879_());
        }
        Entity centerCollider = this.spawnCollision(false, (Entity)this.primary, this.secondary, 0.5);
        if (centerCollider != null) {
            this.collisionStorage.add(centerCollider.m_19879_());
        }
    }

    private void sendAttachChainPacket(Level world) {
        assert (world instanceof ServerLevel);
        Set<ServerPlayer> trackingPlayers = this.getTrackingPlayers(world);
        S2CChainAttachPacket packet = new S2CChainAttachPacket(this.primary.m_19879_(), this.secondary.m_19879_(), ChainTypesRegistry.getKey(this.chainType));
        for (ServerPlayer player : trackingPlayers) {
            ModPacketHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), (Object)packet);
        }
    }

    @Nullable
    private Entity spawnCollision(boolean reverse, Entity start, Entity end, double v) {
        Vec3 endPos;
        assert (this.primary.f_19853_ instanceof ServerLevel);
        Vec3 startPos = start.m_20182_().m_82549_(start.m_7939_());
        Vec3 tmp = endPos = end.m_20182_().m_82549_(end.m_7939_());
        if (reverse) {
            endPos = startPos;
            startPos = tmp;
        }
        Vector3f offset = Helper.getChainOffset(startPos, endPos);
        startPos = startPos.m_82520_((double)offset.m_122239_(), 0.0, (double)offset.m_122269_());
        endPos = endPos.m_82520_((double)(-offset.m_122239_()), 0.0, (double)(-offset.m_122269_()));
        double distance = startPos.m_82554_(endPos);
        double x = Mth.m_14139_((double)v, (double)startPos.m_7096_(), (double)endPos.m_7096_());
        double y = startPos.m_7098_() + Helper.drip2(v * distance, distance, endPos.m_7098_() - startPos.m_7098_());
        double z = Mth.m_14139_((double)v, (double)startPos.m_7094_(), (double)endPos.m_7094_());
        ChainCollisionEntity c = new ChainCollisionEntity(this.primary.f_19853_, x, y += (double)(-((EntityType)ModEntityTypes.CHAIN_COLLISION.get()).m_20679_() + 0.125f), z, this);
        if (this.primary.f_19853_.m_7967_((Entity)c)) {
            return c;
        }
        ConnectibleChains.LOGGER.warn("Tried to summon collision entity for a chain, failed to do so");
        return null;
    }

    private Set<ServerPlayer> getTrackingPlayers(Level world) {
        assert (world instanceof ServerLevel);
        HashSet<ServerPlayer> trackingPlayers = new HashSet<ServerPlayer>(this.around((ServerLevel)world, (Vec3i)this.primary.m_20183_(), 2048.0));
        trackingPlayers.addAll(this.around((ServerLevel)world, (Vec3i)this.secondary.m_20183_(), 2048.0));
        return trackingPlayers;
    }

    private Collection<ServerPlayer> around(ServerLevel level, Vec3i pos, double radius) {
        double radiusSq = radius * radius;
        Objects.requireNonNull(level, "The world cannot be null");
        return level.m_6907_().stream().filter(p -> p.m_20275_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_()) <= radiusSq).collect(Collectors.toList());
    }

    public boolean isDead() {
        return !this.alive;
    }

    public double getSquaredDistance() {
        return this.primary.m_20280_(this.secondary);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChainLink link = (ChainLink)o;
        boolean partnersEqual = this.primary.equals(link.primary) && this.secondary.equals((Object)link.secondary) || this.primary.equals(link.secondary) && this.secondary.equals((Object)link.primary);
        return this.alive == link.alive && partnersEqual;
    }

    public int hashCode() {
        return Objects.hash(this.primary, this.secondary, this.alive);
    }

    public boolean needsBeDestroyed() {
        return this.primary.m_213877_() || this.secondary.m_213877_();
    }

    public void destroy(boolean mayDrop) {
        Player player;
        if (!this.alive) {
            return;
        }
        boolean drop = mayDrop;
        Level world = this.primary.f_19853_;
        this.alive = false;
        if (world.f_46443_) {
            return;
        }
        Entity entity = this.secondary;
        if (entity instanceof Player && (player = (Player)entity).m_7500_()) {
            drop = false;
        }
        if (!world.m_46469_().m_46207_(GameRules.f_46136_)) {
            drop = false;
        }
        if (drop) {
            ItemStack stack = new ItemStack((ItemLike)this.chainType.item());
            Entity entity2 = this.secondary;
            if (entity2 instanceof Player) {
                Player player2 = (Player)entity2;
                player2.m_36356_(stack);
            } else {
                Vec3 middle = Helper.middleOf(this.primary.m_20182_(), this.secondary.m_20182_());
                ItemEntity itemEntity = new ItemEntity(world, middle.f_82479_, middle.f_82480_, middle.f_82481_, stack);
                itemEntity.m_32060_();
                world.m_7967_((Entity)itemEntity);
            }
        }
        this.destroyCollision();
        if (!this.primary.m_213877_() && !this.secondary.m_213877_()) {
            this.sendDetachChainPacket(world);
        }
    }

    private void destroyCollision() {
        for (Integer entityId : this.collisionStorage) {
            Entity e = this.primary.f_19853_.m_6815_(entityId.intValue());
            if (e instanceof ChainCollisionEntity) {
                e.m_142687_(Entity.RemovalReason.DISCARDED);
                continue;
            }
            ConnectibleChains.LOGGER.warn("Collision storage contained reference to {} (#{}) which is not a collision entity.", (Object)e, (Object)entityId);
        }
        this.collisionStorage.clear();
    }

    private void sendDetachChainPacket(Level world) {
        assert (world instanceof ServerLevel);
        Set<ServerPlayer> trackingPlayers = this.getTrackingPlayers(world);
        S2CChainDetachPacket packet = new S2CChainDetachPacket(this.primary.m_19879_(), this.secondary.m_19879_());
        for (ServerPlayer player : trackingPlayers) {
            ModPacketHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), (Object)packet);
        }
    }
}

