/*
 * Decompiled with CFR 0.152.
 */
package com.lilypuree.connectiblechains.client.render.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix3f;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.util.Mth;

public record ChainModel(float[] vertices, float[] uvs) {
    public static Builder builder(int initialCapacity) {
        return new Builder(initialCapacity);
    }

    public void render(VertexConsumer buffer, PoseStack matrices, int bLight0, int bLight1, int sLight0, int sLight1) {
        Matrix4f modelMatrix = matrices.m_85850_().m_85861_();
        Matrix3f normalMatrix = matrices.m_85850_().m_85864_();
        int count = this.vertices.length / 3;
        for (int i = 0; i < count; ++i) {
            float f = (float)(i % (count / 2)) / (float)(count / 2);
            int blockLight = (int)Mth.m_14179_((float)f, (float)bLight0, (float)bLight1);
            int skyLight = (int)Mth.m_14179_((float)f, (float)sLight0, (float)sLight1);
            int light = LightTexture.m_109885_((int)blockLight, (int)skyLight);
            buffer.m_85982_(modelMatrix, this.vertices[i * 3], this.vertices[i * 3 + 1], this.vertices[i * 3 + 2]).m_6122_(255, 255, 255, 255).m_7421_(this.uvs[i * 2], this.uvs[i * 2 + 1]).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_85977_(normalMatrix, 0.0f, 0.35f, 0.0f).m_5752_();
        }
    }

    public static class Builder {
        private final List<Float> vertices;
        private final List<Float> uvs;
        private int size;

        public Builder(int initialCapacity) {
            this.vertices = new ArrayList<Float>(initialCapacity * 3);
            this.uvs = new ArrayList<Float>(initialCapacity * 2);
        }

        public Builder vertex(Vector3f v) {
            this.vertices.add(Float.valueOf(v.m_122239_()));
            this.vertices.add(Float.valueOf(v.m_122260_()));
            this.vertices.add(Float.valueOf(v.m_122269_()));
            return this;
        }

        public Builder uv(float u, float v) {
            this.uvs.add(Float.valueOf(u));
            this.uvs.add(Float.valueOf(v));
            return this;
        }

        public void next() {
            ++this.size;
        }

        public ChainModel build() {
            if (this.vertices.size() != this.size * 3) {
                throw new AssertionError((Object)"Wrong count of vertices");
            }
            if (this.uvs.size() != this.size * 2) {
                throw new AssertionError((Object)"Wrong count of uvs");
            }
            return new ChainModel(this.toFloatArray(this.vertices), this.toFloatArray(this.uvs));
        }

        private float[] toFloatArray(List<Float> floats) {
            float[] array = new float[floats.size()];
            int i = 0;
            for (float f : floats) {
                array[i++] = f;
            }
            return array;
        }
    }
}

