/*
 * Decompiled with CFR 0.152.
 */
package com.lilypuree.connectiblechains.entity;

import com.lilypuree.connectiblechains.ConnectibleChains;
import com.lilypuree.connectiblechains.chain.ChainLink;
import com.lilypuree.connectiblechains.chain.ChainType;
import com.lilypuree.connectiblechains.chain.ChainTypesRegistry;
import com.lilypuree.connectiblechains.datafixer.ChainKnotFixer;
import com.lilypuree.connectiblechains.entity.ChainLinkEntity;
import com.lilypuree.connectiblechains.entity.ModEntityTypes;
import com.lilypuree.connectiblechains.network.ModPacketHandler;
import com.lilypuree.connectiblechains.network.S2CKnotChangeTypePacket;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.decoration.HangingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.entity.IEntityAdditionalSpawnData;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.Nullable;

public class ChainKnotEntity
extends HangingEntity
implements IEntityAdditionalSpawnData,
ChainLinkEntity {
    public static final double VISIBLE_RANGE = 2048.0;
    private static final byte GRACE_PERIOD = 100;
    public final ObjectList<ChainLink> links = new ObjectArrayList();
    private final ObjectList<Tag> incompleteLinks = new ObjectArrayList();
    private int obstructionCheckTimer = 0;
    private ChainType chainType = ChainTypesRegistry.DEFAULT_CHAIN_TYPE.get();
    private byte graceTicks = (byte)100;
    private BlockState attachTarget;

    protected ChainKnotEntity(EntityType<? extends HangingEntity> entityType, Level level) {
        super(entityType, level);
    }

    public ChainKnotEntity(Level world, BlockPos pos, ChainType chainType) {
        super((EntityType)ModEntityTypes.CHAIN_KNOT.get(), world, pos);
        this.m_6034_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5);
        this.chainType = chainType;
    }

    public void m_6034_(double x, double y, double z) {
        super.m_6034_((double)Mth.m_14107_((double)x) + 0.5, (double)Mth.m_14107_((double)y) + 0.5, (double)Mth.m_14107_((double)z) + 0.5);
    }

    public ChainType getChainType() {
        return this.chainType;
    }

    public void setChainType(ChainType chainType) {
        this.chainType = chainType;
    }

    public void setGraceTicks(byte graceTicks) {
        this.graceTicks = graceTicks;
    }

    protected void m_6022_(Direction pFacingDirection) {
    }

    protected void m_7087_() {
        this.m_20343_((double)this.f_31698_.m_123341_() + 0.5, (double)this.f_31698_.m_123342_() + 0.5, (double)this.f_31698_.m_123343_() + 0.5);
        double w = (double)this.m_6095_().m_20678_() / 2.0;
        double h = this.m_6095_().m_20679_();
        this.m_20011_(new AABB(this.m_20185_() - w, this.m_20186_(), this.m_20189_() - w, this.m_20185_() + w, this.m_20186_() + h, this.m_20189_() + w));
    }

    public void m_8119_() {
        if (this.f_19853_.f_46443_) {
            this.links.removeIf(ChainLink::isDead);
            this.attachTarget = this.f_19853_.m_8055_(this.f_31698_);
            return;
        }
        this.m_146871_();
        boolean anyConverted = this.convertIncompleteLinks();
        this.updateLinks();
        this.removeDeadLinks();
        if (this.graceTicks < 0 || anyConverted && this.incompleteLinks.isEmpty()) {
            this.graceTicks = 0;
        } else if (this.graceTicks > 0) {
            this.graceTicks = (byte)(this.graceTicks - 1);
        }
    }

    private boolean convertIncompleteLinks() {
        if (!this.incompleteLinks.isEmpty()) {
            return this.incompleteLinks.removeIf(this::deserializeChainTag);
        }
        return false;
    }

    private void updateLinks() {
        double squaredMaxRange = ChainKnotEntity.getMaxRange() * ChainKnotEntity.getMaxRange();
        for (ChainLink link : this.links) {
            if (link.isDead()) continue;
            if (!this.m_6084_()) {
                link.destroy(true);
                continue;
            }
            if (link.primary != this || !(link.getSquaredDistance() > squaredMaxRange)) continue;
            link.destroy(true);
        }
        if (this.obstructionCheckTimer++ == 100) {
            this.obstructionCheckTimer = 0;
            if (!this.canStayAttached()) {
                this.destroyLinks(true);
            }
        }
    }

    private void removeDeadLinks() {
        boolean playBreakSound = false;
        for (ChainLink link : this.links) {
            if (link.needsBeDestroyed()) {
                link.destroy(true);
            }
            if (!link.isDead() || link.removeSilently) continue;
            playBreakSound = true;
        }
        if (playBreakSound) {
            this.m_5553_(null);
        }
        this.links.removeIf(ChainLink::isDead);
        if (this.links.isEmpty() && this.incompleteLinks.isEmpty() && this.graceTicks <= 0) {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
    }

    private boolean deserializeChainTag(Tag element) {
        if (element == null || this.f_19853_.f_46443_) {
            return true;
        }
        assert (element instanceof CompoundTag);
        CompoundTag tag = (CompoundTag)element;
        ChainType chainType = ChainTypesRegistry.getValue(tag.m_128461_("ChainType"));
        if (tag.m_128441_("UUID")) {
            UUID uuid = tag.m_128342_("UUID");
            Entity entity = ((ServerLevel)this.f_19853_).m_8791_(uuid);
            if (entity != null) {
                ChainLink.create(this, entity, chainType);
                return true;
            }
        } else if (tag.m_128441_("RelX") || tag.m_128441_("RelY") || tag.m_128441_("RelZ")) {
            BlockPos blockPos = new BlockPos(tag.m_128451_("RelX"), tag.m_128451_("RelY"), tag.m_128451_("RelZ"));
            ChainKnotEntity entity = ChainKnotEntity.getKnotAt(this.f_19853_, (blockPos = this.getBlockPosAsFacingRelative(blockPos, Direction.m_122364_((double)this.m_146908_()))).m_121955_((Vec3i)this.f_31698_));
            if (entity != null) {
                ChainLink.create(this, (Entity)entity, chainType);
                return true;
            }
        } else {
            ConnectibleChains.LOGGER.warn("Chain knot NBT is missing UUID or relative position.");
        }
        if (this.graceTicks <= 0) {
            this.m_19998_((ItemLike)chainType.item());
            this.m_5553_(null);
            return true;
        }
        return false;
    }

    public static double getMaxRange() {
        return ConnectibleChains.runtimeConfig.getMaxChainRange();
    }

    public boolean canStayAttached() {
        BlockState block = this.f_19853_.m_8055_(this.f_31698_);
        return ChainKnotEntity.canAttachTo(block);
    }

    @Override
    public void destroyLinks(boolean mayDrop) {
        for (ChainLink link : this.links) {
            link.destroy(mayDrop);
        }
        this.graceTicks = 0;
    }

    public void m_5553_(Entity entity) {
        this.m_5496_(SoundEvents.f_11794_, 1.0f, 1.0f);
    }

    private BlockPos getBlockPosAsFacingRelative(BlockPos relPos, Direction facing) {
        Rotation rotation = Rotation.values()[facing.m_122416_()];
        return relPos.m_7954_(rotation);
    }

    @Nullable
    public static ChainKnotEntity getKnotAt(Level world, BlockPos pos) {
        List results = world.m_45976_(ChainKnotEntity.class, AABB.m_165882_((Vec3)Vec3.m_82528_((Vec3i)pos), (double)2.0, (double)2.0, (double)2.0));
        for (ChainKnotEntity current : results) {
            if (!current.m_31748_().equals((Object)pos)) continue;
            return current;
        }
        return null;
    }

    public static boolean canAttachTo(BlockState block) {
        return block != null && block.m_204336_(BlockTags.f_13032_) || block.m_204336_(BlockTags.f_13039_);
    }

    public float m_6961_(Mirror mirror) {
        if (mirror != Mirror.NONE) {
            for (Tag element : this.incompleteLinks) {
                CompoundTag link;
                if (!(element instanceof CompoundTag) || !(link = (CompoundTag)element).m_128441_("RelX")) continue;
                link.m_128405_("RelX", -link.m_128451_("RelX"));
            }
        }
        float yaw = Mth.m_14177_((float)this.m_146908_());
        return switch (mirror) {
            case Mirror.LEFT_RIGHT -> 180.0f - yaw;
            case Mirror.FRONT_BACK -> -yaw;
            default -> yaw;
        };
    }

    public boolean m_7313_(Entity attacker) {
        if (attacker instanceof Player) {
            Player playerEntity = (Player)attacker;
            this.m_6469_(DamageSource.m_19344_((Player)playerEntity), 0.0f);
        } else {
            this.m_5496_(SoundEvents.f_11744_, 0.5f, 1.0f);
        }
        return true;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        InteractionResult result = ChainLinkEntity.onDamageFrom((Entity)this, source);
        if (result.m_19077_()) {
            this.destroyLinks(result == InteractionResult.SUCCESS);
            return true;
        }
        return false;
    }

    public void m_7380_(CompoundTag root) {
        ChainKnotFixer.INSTANCE.addVersionTag(root);
        root.m_128359_("ChainType", ChainTypesRegistry.getKey(this.chainType).toString());
        ListTag linksTag = new ListTag();
        for (ChainLink link : this.links) {
            if (link.isDead() || link.primary != this) continue;
            Entity secondary = link.secondary;
            CompoundTag compoundTag = new CompoundTag();
            compoundTag.m_128359_("ChainType", ChainTypesRegistry.getKey(link.chainType).toString());
            if (secondary instanceof Player) {
                UUID uuid = secondary.m_20148_();
                compoundTag.m_128362_("UUID", uuid);
            } else if (secondary instanceof HangingEntity) {
                BlockPos srcPos = this.f_31698_;
                BlockPos dstPos = ((HangingEntity)secondary).m_31748_();
                BlockPos relPos = dstPos.m_121996_((Vec3i)srcPos);
                Direction inverseFacing = Direction.m_122364_((double)(Direction.SOUTH.m_122435_() - this.m_146908_()));
                relPos = this.getBlockPosAsFacingRelative(relPos, inverseFacing);
                compoundTag.m_128405_("RelX", relPos.m_123341_());
                compoundTag.m_128405_("RelY", relPos.m_123342_());
                compoundTag.m_128405_("RelZ", relPos.m_123343_());
            }
            linksTag.add((Object)compoundTag);
        }
        linksTag.addAll(this.incompleteLinks);
        if (!linksTag.isEmpty()) {
            root.m_128365_("Chains", (Tag)linksTag);
        }
    }

    public void m_7378_(CompoundTag root) {
        if (root.m_128441_("Chains")) {
            this.incompleteLinks.addAll((Collection)root.m_128437_("Chains", 10));
        }
        this.chainType = ChainTypesRegistry.getValue(root.m_128461_("ChainType"));
    }

    public int m_7076_() {
        return 9;
    }

    public int m_7068_() {
        return 9;
    }

    public boolean m_6783_(double distance) {
        return distance < 2048.0;
    }

    public Vec3 m_7939_() {
        return new Vec3(0.0, 0.28125, 0.0);
    }

    public Vec3 m_7398_(float pPartialTicks) {
        return this.m_20318_(pPartialTicks).m_82520_(0.0, 0.28125, 0.0);
    }

    protected float m_6380_(Pose pPose, EntityDimensions pSize) {
        return 0.28125f;
    }

    public InteractionResult m_6096_(Player player, InteractionHand hand) {
        ItemStack handStack = player.m_21120_(hand);
        if (this.f_19853_.f_46443_) {
            if (ChainTypesRegistry.ITEM_CHAIN_TYPES.containsKey(handStack.m_41720_())) {
                return InteractionResult.SUCCESS;
            }
            if (ChainLinkEntity.canDestroyWith(handStack)) {
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.PASS;
        }
        boolean madeConnection = this.tryAttachHeldChains(player);
        if (madeConnection) {
            this.m_7084_();
            return InteractionResult.CONSUME;
        }
        boolean broke = false;
        for (ChainLink link : this.links) {
            if (link.secondary != player) continue;
            broke = true;
            link.destroy(true);
        }
        if (broke) {
            return InteractionResult.CONSUME;
        }
        if (ChainTypesRegistry.ITEM_CHAIN_TYPES.containsKey(handStack.m_41720_())) {
            this.m_7084_();
            ChainType chainType = ChainTypesRegistry.ITEM_CHAIN_TYPES.get(handStack.m_41720_()).get();
            ChainLink.create(this, (Entity)player, chainType);
            if (!player.m_7500_()) {
                player.m_21120_(hand).m_41774_(1);
            }
            this.updateChainType(chainType);
            return InteractionResult.CONSUME;
        }
        if (ChainLinkEntity.canDestroyWith(handStack)) {
            this.destroyLinks(!player.m_7500_());
            this.graceTicks = 0;
            return InteractionResult.CONSUME;
        }
        return InteractionResult.PASS;
    }

    public boolean tryAttachHeldChains(Player player) {
        boolean hasMadeConnection = false;
        List<ChainLink> attachableLinks = ChainKnotEntity.getHeldChainsInRange(player, this.m_31748_());
        for (ChainLink link : attachableLinks) {
            ChainLink newLink;
            if (link.primary == this || (newLink = ChainLink.create(link.primary, (Entity)this, link.chainType)) == null) continue;
            link.destroy(false);
            link.removeSilently = true;
            hasMadeConnection = true;
        }
        return hasMadeConnection;
    }

    public void m_7084_() {
        this.m_5496_(SoundEvents.f_11745_, 1.0f, 1.0f);
    }

    public void updateChainType(ChainType chainType) {
        this.chainType = chainType;
        if (!this.f_19853_.f_46443_) {
            S2CKnotChangeTypePacket packet = new S2CKnotChangeTypePacket(this.m_19879_(), ChainTypesRegistry.getKey(chainType));
            BlockPos pos = this.m_20183_();
            ModPacketHandler.INSTANCE.send(PacketDistributor.NEAR.with(PacketDistributor.TargetPoint.p((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (double)2048.0, (ResourceKey)this.f_19853_.m_46472_())), (Object)packet);
        }
    }

    public static List<ChainLink> getHeldChainsInRange(Player player, BlockPos target) {
        AABB searchBox = AABB.m_165882_((Vec3)Vec3.m_82528_((Vec3i)target), (double)(ChainKnotEntity.getMaxRange() * 2.0), (double)(ChainKnotEntity.getMaxRange() * 2.0), (double)(ChainKnotEntity.getMaxRange() * 2.0));
        List otherKnots = player.f_19853_.m_45976_(ChainKnotEntity.class, searchBox);
        ArrayList<ChainLink> attachableLinks = new ArrayList<ChainLink>();
        for (ChainKnotEntity source : otherKnots) {
            for (ChainLink link : source.getLinks()) {
                if (link.secondary != player) continue;
                attachableLinks.add(link);
            }
        }
        return attachableLinks;
    }

    public List<ChainLink> getLinks() {
        return this.links;
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void writeSpawnData(FriendlyByteBuf buffer) {
        buffer.m_130085_(ChainTypesRegistry.getKey(this.chainType));
    }

    public void readSpawnData(FriendlyByteBuf additionalData) {
        ResourceLocation chainTypeID = additionalData.m_130281_();
        this.setChainType(ChainTypesRegistry.getValue(chainTypeID));
        this.setGraceTicks((byte)0);
    }

    public boolean shouldRenderKnot() {
        return this.attachTarget == null || !this.attachTarget.m_204336_(BlockTags.f_13032_);
    }

    public void addLink(ChainLink link) {
        this.links.add((Object)link);
    }

    public ItemStack getPickedResult(HitResult target) {
        return new ItemStack((ItemLike)this.chainType.item());
    }
}

