/*
 * Decompiled with CFR 0.152.
 */
package com.lilypuree.connectiblechains.network;

import com.lilypuree.connectiblechains.client.ClientInitializer;
import java.util.Collections;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.network.NetworkEvent;

public class S2CChainAttachPacket {
    public static ResourceLocation S2C_CHAIN_ATTACH_PACKET_ID = new ResourceLocation("connectiblechains", "s2c_chain_attach_packet_id");
    private int fromId;
    private int toId;
    private ResourceLocation chainType;

    public S2CChainAttachPacket(int fromId, int toId, ResourceLocation chainType) {
        this.fromId = fromId;
        this.toId = toId;
        this.chainType = chainType;
    }

    public S2CChainAttachPacket(FriendlyByteBuf buf) {
        this.fromId = buf.readInt();
        this.toId = buf.readInt();
        this.chainType = buf.m_130281_();
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeInt(this.fromId);
        buf.writeInt(this.toId);
        buf.m_130085_(this.chainType);
    }

    public boolean handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            try {
                ClientInitializer.chainPacketHandler.createLinks(this.fromId, new int[]{this.toId}, Collections.singletonList(this.chainType));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
        return true;
    }
}

