/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.config.eventHandlers.presets;

import com.seibel.distanthorizons.api.enums.config.EHorizontalQuality;
import com.seibel.distanthorizons.api.enums.config.EMaxHorizontalResolution;
import com.seibel.distanthorizons.api.enums.config.EVerticalQuality;
import com.seibel.distanthorizons.api.enums.config.quickOptions.EQualityPreset;
import com.seibel.distanthorizons.api.enums.rendering.ETransparency;
import com.seibel.distanthorizons.core.config.Config;
import com.seibel.distanthorizons.core.config.ConfigEntryWithPresetOptions;
import com.seibel.distanthorizons.core.config.eventHandlers.presets.AbstractPresetConfigEventHandler;
import com.seibel.distanthorizons.core.config.listeners.ConfigChangeListener;
import com.seibel.distanthorizons.coreapi.interfaces.config.IConfigEntry;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RenderQualityPresetConfigEventHandler
extends AbstractPresetConfigEventHandler<EQualityPreset> {
    public static final RenderQualityPresetConfigEventHandler INSTANCE = new RenderQualityPresetConfigEventHandler();
    private static final Logger LOGGER = LogManager.getLogger();
    private final ConfigEntryWithPresetOptions<EQualityPreset, EMaxHorizontalResolution> drawResolution = new ConfigEntryWithPresetOptions<EQualityPreset, EMaxHorizontalResolution>(Config.Client.Advanced.Graphics.Quality.maxHorizontalResolution, new HashMap<EQualityPreset, EMaxHorizontalResolution>(){
        {
            this.put(EQualityPreset.MINIMUM, EMaxHorizontalResolution.TWO_BLOCKS);
            this.put(EQualityPreset.LOW, EMaxHorizontalResolution.BLOCK);
            this.put(EQualityPreset.MEDIUM, EMaxHorizontalResolution.BLOCK);
            this.put(EQualityPreset.HIGH, EMaxHorizontalResolution.BLOCK);
            this.put(EQualityPreset.EXTREME, EMaxHorizontalResolution.BLOCK);
        }
    });
    private final ConfigEntryWithPresetOptions<EQualityPreset, EVerticalQuality> verticalQuality = new ConfigEntryWithPresetOptions<EQualityPreset, EVerticalQuality>(Config.Client.Advanced.Graphics.Quality.verticalQuality, new HashMap<EQualityPreset, EVerticalQuality>(){
        {
            this.put(EQualityPreset.MINIMUM, EVerticalQuality.HEIGHT_MAP);
            this.put(EQualityPreset.LOW, EVerticalQuality.LOW);
            this.put(EQualityPreset.MEDIUM, EVerticalQuality.MEDIUM);
            this.put(EQualityPreset.HIGH, EVerticalQuality.HIGH);
            this.put(EQualityPreset.EXTREME, EVerticalQuality.EXTREME);
        }
    });
    private final ConfigEntryWithPresetOptions<EQualityPreset, EHorizontalQuality> horizontalQuality = new ConfigEntryWithPresetOptions<EQualityPreset, EHorizontalQuality>(Config.Client.Advanced.Graphics.Quality.horizontalQuality, new HashMap<EQualityPreset, EHorizontalQuality>(){
        {
            this.put(EQualityPreset.MINIMUM, EHorizontalQuality.LOWEST);
            this.put(EQualityPreset.LOW, EHorizontalQuality.LOW);
            this.put(EQualityPreset.MEDIUM, EHorizontalQuality.MEDIUM);
            this.put(EQualityPreset.HIGH, EHorizontalQuality.HIGH);
            this.put(EQualityPreset.EXTREME, EHorizontalQuality.EXTREME);
        }
    });
    private final ConfigEntryWithPresetOptions<EQualityPreset, ETransparency> transparency = new ConfigEntryWithPresetOptions<EQualityPreset, ETransparency>(Config.Client.Advanced.Graphics.Quality.transparency, new HashMap<EQualityPreset, ETransparency>(){
        {
            this.put(EQualityPreset.MINIMUM, ETransparency.DISABLED);
            this.put(EQualityPreset.LOW, ETransparency.DISABLED);
            this.put(EQualityPreset.MEDIUM, ETransparency.COMPLETE);
            this.put(EQualityPreset.HIGH, ETransparency.COMPLETE);
            this.put(EQualityPreset.EXTREME, ETransparency.COMPLETE);
        }
    });
    private final ConfigEntryWithPresetOptions<EQualityPreset, Boolean> ssaoEnabled = new ConfigEntryWithPresetOptions<EQualityPreset, Boolean>(Config.Client.Advanced.Graphics.Ssao.enabled, new HashMap<EQualityPreset, Boolean>(){
        {
            this.put(EQualityPreset.MINIMUM, false);
            this.put(EQualityPreset.LOW, false);
            this.put(EQualityPreset.MEDIUM, true);
            this.put(EQualityPreset.HIGH, true);
            this.put(EQualityPreset.EXTREME, true);
        }
    });

    private RenderQualityPresetConfigEventHandler() {
        this.configList.add(this.drawResolution);
        this.configList.add(this.verticalQuality);
        this.configList.add(this.horizontalQuality);
        this.configList.add(this.transparency);
        this.configList.add(this.ssaoEnabled);
        for (ConfigEntryWithPresetOptions config : this.configList) {
            new ConfigChangeListener<Object>(config.configEntry, val -> this.onConfigValueChanged());
        }
    }

    @Override
    protected IConfigEntry<EQualityPreset> getPresetConfigEntry() {
        return Config.Client.qualityPresetSetting;
    }

    @Override
    protected List<EQualityPreset> getPresetEnumList() {
        return Arrays.asList(EQualityPreset.values());
    }

    @Override
    protected EQualityPreset getCustomPresetEnum() {
        return EQualityPreset.CUSTOM;
    }
}

