/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.file.fullDatafile;

import com.seibel.distanthorizons.core.config.Config;
import com.seibel.distanthorizons.core.dataObjects.fullData.accessor.ChunkSizedFullDataAccessor;
import com.seibel.distanthorizons.core.dataObjects.fullData.loader.AbstractFullDataSourceLoader;
import com.seibel.distanthorizons.core.dataObjects.fullData.sources.CompleteFullDataSource;
import com.seibel.distanthorizons.core.dataObjects.fullData.sources.interfaces.IFullDataSource;
import com.seibel.distanthorizons.core.dataObjects.fullData.sources.interfaces.IIncompleteFullDataSource;
import com.seibel.distanthorizons.core.file.DataSourceReferenceTracker;
import com.seibel.distanthorizons.core.file.fullDatafile.IFullDataSourceProvider;
import com.seibel.distanthorizons.core.file.metaData.AbstractMetaDataContainerFile;
import com.seibel.distanthorizons.core.file.metaData.BaseMetaData;
import com.seibel.distanthorizons.core.level.IDhLevel;
import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import com.seibel.distanthorizons.core.pos.DhLodPos;
import com.seibel.distanthorizons.core.pos.DhSectionPos;
import com.seibel.distanthorizons.core.render.renderer.DebugRenderer;
import com.seibel.distanthorizons.core.render.renderer.IDebugRenderable;
import com.seibel.distanthorizons.core.sql.MetaDataDto;
import com.seibel.distanthorizons.core.util.AtomicsUtil;
import com.seibel.distanthorizons.core.util.LodUtil;
import com.seibel.distanthorizons.core.util.objects.dataStreams.DhDataInputStream;
import com.seibel.distanthorizons.core.util.objects.dataStreams.DhDataOutputStream;
import com.seibel.distanthorizons.core.util.threading.ThreadPools;
import java.awt.Color;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.PhantomReference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.nio.channels.ClosedByInterruptException;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.logging.log4j.Logger;

public class FullDataMetaFile
extends AbstractMetaDataContainerFile
implements IDebugRenderable {
    public static final String FILE_SUFFIX = ".lod";
    private static final Logger LOGGER = DhLoggerBuilder.getLogger(FullDataMetaFile.class.getSimpleName());
    private static final boolean LOG_DATA_SOURCE_LIVES = false;
    private static final ReferenceQueue<IFullDataSource> LIFE_CYCLE_DEBUG_QUEUE = new ReferenceQueue();
    private static final ReferenceQueue<IFullDataSource> SOFT_REF_DEBUG_QUEUE = new ReferenceQueue();
    private static final Set<DataObjTracker> LIFE_CYCLE_DEBUG_SET = ConcurrentHashMap.newKeySet();
    private static final Set<DataObjSoftTracker> SOFT_REF_DEBUG_SET = ConcurrentHashMap.newKeySet();
    public boolean doesDtoExist;
    public boolean genQueueChecked = false;
    public AbstractFullDataSourceLoader fullDataSourceLoader;
    public Class<? extends IFullDataSource> fullDataSourceClass;
    private volatile boolean needsUpdate = false;
    private final IDhLevel level;
    private final IFullDataSourceProvider fullDataSourceProvider;
    private DataSourceReferenceTracker.FullDataSourceSoftRef cachedFullDataSourceRef = new DataSourceReferenceTracker.FullDataSourceSoftRef(this, null);
    private final AtomicReference<CompletableFuture<IFullDataSource>> dataSourceLoadFutureRef = new AtomicReference<Object>(null);
    public volatile Boolean cacheLoadingDataSource = null;
    private final AtomicReference<GuardedMultiAppendQueue> writeQueueRef = new AtomicReference<GuardedMultiAppendQueue>(new GuardedMultiAppendQueue());
    private GuardedMultiAppendQueue backWriteQueue = new GuardedMultiAppendQueue();

    public static FullDataMetaFile createNewDtoForPos(IFullDataSourceProvider fullDataSourceProvider, IDhLevel clientLevel, DhSectionPos pos) throws IOException {
        return new FullDataMetaFile(fullDataSourceProvider, clientLevel, pos);
    }

    private FullDataMetaFile(IFullDataSourceProvider fullDataSourceProvider, IDhLevel level, DhSectionPos pos) throws IOException {
        super(pos);
        FullDataMetaFile.checkAndLogPhantomDataSourceLifeCycles();
        this.fullDataSourceProvider = fullDataSourceProvider;
        this.level = level;
        LodUtil.assertTrue(this.baseMetaData == null);
        this.doesDtoExist = false;
        DebugRenderer.register(this, Config.Client.Advanced.Debugging.DebugWireframe.showFullDataFileStatus);
    }

    public static FullDataMetaFile createFromExistingDto(IFullDataSourceProvider fullDataSourceProvider, IDhLevel level, MetaDataDto metaDataDto) throws IOException {
        return new FullDataMetaFile(fullDataSourceProvider, level, metaDataDto);
    }

    private FullDataMetaFile(IFullDataSourceProvider fullDataSourceProvider, IDhLevel level, MetaDataDto metaDataDto) throws IOException {
        super(metaDataDto.baseMetaData);
        FullDataMetaFile.checkAndLogPhantomDataSourceLifeCycles();
        this.fullDataSourceProvider = fullDataSourceProvider;
        this.level = level;
        LodUtil.assertTrue(this.baseMetaData != null);
        this.doesDtoExist = true;
        this.fullDataSourceLoader = AbstractFullDataSourceLoader.getLoader(this.baseMetaData.dataType, this.baseMetaData.binaryDataFormatVersion);
        if (this.fullDataSourceLoader == null) {
            throw new IOException("Invalid file: Data type loader not found: " + this.baseMetaData.dataType + "(v" + this.baseMetaData.binaryDataFormatVersion + ")");
        }
        this.fullDataSourceClass = this.fullDataSourceLoader.fullDataSourceClass;
        DebugRenderer.register(this, Config.Client.Advanced.Debugging.DebugWireframe.showFullDataFileStatus);
    }

    public IFullDataSource getCachedDataSourceNowOrNull() {
        FullDataMetaFile.checkAndLogPhantomDataSourceLifeCycles();
        return (IFullDataSource)this.cachedFullDataSourceRef.get();
    }

    public boolean clearCachedDataSource() {
        boolean dataExists;
        boolean bl = dataExists = this.cachedFullDataSourceRef.get() != null;
        if (dataExists) {
            this.cachedFullDataSourceRef.close();
            this.cachedFullDataSourceRef.clear();
            this.cacheLoadingDataSource = null;
        }
        return dataExists;
    }

    public CompletableFuture<IFullDataSource> getDataSourceWithoutCachingAsync() {
        return this.getOrLoadCachedDataSourceAsync(false);
    }

    public CompletableFuture<IFullDataSource> getOrLoadCachedDataSourceAsync() {
        return this.getOrLoadCachedDataSourceAsync(true);
    }

    private CompletableFuture<IFullDataSource> getOrLoadCachedDataSourceAsync(boolean cacheLoadingSource) {
        FullDataMetaFile.checkAndLogPhantomDataSourceLifeCycles();
        CompletableFuture<IFullDataSource> potentialLoadFuture = this.getCachedDataSourceAsync();
        if (potentialLoadFuture != null) {
            if (cacheLoadingSource) {
                this.cacheLoadingDataSource = true;
            }
            return potentialLoadFuture;
        }
        potentialLoadFuture = new CompletableFuture();
        if (!this.dataSourceLoadFutureRef.compareAndSet(null, potentialLoadFuture)) {
            potentialLoadFuture = this.dataSourceLoadFutureRef.get();
        }
        this.cacheLoadingDataSource = cacheLoadingSource;
        CompletableFuture<IFullDataSource> dataSourceLoadFuture = potentialLoadFuture;
        if (!this.doesDtoExist) {
            ((CompletableFuture)((CompletableFuture)this.fullDataSourceProvider.onDataFileCreatedAsync(this).thenApply(fullDataSource -> {
                AbstractFullDataSourceLoader dataSourceLoader = AbstractFullDataSourceLoader.getLoader(fullDataSource.getClass(), fullDataSource.getBinaryDataFormatVersion());
                this.baseMetaData = new BaseMetaData(fullDataSource.getSectionPos(), -1, fullDataSource.getDataDetailLevel(), fullDataSource.getWorldGenStep(), dataSourceLoader == null ? null : dataSourceLoader.datatype, fullDataSource.getBinaryDataFormatVersion(), Long.MAX_VALUE);
                return fullDataSource;
            })).thenCompose(fullDataSource -> this.applyWriteQueueAndSaveAsync((IFullDataSource)fullDataSource))).thenAccept(fullDataSource -> {
                dataSourceLoadFuture.complete((IFullDataSource)fullDataSource);
                this.dataSourceLoadFutureRef.set(null);
            });
        } else {
            if (this.baseMetaData == null) {
                throw new IllegalStateException("Meta data not loaded!");
            }
            ThreadPoolExecutor executor = ThreadPools.getFileHandlerExecutor();
            if (executor != null && !executor.isTerminated()) {
                ((CompletableFuture)CompletableFuture.supplyAsync(() -> {
                    IFullDataSource fullDataSource;
                    try (InputStream inputStream = this.getInputStream();
                         DhDataInputStream compressedStream = new DhDataInputStream(inputStream);){
                        fullDataSource = cacheLoadingSource ? this.fullDataSourceLoader.loadDataSource(this, compressedStream, this.level) : this.fullDataSourceLoader.loadTemporaryDataSource(this, compressedStream, this.level);
                    }
                    catch (Exception ex) {
                        LOGGER.error("Full Data Load error: " + ex.getMessage(), (Throwable)ex);
                        dataSourceLoadFuture.completeExceptionally(ex);
                        this.dataSourceLoadFutureRef.set(null);
                        throw new CompletionException(ex);
                    }
                    return fullDataSource;
                }, executor).thenCompose(fullDataSource -> this.applyWriteQueueAndSaveAsync((IFullDataSource)fullDataSource))).thenAccept(fullDataSource -> {
                    dataSourceLoadFuture.complete((IFullDataSource)fullDataSource);
                    this.dataSourceLoadFutureRef.set(null);
                });
            } else {
                dataSourceLoadFuture.complete(null);
                this.dataSourceLoadFutureRef.set(null);
                return dataSourceLoadFuture;
            }
        }
        return dataSourceLoadFuture;
    }

    private CompletableFuture<IFullDataSource> getCachedDataSourceAsync() {
        boolean dataNeedsUpdating;
        CompletableFuture<IFullDataSource> dataSourceLoadFuture = this.dataSourceLoadFutureRef.get();
        if (dataSourceLoadFuture != null) {
            return dataSourceLoadFuture;
        }
        IFullDataSource cachedFullDataSource = (IFullDataSource)this.cachedFullDataSourceRef.get();
        if (cachedFullDataSource == null) {
            return null;
        }
        boolean bl = dataNeedsUpdating = !this.writeQueueRef.get().queue.isEmpty() || this.needsUpdate;
        if (!dataNeedsUpdating) {
            return CompletableFuture.completedFuture(cachedFullDataSource);
        }
        CompletableFuture<IFullDataSource> newFuture = new CompletableFuture<IFullDataSource>();
        CompletableFuture<IFullDataSource> oldFuture = AtomicsUtil.compareAndExchange(this.dataSourceLoadFutureRef, null, newFuture);
        if (oldFuture != null) {
            return oldFuture;
        }
        ThreadPoolExecutor executor = ThreadPools.getFileHandlerExecutor();
        if (executor != null && !executor.isTerminated()) {
            ((CompletableFuture)CompletableFuture.supplyAsync(() -> cachedFullDataSource, executor).thenCompose(fullDataSource -> this.applyWriteQueueAndSaveAsync((IFullDataSource)fullDataSource))).thenAccept(fullDataSource -> {
                newFuture.complete((IFullDataSource)fullDataSource);
                this.dataSourceLoadFutureRef.set(null);
            });
        } else {
            this.dataSourceLoadFutureRef.set(null);
            newFuture.complete(null);
        }
        return newFuture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addToWriteQueue(ChunkSizedFullDataAccessor chunkAccessor) {
        FullDataMetaFile.checkAndLogPhantomDataSourceLifeCycles();
        DhLodPos chunkLodPos = new DhLodPos(4, chunkAccessor.chunkPos.x, chunkAccessor.chunkPos.z);
        LodUtil.assertTrue(this.pos.getSectionBBoxPos().overlapsExactly(chunkLodPos), "Chunk pos " + chunkLodPos + " doesn't exactly overlap with section " + this.pos);
        GuardedMultiAppendQueue writeQueue = this.writeQueueRef.get();
        ReentrantReadWriteLock.ReadLock appendLock = writeQueue.appendLock.readLock();
        appendLock.lock();
        try {
            writeQueue.queue.add(chunkAccessor);
        }
        finally {
            appendLock.unlock();
        }
        this.flushAndSaveAsync();
    }

    public CompletableFuture<Void> flushAndSaveAsync() {
        boolean isEmpty;
        FullDataMetaFile.checkAndLogPhantomDataSourceLifeCycles();
        boolean bl = isEmpty = this.writeQueueRef.get().queue.isEmpty() && !this.needsUpdate;
        if (!isEmpty) {
            return this.getDataSourceWithoutCachingAsync().thenApply(fullDataSource -> null);
        }
        return CompletableFuture.completedFuture(null);
    }

    public void markNeedsUpdate() {
        this.needsUpdate = true;
    }

    public static void checkAndLogPhantomDataSourceLifeCycles() {
        DataObjTracker phantomRef = (DataObjTracker)LIFE_CYCLE_DEBUG_QUEUE.poll();
        while (phantomRef != null) {
            phantomRef.close();
            phantomRef = (DataObjTracker)LIFE_CYCLE_DEBUG_QUEUE.poll();
        }
        DataObjSoftTracker softRef = (DataObjSoftTracker)SOFT_REF_DEBUG_QUEUE.poll();
        while (softRef != null) {
            softRef.close();
            softRef = (DataObjSoftTracker)SOFT_REF_DEBUG_QUEUE.poll();
        }
    }

    @Override
    public void debugRender(DebugRenderer debugRenderer) {
        if (this.pos.getDetailLevel() > 6) {
            return;
        }
        if (this.needsUpdate) {
            debugRenderer.renderBox(new DebugRenderer.Box(this.pos, 80.0f, 96.0f, 0.05f, Color.red));
        }
        IFullDataSource cachedDataSource = (IFullDataSource)this.cachedFullDataSourceRef.get();
        boolean needsUpdate = !this.writeQueueRef.get().queue.isEmpty() || this.needsUpdate;
        Color color = Color.black;
        if (cachedDataSource != null) {
            color = cachedDataSource instanceof CompleteFullDataSource ? Color.GREEN : Color.YELLOW;
        } else if (this.dataSourceLoadFutureRef.get() != null) {
            color = Color.BLUE;
        } else if (this.doesDtoExist) {
            color = Color.RED;
        } else if (needsUpdate) {
            color = color.darker().darker();
        }
        debugRenderer.renderBox(new DebugRenderer.Box(this.pos, 80.0f, 96.0f, 0.05f, color));
    }

    private InputStream getInputStream() throws IOException {
        MetaDataDto dto = (MetaDataDto)this.fullDataSourceProvider.getRepo().getByPrimaryKey(this.pos.serialize());
        return new ByteArrayInputStream(dto.dataArray);
    }

    private CompletableFuture<IFullDataSource> applyWriteQueueAndSaveAsync(IFullDataSource fullDataSourceToUpdate) {
        CompletableFuture<IFullDataSource> completionFuture = new CompletableFuture<IFullDataSource>();
        boolean dataChanged = this.applyWriteQueueToFullDataSource(fullDataSourceToUpdate);
        this.needsUpdate = false;
        if (fullDataSourceToUpdate instanceof IIncompleteFullDataSource) {
            IFullDataSource newSource = ((IIncompleteFullDataSource)fullDataSourceToUpdate).tryPromotingToCompleteDataSource();
            dataChanged |= newSource != fullDataSourceToUpdate;
            fullDataSourceToUpdate = newSource;
        }
        this.fullDataSourceProvider.onDataFileUpdateAsync(fullDataSourceToUpdate, this, dataChanged).whenComplete((dataFileUpdateResult, ex) -> {
            if (ex != null && !LodUtil.isInterruptOrReject(ex)) {
                LOGGER.error("Error updating full meta file [" + this.pos + "]: ", ex);
            }
            IFullDataSource fullDataSource = dataFileUpdateResult.fullDataSource;
            boolean dataSourceChanged = dataFileUpdateResult.dataSourceChanged;
            if (dataSourceChanged) {
                this.writeDataSource(fullDataSource);
            }
            if (fullDataSource != null) {
                new DataObjTracker(fullDataSource);
                new DataObjSoftTracker(this, fullDataSource);
            }
            boolean showFullDataFileStatus = Config.Client.Advanced.Debugging.DebugWireframe.showFullDataFileStatus.get();
            boolean showFullDataFileSampling = Config.Client.Advanced.Debugging.DebugWireframe.showFullDataFileSampling.get();
            if (showFullDataFileStatus || showFullDataFileSampling) {
                Color color = dataSourceChanged ? Color.GREEN : Color.GREEN.darker().darker();
                DebugRenderer.makeParticle(new DebugRenderer.BoxParticle(new DebugRenderer.Box(this.pos, 64.0f, 72.0f, 0.03f, color), 0.2, 32.0f));
            }
            if (this.cacheLoadingDataSource.booleanValue()) {
                this.cachedFullDataSourceRef = new DataSourceReferenceTracker.FullDataSourceSoftRef(this, fullDataSource);
            }
            completionFuture.complete(fullDataSource);
            if (this.needsUpdate) {
                if (this.cacheLoadingDataSource.booleanValue()) {
                    this.getOrLoadCachedDataSourceAsync();
                } else {
                    this.getDataSourceWithoutCachingAsync();
                }
            }
        });
        return completionFuture;
    }

    private boolean applyWriteQueueToFullDataSource(IFullDataSource fullDataSource) {
        boolean queueIsEmpty = this.writeQueueRef.get().queue.isEmpty();
        if (!queueIsEmpty) {
            this.swapWriteQueues();
            for (ChunkSizedFullDataAccessor chunk : this.backWriteQueue.queue) {
                fullDataSource.update(chunk);
            }
            this.backWriteQueue.queue.clear();
        }
        return !queueIsEmpty || !this.doesDtoExist;
    }

    private void swapWriteQueues() {
        GuardedMultiAppendQueue writeQueue = this.writeQueueRef.getAndSet(this.backWriteQueue);
        writeQueue.appendLock.writeLock().lock();
        writeQueue.appendLock.writeLock().unlock();
        this.backWriteQueue = writeQueue;
    }

    private void writeDataSource(IFullDataSource fullDataSource) {
        if (fullDataSource.isEmpty()) {
            MetaDataDto dto = (MetaDataDto)this.fullDataSourceProvider.getRepo().getByPrimaryKey(this.pos.serialize());
            if (dto != null) {
                this.fullDataSourceProvider.getRepo().delete(dto);
            }
            this.doesDtoExist = false;
        } else {
            try {
                LodUtil.assertTrue(this.baseMetaData != null);
                this.baseMetaData.dataDetailLevel = fullDataSource.getDataDetailLevel();
                this.fullDataSourceLoader = AbstractFullDataSourceLoader.getLoader(fullDataSource.getClass(), fullDataSource.getBinaryDataFormatVersion());
                LodUtil.assertTrue(this.fullDataSourceLoader != null, "No loader for " + fullDataSource.getClass() + " (v" + fullDataSource.getBinaryDataFormatVersion() + ")");
                this.fullDataSourceClass = fullDataSource.getClass();
                this.baseMetaData.dataType = this.fullDataSourceLoader == null ? null : this.fullDataSourceLoader.datatype;
                this.baseMetaData.binaryDataFormatVersion = fullDataSource.getBinaryDataFormatVersion();
                super.writeToDatabase(bufferedOutputStream -> fullDataSource.writeToStream((DhDataOutputStream)bufferedOutputStream, this.level), this.fullDataSourceProvider.getRepo());
                this.doesDtoExist = true;
            }
            catch (ClosedByInterruptException dto) {
            }
            catch (IOException e) {
                LOGGER.error("Failed to save updated data for section " + this.pos, (Throwable)e);
            }
        }
    }

    private static class GuardedMultiAppendQueue {
        ReentrantReadWriteLock appendLock = new ReentrantReadWriteLock();
        ConcurrentLinkedQueue<ChunkSizedFullDataAccessor> queue = new ConcurrentLinkedQueue();

        private GuardedMultiAppendQueue() {
        }
    }

    private static class DataObjTracker
    extends PhantomReference<IFullDataSource>
    implements Closeable {
        public final DhSectionPos pos;

        DataObjTracker(IFullDataSource data) {
            super(data, LIFE_CYCLE_DEBUG_QUEUE);
            LIFE_CYCLE_DEBUG_SET.add(this);
            this.pos = data.getSectionPos();
        }

        @Override
        public void close() {
            LIFE_CYCLE_DEBUG_SET.remove(this);
        }
    }

    private static class DataObjSoftTracker
    extends SoftReference<IFullDataSource>
    implements Closeable {
        public final FullDataMetaFile file;

        DataObjSoftTracker(FullDataMetaFile file, IFullDataSource data) {
            super(data, SOFT_REF_DEBUG_QUEUE);
            SOFT_REF_DEBUG_SET.add(this);
            this.file = file;
        }

        @Override
        public void close() {
            SOFT_REF_DEBUG_SET.remove(this);
        }
    }
}

