/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.file.fullDatafile;

import com.seibel.distanthorizons.core.dataObjects.fullData.accessor.ChunkSizedFullDataAccessor;
import com.seibel.distanthorizons.core.dataObjects.fullData.sources.CompleteFullDataSource;
import com.seibel.distanthorizons.core.dataObjects.fullData.sources.interfaces.IFullDataSource;
import com.seibel.distanthorizons.core.dataObjects.fullData.sources.interfaces.IIncompleteFullDataSource;
import com.seibel.distanthorizons.core.file.fullDatafile.FullDataFileHandler;
import com.seibel.distanthorizons.core.file.fullDatafile.FullDataMetaFile;
import com.seibel.distanthorizons.core.file.fullDatafile.IFullDataSourceProvider;
import com.seibel.distanthorizons.core.file.structure.AbstractSaveStructure;
import com.seibel.distanthorizons.core.generation.IWorldGenerationQueue;
import com.seibel.distanthorizons.core.generation.MissingWorldGenPositionFinder;
import com.seibel.distanthorizons.core.generation.tasks.IWorldGenTaskTracker;
import com.seibel.distanthorizons.core.generation.tasks.WorldGenResult;
import com.seibel.distanthorizons.core.level.DhLevel;
import com.seibel.distanthorizons.core.level.IDhLevel;
import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import com.seibel.distanthorizons.core.pos.DhSectionPos;
import com.seibel.distanthorizons.core.util.LodUtil;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.apache.logging.log4j.Logger;

public class GeneratedFullDataFileHandler
extends FullDataFileHandler {
    private static final Logger LOGGER = DhLoggerBuilder.getLogger();
    private static final Timer CHUNK_GEN_FINISHED_TIMER = new Timer();
    private final AtomicReference<IWorldGenerationQueue> worldGenQueueRef = new AtomicReference<Object>(null);
    private final ArrayList<IOnWorldGenCompleteListener> onWorldGenTaskCompleteListeners = new ArrayList();
    private final ConcurrentHashMap<DhSectionPos, IFullDataSource> generatingDataSourceByPos = new ConcurrentHashMap();

    public GeneratedFullDataFileHandler(IDhLevel level, AbstractSaveStructure saveStructure) {
        super(level, saveStructure);
    }

    @Override
    public CompletableFuture<IFullDataSource> readAsync(DhSectionPos pos) {
        CompletableFuture<IFullDataSource> future = super.readAsync(pos);
        return future.thenApply(dataSource -> {
            IWorldGenerationQueue worldGenQueue = this.worldGenQueueRef.get();
            FullDataMetaFile metaFile = (FullDataMetaFile)this.loadedMetaFileBySectionPos.get(pos);
            if (worldGenQueue != null && metaFile != null) {
                this.queueWorldGenForMissingColumnsInDataSource(worldGenQueue, metaFile, (IFullDataSource)dataSource);
            }
            return dataSource;
        });
    }

    @Override
    public void onRenderDataFileLoaded(DhSectionPos pos) {
        IWorldGenerationQueue worldGenQueue = this.worldGenQueueRef.get();
        FullDataMetaFile metaFile = this.getLoadOrMakeFile(pos, false);
        if (worldGenQueue != null && metaFile != null) {
            metaFile.getDataSourceWithoutCachingAsync().thenApply(fullDataSource -> {
                this.queueWorldGenForMissingColumnsInDataSource(worldGenQueue, metaFile, (IFullDataSource)fullDataSource);
                return fullDataSource;
            });
        }
    }

    public void setWorldGenerationQueue(IWorldGenerationQueue newWorldGenQueue) {
        boolean oldQueueExists = this.worldGenQueueRef.compareAndSet(null, newWorldGenQueue);
        LodUtil.assertTrue(oldQueueExists, "previous world gen queue is still here!");
        LOGGER.info("Set world gen queue for level " + this.level + " to start.");
        this.ForEachFile(metaFile -> {
            IFullDataSource dataSource = metaFile.getCachedDataSourceNowOrNull();
            if (dataSource == null) {
                return;
            }
            metaFile.genQueueChecked = false;
            this.queueWorldGenForMissingColumnsInDataSource(this.worldGenQueueRef.get(), (FullDataMetaFile)metaFile, dataSource);
            if (dataSource instanceof CompleteFullDataSource) {
                return;
            }
            metaFile.markNeedsUpdate();
        });
        this.flushAndSaveAsync();
    }

    public void clearGenerationQueue() {
        this.worldGenQueueRef.set(null);
        this.generatingDataSourceByPos.clear();
    }

    public void removeGenRequestIf(Function<DhSectionPos, Boolean> removeIf) {
        this.generatingDataSourceByPos.forEach((pos, dataSource) -> {
            if (((Boolean)removeIf.apply((DhSectionPos)pos)).booleanValue()) {
                this.generatingDataSourceByPos.remove(pos);
            }
        });
    }

    public void addWorldGenCompleteListener(IOnWorldGenCompleteListener listener) {
        this.onWorldGenTaskCompleteListeners.add(listener);
    }

    public void removeWorldGenCompleteListener(IOnWorldGenCompleteListener listener) {
        this.onWorldGenTaskCompleteListeners.remove(listener);
    }

    private IFullDataSource tryPromoteDataSource(IIncompleteFullDataSource source) {
        IFullDataSource newSource = source.tryPromotingToCompleteDataSource();
        if (newSource instanceof CompleteFullDataSource) {
            this.generatingDataSourceByPos.remove(source.getSectionPos());
        }
        return newSource;
    }

    @Nullable
    private CompletableFuture<IFullDataSource> updateFromExistingDataSourcesAsync(FullDataMetaFile file, IIncompleteFullDataSource data, boolean usePooledDataSources) {
        DhSectionPos pos = file.pos;
        ArrayList<FullDataMetaFile> existingFiles = new ArrayList<FullDataMetaFile>();
        ArrayList<DhSectionPos> missingPositions = new ArrayList<DhSectionPos>();
        this.getDataFilesForPosition(pos, pos, existingFiles, missingPositions);
        if (missingPositions.size() == 1) {
            return this.tryStartGenTask(file, data);
        }
        this.makeFiles(missingPositions, existingFiles);
        return ((CompletableFuture)this.sampleFromFileArray(data, existingFiles, usePooledDataSources).thenApply(this::tryPromoteDataSource)).exceptionally(e -> {
            this.removeCorruptedFile(pos, (Throwable)e);
            return null;
        });
    }

    @Nullable
    private CompletableFuture<IFullDataSource> tryStartGenTask(FullDataMetaFile metaFile, IIncompleteFullDataSource dataSource) {
        IWorldGenerationQueue worldGenQueue = this.worldGenQueueRef.get();
        if (worldGenQueue != null) {
            this.queueWorldGenForMissingColumnsInDataSource(worldGenQueue, metaFile, dataSource);
            return CompletableFuture.completedFuture(dataSource);
        }
        return null;
    }

    @Override
    public CompletableFuture<IFullDataSource> onDataFileCreatedAsync(FullDataMetaFile file) {
        DhSectionPos pos = file.pos;
        IIncompleteFullDataSource data = this.makeEmptyDataSource(pos);
        CompletableFuture<IFullDataSource> future = this.updateFromExistingDataSourcesAsync(file, data, true);
        return future == null ? CompletableFuture.completedFuture(data) : future;
    }

    @Override
    public CompletableFuture<IFullDataSourceProvider.DataFileUpdateResult> onDataFileUpdateAsync(IFullDataSource fullDataSource, FullDataMetaFile file, boolean dataChanged) {
        CompletableFuture<IFullDataSource> future;
        IWorldGenerationQueue worldGenQueue;
        LodUtil.assertTrue(this.fullDataRepo.existsWithPrimaryKey(file.pos.serialize()) || dataChanged);
        if (fullDataSource instanceof CompleteFullDataSource) {
            this.generatingDataSourceByPos.remove(fullDataSource.getSectionPos());
        }
        this.fireOnGenPosSuccessListeners(fullDataSource.getSectionPos());
        if (fullDataSource instanceof IIncompleteFullDataSource && !file.genQueueChecked && (worldGenQueue = this.worldGenQueueRef.get()) != null && (future = this.updateFromExistingDataSourcesAsync(file, (IIncompleteFullDataSource)fullDataSource, false)) != null) {
            boolean finalDataChanged = dataChanged;
            return future.thenApply(newSource -> new IFullDataSourceProvider.DataFileUpdateResult((IFullDataSource)newSource, finalDataChanged));
        }
        return CompletableFuture.completedFuture(new IFullDataSourceProvider.DataFileUpdateResult(fullDataSource, dataChanged));
    }

    private void onWorldGenTaskComplete(WorldGenResult genTaskResult, Throwable exception, GenTask genTask, final DhSectionPos pos) {
        if (exception != null) {
            if (!(exception instanceof CancellationException) && !(exception.getCause() instanceof CancellationException)) {
                LOGGER.error("Uncaught Gen Task Exception at " + pos + ":", exception);
            }
        } else {
            if (genTaskResult.success) {
                this.flushAndSaveAsync(pos).join();
                CHUNK_GEN_FINISHED_TIMER.schedule(new TimerTask(){

                    @Override
                    public void run() {
                        GeneratedFullDataFileHandler.this.flushAndSaveAsync(pos).join();
                    }
                }, 4000L);
                this.fireOnGenPosSuccessListeners(pos);
                return;
            }
            LOGGER.debug("Gen Task Failed at " + pos);
        }
        for (CompletableFuture completableFuture : genTaskResult.childFutures) {
            completableFuture.whenComplete((siblingGenTaskResult, siblingEx) -> this.onWorldGenTaskComplete((WorldGenResult)siblingGenTaskResult, (Throwable)siblingEx, genTask, pos));
        }
        genTask.releaseStrongReference();
    }

    private void fireOnGenPosSuccessListeners(DhSectionPos pos) {
        for (IOnWorldGenCompleteListener listener : this.onWorldGenTaskCompleteListeners) {
            listener.onWorldGenTaskComplete(pos);
        }
    }

    private void queueWorldGenForMissingColumnsInDataSource(IWorldGenerationQueue worldGenQueue, FullDataMetaFile metaFile, IFullDataSource dataSource) {
        if (metaFile.genQueueChecked) {
            return;
        }
        metaFile.genQueueChecked = true;
        byte minGeneratorSectionDetailLevel = (byte)(worldGenQueue.highestDataDetail() + 6);
        ArrayList<DhSectionPos> genPosList = MissingWorldGenPositionFinder.getUngeneratedPosList(dataSource, minGeneratorSectionDetailLevel, true);
        ArrayList<CompletableFuture<WorldGenResult>> taskFutureList = new ArrayList<CompletableFuture<WorldGenResult>>();
        for (DhSectionPos genPos : genPosList) {
            this.getLoadOrMakeFile(genPos, true);
            this.getLoadOrMakeFile(metaFile.pos, true);
            GenTask genTask = new GenTask(dataSource.getSectionPos(), new WeakReference<IFullDataSource>(dataSource));
            CompletableFuture<WorldGenResult> worldGenFuture = worldGenQueue.submitGenTask(genPos, dataSource.getDataDetailLevel(), genTask);
            worldGenFuture.whenComplete((genTaskResult, ex) -> {
                this.onWorldGenTaskComplete((WorldGenResult)genTaskResult, (Throwable)ex, genTask, genPos);
                this.onWorldGenTaskComplete((WorldGenResult)genTaskResult, (Throwable)ex, genTask, metaFile.pos);
            });
            taskFutureList.add(worldGenFuture);
        }
        if (taskFutureList.size() != 0) {
            this.generatingDataSourceByPos.put(metaFile.pos, dataSource);
        }
        CompletableFuture.allOf(taskFutureList.toArray(new CompletableFuture[0])).whenComplete((voidObj, ex) -> {
            metaFile.flushAndSaveAsync();
            this.generatingDataSourceByPos.remove(metaFile.pos);
        });
    }

    private class GenTask
    implements IWorldGenTaskTracker {
        private final DhSectionPos pos;
        private final WeakReference<IFullDataSource> targetFullDataSourceRef;
        private IFullDataSource loadedTargetFullDataSource = null;

        public GenTask(DhSectionPos pos, WeakReference<IFullDataSource> targetFullDataSourceRef) {
            this.pos = pos;
            this.targetFullDataSourceRef = targetFullDataSourceRef;
        }

        @Override
        public boolean isMemoryAddressValid() {
            return this.targetFullDataSourceRef.get() != null;
        }

        @Override
        public Consumer<ChunkSizedFullDataAccessor> getChunkDataConsumer() {
            if (this.loadedTargetFullDataSource == null) {
                this.loadedTargetFullDataSource = (IFullDataSource)this.targetFullDataSourceRef.get();
            }
            if (this.loadedTargetFullDataSource == null) {
                return null;
            }
            return chunkSizedFullDataSource -> {
                if (chunkSizedFullDataSource.getSectionPos().overlapsExactly(this.loadedTargetFullDataSource.getSectionPos())) {
                    ((DhLevel)GeneratedFullDataFileHandler.this.level).saveWrites((ChunkSizedFullDataAccessor)chunkSizedFullDataSource);
                }
            };
        }

        public void releaseStrongReference() {
            this.loadedTargetFullDataSource = null;
        }
    }

    @FunctionalInterface
    public static interface IOnWorldGenCompleteListener {
        public void onWorldGenTaskComplete(DhSectionPos var1);
    }
}

