/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.jar.installer;

import com.seibel.distanthorizons.core.jar.installer.WebDownloader;
import distanthorizons.libraries.electronwill.nightconfig.core.Config;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class GitlabGetter {
    public static GitlabGetter INSTANCE = new GitlabGetter();
    public static final String GitlabApi = "https://gitlab.com/api/v4/projects/";
    public final String projectID;
    public final String GitProjID;
    public ArrayList<Config> projectPipelines = new ArrayList();
    private static final Map<String, Config> commitInfo = new HashMap<String, Config>();
    private static final Map<Integer, ArrayList<Config>> pipelineInfo = new HashMap<Integer, ArrayList<Config>>();

    public GitlabGetter() {
        this("18204078");
    }

    public GitlabGetter(String projectID) {
        this.projectID = projectID;
        this.GitProjID = GitlabApi + projectID + "/";
        try {
            this.projectPipelines = WebDownloader.parseWebJsonList(this.GitProjID + "pipelines");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Config getCommitInfo(String commit) {
        if (!commitInfo.containsKey(commit)) {
            try {
                commitInfo.put(commit, WebDownloader.parseWebJson(this.GitProjID + "repository/commits/" + commit));
            }
            catch (Exception e) {
                e.printStackTrace();
                return Config.inMemory();
            }
        }
        return commitInfo.get(commit);
    }

    public ArrayList<Config> getPipelineInfo(int pipeline) {
        if (!pipelineInfo.containsKey(pipeline)) {
            try {
                pipelineInfo.put(pipeline, WebDownloader.parseWebJsonList(this.GitProjID + "pipelines/" + pipeline + "/jobs"));
            }
            catch (Exception e) {
                e.printStackTrace();
                return new ArrayList<Config>();
            }
        }
        return pipelineInfo.get(pipeline);
    }

    public Map<String, URL> getDownloads(int pipelineID) {
        HashMap<String, URL> downloads = new HashMap<String, URL>();
        ArrayList<Config> currentPipelineInfo = this.getPipelineInfo(pipelineID);
        try {
            for (Config cfg : currentPipelineInfo) {
                if (!cfg.get("stage").equals("build")) continue;
                downloads.put(((String)cfg.get("name")).split("\\[|\\]")[1], new URL(this.GitProjID + "jobs/" + cfg.get("id") + "/artifacts"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return downloads;
    }

    public static void main(String[] args) {
        GitlabGetter gitlabGetter = new GitlabGetter();
        System.out.println(gitlabGetter.getDownloads((Integer)gitlabGetter.projectPipelines.get(0).get("id")));
    }

    public static URL getLatestForVersion(String mcVer) {
        try {
            return new URL("https://gitlab.com/jeseibel/minecraft-lod-mod/-/jobs/artifacts/main/download?job=build:%20[" + mcVer + "]");
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

