/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.jar.wrapperInterfaces.config;

import com.seibel.distanthorizons.core.jar.JarUtils;
import com.seibel.distanthorizons.core.wrapperInterfaces.config.ILangWrapper;
import distanthorizons.libraries.electronwill.nightconfig.core.Config;
import distanthorizons.libraries.electronwill.nightconfig.core.io.ParsingMode;
import distanthorizons.libraries.electronwill.nightconfig.json.JsonFormat;
import java.util.Locale;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LangWrapper
implements ILangWrapper {
    public static final LangWrapper INSTANCE = new LangWrapper();
    private static final Config jsonObject = Config.inMemory();
    private static final Logger logger = LogManager.getLogger((String)LangWrapper.class.getSimpleName());

    public static void init() {
        try {
            JsonFormat.fancyInstance().createParser().parse(JarUtils.convertInputStreamToString(JarUtils.accessFile("assets/lod/lang/" + Locale.getDefault().toString().toLowerCase() + ".json")), jsonObject, ParsingMode.REPLACE);
        }
        catch (Exception e) {
            logger.error("Failed to read lang file");
            e.printStackTrace();
        }
    }

    @Override
    public boolean langExists(String str) {
        return jsonObject.get(str) != null;
    }

    @Override
    public String getLang(String str) {
        if (jsonObject.get(str) != null) {
            return (String)jsonObject.get(str);
        }
        return str;
    }
}

