/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.level;

import com.seibel.distanthorizons.core.dataObjects.fullData.accessor.ChunkSizedFullDataAccessor;
import com.seibel.distanthorizons.core.file.fullDatafile.IFullDataSourceProvider;
import com.seibel.distanthorizons.core.file.structure.AbstractSaveStructure;
import com.seibel.distanthorizons.core.level.DhLevel;
import com.seibel.distanthorizons.core.level.IDhServerLevel;
import com.seibel.distanthorizons.core.level.ServerLevelModule;
import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import com.seibel.distanthorizons.core.pos.DhBlockPos2D;
import com.seibel.distanthorizons.core.pos.DhSectionPos;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.ILevelWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.IServerLevelWrapper;
import java.util.concurrent.CompletableFuture;
import org.apache.logging.log4j.Logger;

public class DhServerLevel
extends DhLevel
implements IDhServerLevel {
    private static final Logger LOGGER = DhLoggerBuilder.getLogger();
    public final ServerLevelModule serverside;
    private final IServerLevelWrapper serverLevelWrapper;

    public DhServerLevel(AbstractSaveStructure saveStructure, IServerLevelWrapper serverLevelWrapper) {
        if (saveStructure.getFullDataFolder(serverLevelWrapper).mkdirs()) {
            LOGGER.warn("unable to create data folder.");
        }
        this.serverLevelWrapper = serverLevelWrapper;
        this.serverside = new ServerLevelModule(this, saveStructure);
        LOGGER.info("Started DHLevel for {} with saves at {}", (Object)serverLevelWrapper, (Object)saveStructure);
    }

    @Override
    public void serverTick() {
        this.chunkToLodBuilder.tick();
    }

    @Override
    public void saveWrites(ChunkSizedFullDataAccessor data) {
        DhSectionPos pos = data.getSectionPos();
        pos = pos.convertNewToDetailLevel((byte)6);
        this.getFileHandler().writeChunkDataToFile(pos, data);
    }

    @Override
    public int getMinY() {
        return this.getLevelWrapper().getMinHeight();
    }

    @Override
    public void close() {
        super.close();
        this.serverside.close();
        LOGGER.info("Closed DHLevel for {}", (Object)this.getLevelWrapper());
    }

    @Override
    public CompletableFuture<Void> saveAsync() {
        return this.getFileHandler().flushAndSaveAsync();
    }

    @Override
    public void doWorldGen() {
        boolean shouldDoWorldGen = true;
        boolean isWorldGenRunning = this.serverside.worldGenModule.isWorldGenRunning();
        if (shouldDoWorldGen && !isWorldGenRunning) {
            this.serverside.worldGenModule.startWorldGen(this.serverside.dataFileHandler, new ServerLevelModule.WorldGenState(this));
        } else if (!shouldDoWorldGen && isWorldGenRunning) {
            this.serverside.worldGenModule.stopWorldGen(this.serverside.dataFileHandler);
        }
        if (this.serverside.worldGenModule.isWorldGenRunning()) {
            this.serverside.worldGenModule.worldGenTick(new DhBlockPos2D(0, 0));
        }
    }

    @Override
    public IServerLevelWrapper getServerLevelWrapper() {
        return this.serverLevelWrapper;
    }

    @Override
    public ILevelWrapper getLevelWrapper() {
        return this.getServerLevelWrapper();
    }

    @Override
    public IFullDataSourceProvider getFileHandler() {
        return this.serverside.dataFileHandler;
    }

    @Override
    public AbstractSaveStructure getSaveStructure() {
        return this.serverside.saveStructure;
    }

    @Override
    public boolean hasSkyLight() {
        return this.serverLevelWrapper.hasSkyLight();
    }

    @Override
    public void onWorldGenTaskComplete(DhSectionPos pos) {
    }
}

