/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.logging;

import com.seibel.distanthorizons.api.enums.config.ELoggerMode;
import com.seibel.distanthorizons.core.dependencyInjection.SingletonInjector;
import com.seibel.distanthorizons.core.wrapperInterfaces.minecraft.IMinecraftClientWrapper;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;

public class ConfigBasedSpamLogger {
    private static final IMinecraftClientWrapper MC = SingletonInjector.INSTANCE.get(IMinecraftClientWrapper.class);
    public static final List<WeakReference<ConfigBasedSpamLogger>> loggers = Collections.synchronizedList(new LinkedList());
    private ELoggerMode mode;
    private final Supplier<ELoggerMode> getter;
    private final int maxLogCount;
    private final AtomicInteger logTries = new AtomicInteger(0);
    private final Logger logger;

    public static synchronized void updateAll(boolean flush) {
        loggers.removeIf(logger -> logger.get() == null);
        loggers.forEach(logger -> {
            ConfigBasedSpamLogger l = (ConfigBasedSpamLogger)logger.get();
            if (l != null) {
                l.update();
            }
            if (l != null && flush) {
                l.reset();
            }
        });
    }

    public ConfigBasedSpamLogger(Logger logger, Supplier<ELoggerMode> configQuery, int maxLogPerSec) {
        this.getter = configQuery;
        this.mode = this.getter.get();
        this.maxLogCount = maxLogPerSec;
        this.logger = logger;
        loggers.add(new WeakReference<ConfigBasedSpamLogger>(this));
    }

    public void reset() {
        this.logTries.set(0);
    }

    public boolean canMaybeLog() {
        return this.mode != ELoggerMode.DISABLED && this.logTries.get() < this.maxLogCount;
    }

    public void update() {
        this.mode = this.getter.get();
    }

    private String _throwableToDetailString(Throwable t) {
        StringBuilder sb = new StringBuilder();
        sb.append(t.toString()).append('\n');
        StackTraceElement[] stacks = t.getStackTrace();
        if (stacks == null || stacks.length == 0) {
            return sb.append("  at {Stack trace unavailable}").toString();
        }
        for (StackTraceElement stack : stacks) {
            sb.append("  at ").append(stack.toString()).append("\n");
        }
        return sb.toString();
    }

    public void log(Level level, String str, Object ... param) {
        if (this.logTries.get() >= this.maxLogCount) {
            return;
        }
        Message msg = this.logger.getMessageFactory().newMessage(str, param);
        String msgStr = msg.getFormattedMessage();
        if (this.mode.levelForFile.isLessSpecificThan(level)) {
            Level logLevel;
            Level level2 = logLevel = level.isLessSpecificThan(Level.INFO) ? Level.INFO : level;
            if (param.length > 0 && param[param.length - 1] instanceof Throwable) {
                this.logger.log(logLevel, msgStr, (Throwable)param[param.length - 1]);
            } else {
                this.logger.log(logLevel, msgStr);
            }
        }
        if (this.mode.levelForChat.isLessSpecificThan(level)) {
            if (param.length > 0 && param[param.length - 1] instanceof Throwable) {
                MC.logToChat(level, msgStr + "\n" + this._throwableToDetailString((Throwable)param[param.length - 1]));
            } else {
                MC.logToChat(level, msgStr);
            }
        }
    }

    public void error(String str, Object ... param) {
        this.log(Level.ERROR, str, param);
    }

    public void warn(String str, Object ... param) {
        this.log(Level.WARN, str, param);
    }

    public void info(String str, Object ... param) {
        this.log(Level.INFO, str, param);
    }

    public void debug(String str, Object ... param) {
        this.log(Level.DEBUG, str, param);
    }

    public void trace(String str, Object ... param) {
        this.log(Level.TRACE, str, param);
    }

    public void incLogTries() {
        this.logTries.getAndIncrement();
    }

    public void logInc(Level level, String str, Object ... param) {
        if (this.logTries.getAndIncrement() >= this.maxLogCount) {
            return;
        }
        Message msg = this.logger.getMessageFactory().newMessage(str, param);
        String msgStr = msg.getFormattedMessage();
        if (this.mode.levelForFile.isLessSpecificThan(level)) {
            Level logLevel;
            Level level2 = logLevel = level.isLessSpecificThan(Level.INFO) ? Level.INFO : level;
            if (param.length > 0 && param[param.length - 1] instanceof Throwable) {
                this.logger.log(logLevel, msgStr, (Throwable)param[param.length - 1]);
            } else {
                this.logger.log(logLevel, msgStr);
            }
        }
        if (this.mode.levelForChat.isLessSpecificThan(level)) {
            if (param.length > 0 && param[param.length - 1] instanceof Throwable) {
                MC.logToChat(level, msgStr + "\n" + this._throwableToDetailString((Throwable)param[param.length - 1]));
            } else {
                MC.logToChat(level, msgStr);
            }
        }
    }

    public void errorInc(String str, Object ... param) {
        this.logInc(Level.ERROR, str, param);
    }

    public void warnInc(String str, Object ... param) {
        this.logInc(Level.WARN, str, param);
    }

    public void infoInc(String str, Object ... param) {
        this.logInc(Level.INFO, str, param);
    }

    public void debugInc(String str, Object ... param) {
        this.logInc(Level.DEBUG, str, param);
    }

    public void traceInc(String str, Object ... param) {
        this.logInc(Level.TRACE, str, param);
    }
}

