/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.render.renderer;

import com.seibel.distanthorizons.api.enums.rendering.EFogColorMode;
import com.seibel.distanthorizons.core.config.Config;
import com.seibel.distanthorizons.core.dependencyInjection.ModAccessorInjector;
import com.seibel.distanthorizons.core.dependencyInjection.SingletonInjector;
import com.seibel.distanthorizons.core.logging.ConfigBasedLogger;
import com.seibel.distanthorizons.core.logging.ConfigBasedSpamLogger;
import com.seibel.distanthorizons.core.pos.DhBlockPos;
import com.seibel.distanthorizons.core.render.AbstractRenderBuffer;
import com.seibel.distanthorizons.core.render.RenderBufferHandler;
import com.seibel.distanthorizons.core.render.fog.LodFogConfig;
import com.seibel.distanthorizons.core.render.glObject.GLProxy;
import com.seibel.distanthorizons.core.render.glObject.GLState;
import com.seibel.distanthorizons.core.render.glObject.buffer.GLVertexBuffer;
import com.seibel.distanthorizons.core.render.glObject.buffer.QuadElementBuffer;
import com.seibel.distanthorizons.core.render.glObject.texture.DHDepthTexture;
import com.seibel.distanthorizons.core.render.glObject.texture.DhColorTexture;
import com.seibel.distanthorizons.core.render.glObject.texture.DhFramebuffer;
import com.seibel.distanthorizons.core.render.glObject.texture.EDhDepthBufferFormat;
import com.seibel.distanthorizons.core.render.glObject.texture.EDhInternalTextureFormat;
import com.seibel.distanthorizons.core.render.glObject.texture.EDhPixelFormat;
import com.seibel.distanthorizons.core.render.glObject.texture.EDhPixelType;
import com.seibel.distanthorizons.core.render.renderer.DebugRenderer;
import com.seibel.distanthorizons.core.render.renderer.LodRenderProgram;
import com.seibel.distanthorizons.core.render.renderer.SSAORenderer;
import com.seibel.distanthorizons.core.render.renderer.shaders.DhApplyShader;
import com.seibel.distanthorizons.core.render.renderer.shaders.FogShader;
import com.seibel.distanthorizons.core.util.RenderUtil;
import com.seibel.distanthorizons.core.wrapperInterfaces.minecraft.IMinecraftClientWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.minecraft.IMinecraftRenderWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.minecraft.IProfilerWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.misc.ILightMapWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.modAccessor.AbstractOptifineAccessor;
import com.seibel.distanthorizons.core.wrapperInterfaces.modAccessor.IIrisAccessor;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.IClientLevelWrapper;
import com.seibel.distanthorizons.coreapi.util.math.Mat4f;
import com.seibel.distanthorizons.coreapi.util.math.Vec3d;
import com.seibel.distanthorizons.coreapi.util.math.Vec3f;
import java.awt.Color;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.lwjgl.opengl.GL32;

public class LodRenderer {
    public static final ConfigBasedLogger EVENT_LOGGER = new ConfigBasedLogger(LogManager.getLogger(LodRenderer.class), () -> Config.Client.Advanced.Logging.logRendererBufferEvent.get());
    public static ConfigBasedSpamLogger tickLogger = new ConfigBasedSpamLogger(LogManager.getLogger(LodRenderer.class), () -> Config.Client.Advanced.Logging.logRendererBufferEvent.get(), 1);
    private static final IIrisAccessor IRIS_ACCESSOR = ModAccessorInjector.INSTANCE.get(IIrisAccessor.class);
    public static final boolean ENABLE_DRAW_LAG_SPIKE_LOGGING = false;
    public static final boolean ENABLE_DUMP_GL_STATE = true;
    public static final long DRAW_LAG_SPIKE_THRESHOLD_NS = TimeUnit.NANOSECONDS.convert(20L, TimeUnit.MILLISECONDS);
    public static final boolean ENABLE_IBO = true;
    public static boolean transparencyEnabled = true;
    public static boolean fakeOceanFloor = true;
    private static final ReentrantLock renderLock = new ReentrantLock();
    private static int activeFramebufferId = -1;
    private static int activeColorTextureId = -1;
    private static int activeDepthTextureId = -1;
    private int cachedWidth;
    private int cachedHeight;
    private static final IMinecraftClientWrapper MC = SingletonInjector.INSTANCE.get(IMinecraftClientWrapper.class);
    private static final IMinecraftRenderWrapper MC_RENDER = SingletonInjector.INSTANCE.get(IMinecraftRenderWrapper.class);
    private final ReentrantLock setupLock = new ReentrantLock();
    public final RenderBufferHandler bufferHandler;
    LodRenderProgram shaderProgram = null;
    public QuadElementBuffer quadIBO = null;
    public boolean isSetupComplete = false;
    private DhFramebuffer framebuffer;
    private DhColorTexture colorTexture;
    private DHDepthTexture depthTexture;
    private boolean usingMcFrameBuffer = false;
    private boolean rendererClosed = false;
    private static final Logger LOGGER = LogManager.getLogger();

    public void setupOffset(DhBlockPos pos) throws IllegalStateException {
        Vec3d cam = MC_RENDER.getCameraExactPosition();
        Vec3f modelPos = new Vec3f((float)((double)pos.x - cam.x), (float)((double)pos.y - cam.y), (float)((double)pos.z - cam.z));
        if (!GL32.glIsProgram((int)this.shaderProgram.id)) {
            throw new IllegalStateException("No GL program exists with the ID: [" + this.shaderProgram.id + "]. This either means a shader program was freed while it was still in use or was never created.");
        }
        this.shaderProgram.bind();
        this.shaderProgram.setModelPos(modelPos);
    }

    public void drawVbo(GLVertexBuffer vbo) {
        vbo.bind();
        this.shaderProgram.bindVertexBuffer(vbo.getId());
        GL32.glDrawElements((int)4, (int)(vbo.getVertexCount() / 4 * 6), (int)this.quadIBO.getType(), (long)0L);
        vbo.unbind();
    }

    public Vec3f getLookVector() {
        return MC_RENDER.getLookAtVector();
    }

    public LodRenderer(RenderBufferHandler bufferHandler) {
        this.bufferHandler = bufferHandler;
    }

    public void close() {
        if (this.rendererClosed) {
            EVENT_LOGGER.warn("close() called twice!", new Object[0]);
            return;
        }
        this.rendererClosed = true;
        renderLock.lock();
        try {
            EVENT_LOGGER.info("Shutting down " + LodRenderer.class.getSimpleName() + "...", new Object[0]);
            this.cleanup();
            this.bufferHandler.close();
            EVENT_LOGGER.info("Finished shutting down " + LodRenderer.class.getSimpleName(), new Object[0]);
        }
        finally {
            renderLock.unlock();
        }
    }

    public void resize(int width, int height) {
        this.colorTexture.resize(width, height);
        this.depthTexture.resize(width, height, EDhDepthBufferFormat.DEPTH32F);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawLODs(IClientLevelWrapper clientLevelWrapper, Mat4f baseModelViewMatrix, Mat4f baseProjectionMatrix, float partialTicks, IProfilerWrapper profiler) {
        if (this.rendererClosed) {
            EVENT_LOGGER.error("drawLODs() called after close()!", new Object[0]);
            return;
        }
        if (AbstractOptifineAccessor.optifinePresent() && MC_RENDER.getTargetFrameBuffer() == -1) {
            return;
        }
        if (!renderLock.tryLock()) {
            return;
        }
        try {
            if (IRIS_ACCESSOR != null && IRIS_ACCESSOR.isRenderingShadowPass()) {
                return;
            }
            ILightMapWrapper lightmap = MC_RENDER.getLightmapWrapper(clientLevelWrapper);
            if (lightmap == null) {
                return;
            }
            LagSpikeCatcher drawSaveGLState = new LagSpikeCatcher();
            GLState minecraftGlState = new GLState();
            tickLogger.debug("Saving GL state: " + minecraftGlState, new Object[0]);
            drawSaveGLState.end("drawSaveGLState");
            profiler.push("LOD draw setup");
            if (!this.isSetupComplete) {
                this.setup();
                if (!this.isSetupComplete) {
                    return;
                }
            }
            if (MC_RENDER.getTargetFrameBufferViewportWidth() != this.cachedWidth || MC_RENDER.getTargetFrameBufferViewportHeight() != this.cachedHeight) {
                this.cachedWidth = MC_RENDER.getTargetFrameBufferViewportWidth();
                this.cachedHeight = MC_RENDER.getTargetFrameBufferViewportHeight();
                this.resize(this.cachedWidth, this.cachedHeight);
            }
            this.setActiveFramebufferId(this.framebuffer.getId());
            this.setActiveDepthTextureId(this.depthTexture.getTextureId());
            this.setActiveColorTextureId(this.colorTexture.getTextureId());
            this.framebuffer.bind();
            if (this.usingMcFrameBuffer) {
                GL32.glClear((int)256);
            } else {
                GL32.glClear((int)16640);
            }
            GL32.glEnable((int)2929);
            GL32.glDepthFunc((int)513);
            boolean renderWireframe = Config.Client.Advanced.Debugging.renderWireframe.get();
            if (renderWireframe) {
                GL32.glPolygonMode((int)1032, (int)6913);
            } else {
                GL32.glPolygonMode((int)1032, (int)6914);
                GL32.glEnable((int)2884);
            }
            GL32.glEnable((int)2929);
            GL32.glDepthFunc((int)513);
            GL32.glDepthMask((boolean)true);
            GL32.glDisable((int)3042);
            if (!this.isSetupComplete) {
                this.setup();
            } else {
                LodFogConfig newFogConfig = this.shaderProgram.isShaderUsable();
                if (newFogConfig != null) {
                    this.shaderProgram.free();
                    this.shaderProgram = new LodRenderProgram(newFogConfig);
                    FogShader.INSTANCE.free();
                    FogShader.INSTANCE = new FogShader(newFogConfig);
                }
                this.shaderProgram.bind();
            }
            Mat4f projectionMatrix = RenderUtil.createLodProjectionMatrix(baseProjectionMatrix, partialTicks);
            Mat4f modelViewProjectionMatrix = new Mat4f(projectionMatrix);
            modelViewProjectionMatrix.multiply(RenderUtil.createLodModelViewMatrix(baseModelViewMatrix));
            this.shaderProgram.fillUniformData(modelViewProjectionMatrix, 0, MC.getWrappedClientLevel().getMinHeight(), partialTicks);
            lightmap.bind();
            this.quadIBO.bind();
            this.bufferHandler.buildRenderListAndUpdateSections(this.getLookVector());
            LagSpikeCatcher drawLagSpikeCatcher = new LagSpikeCatcher();
            profiler.popPush("LOD Opaque");
            this.bufferHandler.renderOpaque(this);
            if (Config.Client.Advanced.Graphics.Ssao.enabled.get().booleanValue()) {
                profiler.popPush("LOD SSAO");
                SSAORenderer.INSTANCE.render(minecraftGlState, projectionMatrix, partialTicks);
            }
            profiler.popPush("LOD Fog");
            FogShader.INSTANCE.setModelViewProjectionMatrix(modelViewProjectionMatrix);
            FogShader.INSTANCE.render(partialTicks);
            transparencyEnabled = Config.Client.Advanced.Graphics.Quality.transparency.get().transparencyEnabled;
            fakeOceanFloor = Config.Client.Advanced.Graphics.Quality.transparency.get().fakeTransparencyEnabled;
            if (Config.Client.Advanced.Graphics.Quality.transparency.get().transparencyEnabled) {
                profiler.popPush("LOD Transparent");
                GL32.glEnable((int)3042);
                GL32.glBlendEquation((int)32774);
                GL32.glBlendFunc((int)1, (int)771);
                this.bufferHandler.renderTransparent(this);
                GL32.glDepthMask((boolean)true);
                FogShader.INSTANCE.render(partialTicks);
            }
            if (this.usingMcFrameBuffer) {
                GL32.glClear((int)256);
            }
            drawLagSpikeCatcher.end("LodDraw");
            profiler.popPush("LOD Apply");
            GLState dhApplyGlState = new GLState();
            DhApplyShader.INSTANCE.render(partialTicks);
            dhApplyGlState.restore();
            profiler.popPush("LOD cleanup");
            LagSpikeCatcher drawCleanup = new LagSpikeCatcher();
            lightmap.unbind();
            this.quadIBO.unbind();
            this.shaderProgram.unbind();
            if (Config.Client.Advanced.Debugging.DebugWireframe.enableRendering.get().booleanValue()) {
                profiler.popPush("Debug wireframes");
                DebugRenderer.INSTANCE.render(modelViewProjectionMatrix);
                profiler.popPush("LOD cleanup");
            }
            minecraftGlState.restore();
            drawCleanup.end("LodDrawCleanup");
            profiler.pop();
            tickLogger.incLogTries();
        }
        finally {
            renderLock.unlock();
        }
    }

    private void setup() {
        if (this.isSetupComplete) {
            EVENT_LOGGER.warn("Renderer setup called but it has already completed setup!", new Object[0]);
            return;
        }
        if (GLProxy.getInstance() == null) {
            EVENT_LOGGER.warn("Renderer setup called but GLProxy has not yet been setup!", new Object[0]);
            return;
        }
        try {
            this.setupLock.lock();
            EVENT_LOGGER.info("Setting up renderer", new Object[0]);
            this.isSetupComplete = true;
            this.shaderProgram = new LodRenderProgram(LodFogConfig.generateFogConfig());
            this.quadIBO = new QuadElementBuffer();
            this.quadIBO.reserve(AbstractRenderBuffer.MAX_QUADS_PER_BUFFER);
            if (AbstractOptifineAccessor.optifinePresent()) {
                int currentFrameBufferId = MC_RENDER.getTargetFrameBuffer();
                this.framebuffer = new DhFramebuffer(currentFrameBufferId);
                this.usingMcFrameBuffer = true;
            } else {
                this.framebuffer = new DhFramebuffer();
                this.usingMcFrameBuffer = false;
            }
            this.colorTexture = DhColorTexture.builder().setDimensions(MC_RENDER.getTargetFrameBufferViewportWidth(), MC_RENDER.getTargetFrameBufferViewportHeight()).setInternalFormat(EDhInternalTextureFormat.RGBA8).setPixelType(EDhPixelType.UNSIGNED_BYTE).setPixelFormat(EDhPixelFormat.RGBA).build();
            this.depthTexture = new DHDepthTexture(MC_RENDER.getTargetFrameBufferViewportWidth(), MC_RENDER.getTargetFrameBufferViewportHeight(), EDhDepthBufferFormat.DEPTH32F);
            this.framebuffer.addDepthAttachment(this.depthTexture.getTextureId(), EDhDepthBufferFormat.DEPTH32F);
            this.framebuffer.addColorAttachment(0, this.colorTexture.getTextureId());
            this.cachedWidth = MC_RENDER.getTargetFrameBufferViewportWidth();
            this.cachedHeight = MC_RENDER.getTargetFrameBufferViewportHeight();
            if (this.framebuffer.getStatus() != 36053) {
                tickLogger.warn("FrameBuffer [" + this.framebuffer.getId() + "] isn't complete.", new Object[0]);
            }
            EVENT_LOGGER.info("Renderer setup complete", new Object[0]);
        }
        finally {
            this.setupLock.unlock();
        }
    }

    private Color getFogColor(float partialTicks) {
        Color fogColor = Config.Client.Advanced.Graphics.Fog.colorMode.get() == EFogColorMode.USE_SKY_COLOR ? MC_RENDER.getSkyColor() : MC_RENDER.getFogColor(partialTicks);
        return fogColor;
    }

    private Color getSpecialFogColor(float partialTicks) {
        return MC_RENDER.getSpecialFogColor(partialTicks);
    }

    private void setActiveFramebufferId(int frameBufferId) {
        activeFramebufferId = frameBufferId;
    }

    public static int getActiveFramebufferId() {
        return activeFramebufferId;
    }

    private void setActiveColorTextureId(int colorTextureId) {
        activeColorTextureId = colorTextureId;
    }

    public static int getActiveColorTextureId() {
        return activeColorTextureId;
    }

    private void setActiveDepthTextureId(int depthTextureId) {
        activeDepthTextureId = depthTextureId;
    }

    public static int getActiveDepthTextureId() {
        return activeDepthTextureId;
    }

    private void cleanup() {
        if (GLProxy.getInstance() == null) {
            EVENT_LOGGER.warn("Renderer Cleanup called but the GLProxy has never been initialized!", new Object[0]);
            return;
        }
        try {
            this.setupLock.lock();
            EVENT_LOGGER.info("Queuing Renderer Cleanup for main render thread", new Object[0]);
            GLProxy.getInstance().recordOpenGlCall(() -> {
                EVENT_LOGGER.info("Renderer Cleanup Started", new Object[0]);
                if (this.shaderProgram != null) {
                    this.shaderProgram.free();
                    this.shaderProgram = null;
                }
                if (this.quadIBO != null) {
                    this.quadIBO.destroy(false);
                }
                if (this.framebuffer != null && !this.usingMcFrameBuffer) {
                    this.framebuffer.destroyInternal();
                }
                if (this.colorTexture != null) {
                    this.colorTexture.destroy();
                }
                if (this.depthTexture != null) {
                    this.depthTexture.destroy();
                }
                EVENT_LOGGER.info("Renderer Cleanup Complete", new Object[0]);
            });
        }
        catch (Exception e) {
            this.setupLock.unlock();
        }
    }

    public static class LagSpikeCatcher {
        long timer = System.nanoTime();

        public void end(String source) {
        }
    }
}

