/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.render.renderer.shaders;

import com.seibel.distanthorizons.core.config.Config;
import com.seibel.distanthorizons.core.render.glObject.shader.ShaderProgram;
import com.seibel.distanthorizons.core.render.renderer.LodRenderer;
import com.seibel.distanthorizons.core.render.renderer.ScreenQuad;
import com.seibel.distanthorizons.core.render.renderer.shaders.AbstractShaderRenderer;
import com.seibel.distanthorizons.coreapi.util.math.Mat4f;
import org.lwjgl.opengl.GL32;

public class SSAOShader
extends AbstractShaderRenderer {
    public static SSAOShader INSTANCE = new SSAOShader();
    public int FrameBuffer;
    private Mat4f projection;
    private Mat4f invertedProjection;
    public int gProjUniform;
    public int gInvProjUniform;
    public int gSampleCountUniform;
    public int gRadiusUniform;
    public int gStrengthUniform;
    public int gMinLightUniform;
    public int gBiasUniform;
    public int gDepthMapUniform;

    @Override
    public void onInit() {
        this.shader = new ShaderProgram("shaders/normal.vert", "shaders/ssao/ao.frag", "fragColor", new String[]{"vPosition"});
        this.gProjUniform = this.shader.getUniformLocation("gProj");
        this.gInvProjUniform = this.shader.getUniformLocation("gInvProj");
        this.gSampleCountUniform = this.shader.getUniformLocation("gSampleCount");
        this.gRadiusUniform = this.shader.getUniformLocation("gRadius");
        this.gStrengthUniform = this.shader.getUniformLocation("gStrength");
        this.gMinLightUniform = this.shader.getUniformLocation("gMinLight");
        this.gBiasUniform = this.shader.getUniformLocation("gBias");
        this.gDepthMapUniform = this.shader.getUniformLocation("gDepthMap");
    }

    public void setProjectionMatrix(Mat4f projectionMatrix) {
        this.projection = projectionMatrix;
        this.invertedProjection = new Mat4f(projectionMatrix);
        this.invertedProjection.invert();
    }

    @Override
    protected void onApplyUniforms(float partialTicks) {
        this.shader.setUniform(this.gProjUniform, this.projection);
        this.shader.setUniform(this.gInvProjUniform, this.invertedProjection);
        this.shader.setUniform(this.gSampleCountUniform, Config.Client.Advanced.Graphics.Ssao.sampleCount.get());
        this.shader.setUniform(this.gRadiusUniform, Config.Client.Advanced.Graphics.Ssao.radius.get().floatValue());
        this.shader.setUniform(this.gStrengthUniform, Config.Client.Advanced.Graphics.Ssao.strength.get().floatValue());
        this.shader.setUniform(this.gMinLightUniform, Config.Client.Advanced.Graphics.Ssao.minLight.get().floatValue());
        this.shader.setUniform(this.gBiasUniform, Config.Client.Advanced.Graphics.Ssao.bias.get().floatValue());
        GL32.glActiveTexture((int)33984);
        GL32.glBindTexture((int)3553, (int)LodRenderer.getActiveDepthTextureId());
        GL32.glUniform1i((int)this.gDepthMapUniform, (int)0);
    }

    @Override
    protected void onRender() {
        GL32.glBindFramebuffer((int)36160, (int)this.FrameBuffer);
        GL32.glDisable((int)3089);
        GL32.glDisable((int)2929);
        GL32.glDisable((int)3042);
        ScreenQuad.INSTANCE.render();
    }
}

