/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.sql;

import com.seibel.distanthorizons.api.enums.worldGeneration.EDhApiWorldGenerationStep;
import com.seibel.distanthorizons.core.file.metaData.BaseMetaData;
import com.seibel.distanthorizons.core.pos.DhSectionPos;
import com.seibel.distanthorizons.core.sql.AbstractDhRepo;
import com.seibel.distanthorizons.core.sql.MetaDataDto;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Map;

public abstract class AbstractMetaDataRepo
extends AbstractDhRepo<MetaDataDto> {
    public AbstractMetaDataRepo(String databaseType, String databaseLocation) throws SQLException {
        super(databaseType, databaseLocation, MetaDataDto.class);
    }

    @Override
    public String getPrimaryKeyName() {
        return "DhSectionPos";
    }

    @Override
    public MetaDataDto convertDictionaryToDto(Map<String, Object> objectMap) throws ClassCastException {
        String posString = (String)objectMap.get("DhSectionPos");
        DhSectionPos pos = DhSectionPos.deserialize(posString);
        int checksum = (Integer)objectMap.get("Checksum");
        long dataVersion = (Long)objectMap.get("DataVersion");
        byte dataDetailLevel = (Byte)objectMap.get("DataDetailLevel");
        String worldGenStepString = (String)objectMap.get("WorldGenStep");
        EDhApiWorldGenerationStep worldGenStep = EDhApiWorldGenerationStep.fromName(worldGenStepString);
        String dataType = (String)objectMap.get("DataType");
        byte binaryDataFormatVersion = (Byte)objectMap.get("BinaryDataFormatVersion");
        BaseMetaData baseMetaData = new BaseMetaData(pos, checksum, dataDetailLevel, worldGenStep, dataType, binaryDataFormatVersion, dataVersion);
        byte[] dataByteArray = (byte[])objectMap.get("Data");
        MetaDataDto metaFile = new MetaDataDto(baseMetaData, dataByteArray);
        return metaFile;
    }

    @Override
    public String createSelectPrimaryKeySql(String primaryKey) {
        return "SELECT * FROM " + this.getTableName() + " WHERE DhSectionPos = '" + primaryKey + "'";
    }

    @Override
    public PreparedStatement createInsertStatement(MetaDataDto dto) throws SQLException {
        String sql = "INSERT INTO " + this.getTableName() + "\n  (DhSectionPos, \nChecksum, DataVersion, DataDetailLevel, WorldGenStep, DataType, BinaryDataFormatVersion, \nData) \n   VALUES( \n    ? \n   ,? ,? ,? ,? ,? ,? \n   ,? \n);";
        PreparedStatement statement = this.createPreparedStatement(sql);
        int i = 1;
        statement.setObject(i++, dto.getPrimaryKeyString());
        statement.setObject(i++, dto.baseMetaData.checksum);
        statement.setObject(i++, dto.baseMetaData.dataVersion);
        statement.setObject(i++, dto.baseMetaData.dataDetailLevel);
        statement.setObject(i++, (Object)dto.baseMetaData.worldGenStep);
        statement.setObject(i++, dto.baseMetaData.dataType);
        statement.setObject(i++, dto.baseMetaData.binaryDataFormatVersion);
        statement.setObject(i++, dto.dataArray);
        return statement;
    }

    @Override
    public PreparedStatement createUpdateStatement(MetaDataDto dto) throws SQLException {
        String sql = "UPDATE " + this.getTableName() + " \nSET \n    Checksum = ? \n   ,DataVersion = ? \n   ,DataDetailLevel = ? \n   ,WorldGenStep = ? \n   ,DataType = ? \n   ,BinaryDataFormatVersion = ? \n   ,Data = ? \n   ,LastModifiedDateTime = CURRENT_TIMESTAMP \nWHERE DhSectionPos = ?";
        PreparedStatement statement = this.createPreparedStatement(sql);
        int i = 1;
        statement.setObject(i++, dto.baseMetaData.checksum);
        statement.setObject(i++, dto.baseMetaData.dataVersion);
        statement.setObject(i++, dto.baseMetaData.dataDetailLevel);
        statement.setObject(i++, (Object)dto.baseMetaData.worldGenStep);
        statement.setObject(i++, dto.baseMetaData.dataType);
        statement.setObject(i++, dto.baseMetaData.binaryDataFormatVersion);
        statement.setObject(i++, dto.dataArray);
        statement.setObject(i++, dto.getPrimaryKeyString());
        return statement;
    }
}

