/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.util;

import it.unimi.dsi.fastutil.booleans.BooleanObjectImmutablePair;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.function.Predicate;

public class AtomicsUtil {
    public static <T> T conditionalAndExchange(AtomicReference<T> atomic, Predicate<T> requirement, T newValue) {
        T oldValue;
        do {
            if (requirement.test(oldValue = atomic.get())) continue;
            return oldValue;
        } while (!atomic.weakCompareAndSet(oldValue, newValue));
        return oldValue;
    }

    public static <T> BooleanObjectImmutablePair<T> conditionalAndExchangeWeak(AtomicReference<T> atomic, Predicate<T> requirement, T newValue) {
        T oldValue = atomic.get();
        if (requirement.test(oldValue) && atomic.weakCompareAndSet(oldValue, newValue)) {
            return new BooleanObjectImmutablePair(true, oldValue);
        }
        return new BooleanObjectImmutablePair(false, oldValue);
    }

    public static <T> T compareAndExchange(AtomicReference<T> atomic, T expected, T newValue) {
        do {
            T oldValue;
            if ((oldValue = atomic.get()) == expected) continue;
            return oldValue;
        } while (!atomic.weakCompareAndSet(expected, newValue));
        return expected;
    }

    public static <T> BooleanObjectImmutablePair<T> compareAndExchangeWeak(AtomicReference<T> atomic, T expected, T newValue) {
        T oldValue = atomic.get();
        if (oldValue == expected && atomic.weakCompareAndSet(expected, newValue)) {
            return new BooleanObjectImmutablePair(true, expected);
        }
        return new BooleanObjectImmutablePair(false, oldValue);
    }

    public static <T> T compareAndSetThenGet(AtomicReference<T> atomic, T expected, T newValue) {
        do {
            T oldValue;
            if ((oldValue = atomic.get()) == expected) continue;
            return oldValue;
        } while (!atomic.weakCompareAndSet(expected, newValue));
        return newValue;
    }

    public static <T> T compareAndExchange(AtomicReferenceArray<T> array, int index, T expected, T newValue) {
        do {
            T oldValue;
            if ((oldValue = array.get(index)) == expected) continue;
            return oldValue;
        } while (!array.weakCompareAndSet(index, expected, newValue));
        return expected;
    }

    public static <T> BooleanObjectImmutablePair<T> compareAndExchangeWeak(AtomicReferenceArray<T> array, int index, T expected, T newValue) {
        T oldValue = array.get(index);
        if (oldValue == expected && array.weakCompareAndSet(index, expected, newValue)) {
            return new BooleanObjectImmutablePair(true, expected);
        }
        return new BooleanObjectImmutablePair(false, oldValue);
    }

    public static <T> T compareAndSetThenGet(AtomicReferenceArray<T> array, int index, T expected, T newValue) {
        do {
            T oldValue;
            if ((oldValue = array.get(index)) == expected) continue;
            return oldValue;
        } while (!array.weakCompareAndSet(index, expected, newValue));
        return newValue;
    }
}

