/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.util;

import com.seibel.distanthorizons.api.enums.config.EVanillaOverdraw;
import com.seibel.distanthorizons.core.dependencyInjection.SingletonInjector;
import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import com.seibel.distanthorizons.core.pos.DhChunkPos;
import com.seibel.distanthorizons.core.pos.Pos2D;
import com.seibel.distanthorizons.core.render.vertexFormat.DefaultLodVertexFormats;
import com.seibel.distanthorizons.core.render.vertexFormat.LodVertexFormat;
import com.seibel.distanthorizons.core.util.ColorUtil;
import com.seibel.distanthorizons.core.util.gridList.EdgeDistanceBooleanGrid;
import com.seibel.distanthorizons.core.util.objects.UncheckedInterruptedException;
import com.seibel.distanthorizons.core.wrapperInterfaces.minecraft.IMinecraftClientWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.minecraft.IMinecraftRenderWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.IDimensionTypeWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.ILevelWrapper;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletionException;
import java.util.concurrent.RejectedExecutionException;
import org.apache.logging.log4j.Logger;

public class LodUtil {
    private static final IMinecraftClientWrapper MC_CLIENT = SingletonInjector.INSTANCE.get(IMinecraftClientWrapper.class);
    private static final IMinecraftRenderWrapper MC_RENDER = SingletonInjector.INSTANCE.get(IMinecraftRenderWrapper.class);
    private static final Logger LOGGER = DhLoggerBuilder.getLogger();
    public static final int MINIMUM_RENDER_DISTANCE_FOR_PARTIAL_OVERDRAW = 4;
    public static final int MINIMUM_RENDER_DISTANCE_FOR_FAR_OVERDRAW = 11;
    public static final int MAX_NUMBER_OF_VERTICAL_LODS = 32;
    public static final int DEBUG_ALPHA = 255;
    public static final int COLOR_DEBUG_BLACK = ColorUtil.rgbToInt(255, 0, 0, 0);
    public static final int COLOR_DEBUG_WHITE = ColorUtil.rgbToInt(255, 255, 255, 255);
    public static final int COLOR_INVISIBLE = ColorUtil.rgbToInt(0, 0, 0, 0);
    public static final int[] DEBUG_DETAIL_LEVEL_COLORS = new int[]{ColorUtil.rgbToInt(255, 0, 0), ColorUtil.rgbToInt(255, 127, 0), ColorUtil.rgbToInt(255, 255, 0), ColorUtil.rgbToInt(127, 255, 0), ColorUtil.rgbToInt(0, 255, 0), ColorUtil.rgbToInt(0, 255, 127), ColorUtil.rgbToInt(0, 255, 255), ColorUtil.rgbToInt(0, 127, 255), ColorUtil.rgbToInt(0, 0, 255), ColorUtil.rgbToInt(127, 0, 255), ColorUtil.rgbToInt(255, 0, 255), ColorUtil.rgbToInt(255, 127, 255), ColorUtil.rgbToInt(255, 255, 255)};
    public static final byte REGION_DETAIL_LEVEL = 9;
    public static final byte CHUNK_DETAIL_LEVEL = 4;
    public static final byte BLOCK_DETAIL_LEVEL = 0;
    public static final short REGION_WIDTH = 512;
    public static final short CHUNK_WIDTH = 16;
    public static final int REGION_WIDTH_IN_CHUNKS = 32;
    public static final String INVALID_FILE_CHARACTERS_REGEX = "[\\\\/:*?\"<>|]";
    public static final int MAX_ALLOCATABLE_DIRECT_MEMORY = 0x4000000;
    public static final LodVertexFormat LOD_VERTEX_FORMAT = DefaultLodVertexFormats.POSITION_COLOR_BLOCK_LIGHT_SKY_LIGHT;

    public static ILevelWrapper getServerWorldFromDimension(IDimensionTypeWrapper newDimension) {
        if (!MC_CLIENT.hasSinglePlayerServer()) {
            return null;
        }
        ArrayList<ILevelWrapper> worlds = MC_CLIENT.getAllServerWorlds();
        ILevelWrapper returnWorld = null;
        for (ILevelWrapper world : worlds) {
            if (world.getDimensionType() != newDimension) continue;
            returnWorld = world;
            break;
        }
        return returnWorld;
    }

    public static int computeOverdrawOffset() {
        int chunkRenderDist = MC_RENDER.getRenderDistance() + 1;
        EVanillaOverdraw overdraw = EVanillaOverdraw.ALWAYS;
        if (overdraw == EVanillaOverdraw.ALWAYS) {
            return Integer.MAX_VALUE;
        }
        int offset = overdraw == EVanillaOverdraw.NEVER ? 0 : (chunkRenderDist < 11 ? 1 : chunkRenderDist / 5);
        if (chunkRenderDist - offset <= 1) {
            return Integer.MAX_VALUE;
        }
        return offset;
    }

    @Deprecated
    public static EdgeDistanceBooleanGrid readVanillaRenderedChunks() {
        int offset = LodUtil.computeOverdrawOffset();
        if (offset == Integer.MAX_VALUE) {
            return null;
        }
        int renderDist = MC_RENDER.getRenderDistance() + 1;
        final Iterator<DhChunkPos> posIter = MC_RENDER.getVanillaRenderedChunks().iterator();
        return new EdgeDistanceBooleanGrid(new Iterator<Pos2D>(){

            @Override
            public boolean hasNext() {
                return posIter.hasNext();
            }

            @Override
            public Pos2D next() {
                DhChunkPos pos = (DhChunkPos)posIter.next();
                return new Pos2D(pos.x, pos.z);
            }
        }, LodUtil.MC_CLIENT.getPlayerChunkPos().x - renderDist, LodUtil.MC_CLIENT.getPlayerChunkPos().z - renderDist, renderDist * 2 + 1);
    }

    public static boolean checkRamUsage(double minFreeMemoryPercent, int minFreeMemoryMB) {
        long freeMem = Runtime.getRuntime().freeMemory() + Runtime.getRuntime().maxMemory() - Runtime.getRuntime().totalMemory();
        if (freeMem < (long)minFreeMemoryMB * 1024L * 1024L) {
            return false;
        }
        long maxMem = Runtime.getRuntime().maxMemory();
        return !((double)freeMem / (double)maxMem < minFreeMemoryPercent);
    }

    public static void checkInterrupts() throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
    }

    public static String formatLog(String str, Object ... param) {
        return LOGGER.getMessageFactory().newMessage(str, param).getFormattedMessage();
    }

    public static String shortenString(String str, int maxLength) {
        if (str == null) {
            return "";
        }
        return str.substring(0, Math.min(str.length(), maxLength));
    }

    public static void debugBreak() {
        boolean a = false;
    }

    public static void assertTrue(boolean condition) {
        if (!condition) {
            throw new AssertFailureException("Assertion failed");
        }
    }

    public static void assertTrue(boolean condition, String message) {
        if (!condition) {
            throw new AssertFailureException("Assertion failed:\n " + message);
        }
    }

    public static void assertTrue(boolean condition, String message, Object ... args) {
        if (!condition) {
            throw new AssertFailureException("Assertion failed:\n " + LodUtil.formatLog(message, args));
        }
    }

    public static void assertNotReach() {
        throw new AssertFailureException("Assert Not Reach failed");
    }

    public static void assertNotReach(String message) {
        throw new AssertFailureException("Assert Not Reach failed:\n " + message);
    }

    public static void assertNotReach(String message, Object ... args) {
        throw new AssertFailureException("Assert Not Reach failed:\n " + LodUtil.formatLog(message, args));
    }

    public static void assertToDo() {
        throw new AssertFailureException("TODO!");
    }

    public static Throwable ensureUnwrap(Throwable t) {
        return t instanceof CompletionException ? LodUtil.ensureUnwrap(t.getCause()) : t;
    }

    public static boolean isInterruptOrReject(Throwable t) {
        Throwable unwrapped = LodUtil.ensureUnwrap(t);
        return UncheckedInterruptedException.isInterrupt(unwrapped) || unwrapped instanceof RejectedExecutionException || unwrapped instanceof CancellationException;
    }

    public static class AssertFailureException
    extends RuntimeException {
        public AssertFailureException(String message) {
            super(message);
            LodUtil.debugBreak();
        }
    }
}

