/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.wrapperInterfaces.minecraft;

import com.seibel.distanthorizons.core.dependencyInjection.ModAccessorInjector;
import com.seibel.distanthorizons.core.dependencyInjection.SingletonInjector;
import com.seibel.distanthorizons.core.pos.DhBlockPos;
import com.seibel.distanthorizons.core.pos.DhChunkPos;
import com.seibel.distanthorizons.core.wrapperInterfaces.IVersionConstants;
import com.seibel.distanthorizons.core.wrapperInterfaces.IWrapperFactory;
import com.seibel.distanthorizons.core.wrapperInterfaces.minecraft.IMinecraftClientWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.misc.ILightMapWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.modAccessor.ISodiumAccessor;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.IClientLevelWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.ILevelWrapper;
import com.seibel.distanthorizons.coreapi.interfaces.dependencyInjection.IBindable;
import com.seibel.distanthorizons.coreapi.util.math.Mat4f;
import com.seibel.distanthorizons.coreapi.util.math.Vec3d;
import com.seibel.distanthorizons.coreapi.util.math.Vec3f;
import java.awt.Color;
import java.util.HashSet;
import org.jetbrains.annotations.Nullable;

public interface IMinecraftRenderWrapper
extends IBindable {
    public Vec3f getLookAtVector();

    public DhBlockPos getCameraBlockPosition();

    public boolean playerHasBlindingEffect();

    public Vec3d getCameraExactPosition();

    public Mat4f getDefaultProjectionMatrix(float var1);

    public double getGamma();

    public Color getFogColor(float var1);

    default public Color getSpecialFogColor(float partialTicks) {
        return this.getFogColor(partialTicks);
    }

    public boolean isFogStateSpecial();

    public Color getSkyColor();

    public double getFov(float var1);

    public int getRenderDistance();

    public int getScreenWidth();

    public int getScreenHeight();

    public int getTargetFrameBuffer();

    public int getDepthTextureId();

    public int getTargetFrameBufferViewportWidth();

    public int getTargetFrameBufferViewportHeight();

    public void clearTargetFrameBuffer();

    default public HashSet<DhChunkPos> getVanillaRenderedChunks() {
        ISodiumAccessor sodium = ModAccessorInjector.INSTANCE.get(ISodiumAccessor.class);
        return sodium == null ? this.getMaximumRenderedChunks() : sodium.getNormalRenderedChunks();
    }

    public static boolean correctedCheckRadius(int dx, int dz, int radius2Mul4) {
        return (dx *= 2) * dx + (dz *= 2) * dz <= radius2Mul4;
    }

    default public HashSet<DhChunkPos> getMaximumRenderedChunks() {
        IMinecraftClientWrapper mcWrapper = SingletonInjector.INSTANCE.get(IMinecraftClientWrapper.class);
        IWrapperFactory factory = SingletonInjector.INSTANCE.get(IWrapperFactory.class);
        IVersionConstants versionConstants = SingletonInjector.INSTANCE.get(IVersionConstants.class);
        IMinecraftClientWrapper minecraft = SingletonInjector.INSTANCE.get(IMinecraftClientWrapper.class);
        IClientLevelWrapper clientWorld = minecraft.getWrappedClientLevel();
        int chunkDist = this.getRenderDistance() + 1;
        DhChunkPos centerChunkPos = mcWrapper.getPlayerChunkPos();
        int centerChunkX = centerChunkPos.x;
        int centerChunkZ = centerChunkPos.z;
        int chunkDist2Mul4 = chunkDist * chunkDist * 4;
        HashSet<DhChunkPos> renderedPos = new HashSet<DhChunkPos>();
        for (int deltaChunkX = -chunkDist; deltaChunkX <= chunkDist; ++deltaChunkX) {
            for (int deltaChunkZ = -chunkDist; deltaChunkZ <= chunkDist; ++deltaChunkZ) {
                if (!versionConstants.isVanillaRenderedChunkSquare() && !IMinecraftRenderWrapper.correctedCheckRadius(deltaChunkX, deltaChunkZ, chunkDist2Mul4) || !clientWorld.hasChunkLoaded(centerChunkX + deltaChunkX, centerChunkZ + deltaChunkZ)) continue;
                renderedPos.add(new DhChunkPos(centerChunkX + deltaChunkX, centerChunkZ + deltaChunkZ));
            }
        }
        return renderedPos;
    }

    @Nullable
    public ILightMapWrapper getLightmapWrapper(ILevelWrapper var1);
}

